/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.paper;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.ttools.plot.Point3D;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.paper.PaintPaperType;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;

public class SortedPaperType3D
extends PaintPaperType
implements PaperType3D {
    public SortedPaperType3D() {
        super("Sorted", true);
    }

    @Override
    protected Paper createPaper(Graphics g, Rectangle bounds) {
        return new SortedPaper3D(this, (Graphics2D)g, bounds);
    }

    @Override
    public void placeGlyph(Paper paper, double dx, double dy, double dz, Glyph glyph, Color color) {
        ((SortedPaper3D)paper).placeGlyph(dx, dy, dz, glyph, color);
    }

    @Override
    public void placeDecal(Paper paper, Decal decal) {
        ((SortedPaper3D)paper).placeDecal(decal);
    }

    @Override
    protected void flushPaper(Paper paper) {
        ((SortedPaper3D)paper).flush();
    }

    private static class Packer {
        final double s0_;
        final double sFact_;
        final double d0_;
        final double dFact_;

        Packer(double dBase, double dExtent) {
            double sBase = 3276.7000000000003;
            double sExtent = 26213.600000000002;
            this.s0_ = sBase - dBase * sExtent / dExtent;
            this.d0_ = dBase - sBase * dExtent / sExtent;
            this.sFact_ = sExtent / dExtent;
            this.dFact_ = dExtent / sExtent;
        }

        short toShort(double d) {
            return (short)(this.s0_ + this.sFact_ * d);
        }

        double fromShort(short s) {
            return this.d0_ + this.dFact_ * (double)s;
        }
    }

    private static class PlacedGlyph
    extends Point3D {
        final short sx_;
        final short sy_;
        final Glyph glyph_;
        final Color color_;

        PlacedGlyph(Glyph glyph, short sx, short sy, double dz, Color color, int iseq) {
            super(iseq, dz);
            this.sx_ = sx;
            this.sy_ = sy;
            this.glyph_ = glyph;
            this.color_ = color;
        }
    }

    private static class SortedPaper3D
    implements Paper {
        final PaperType paperType_;
        final Graphics2D graphics_;
        final Rectangle bounds_;
        final Packer xPacker_;
        final Packer yPacker_;
        final List<PlacedGlyph> list_;
        int iseq_;

        SortedPaper3D(PaperType paperType, Graphics2D graphics, Rectangle bounds) {
            this.paperType_ = paperType;
            this.graphics_ = graphics;
            this.bounds_ = bounds;
            this.xPacker_ = new Packer(bounds.x, bounds.width);
            this.yPacker_ = new Packer(bounds.y, bounds.height);
            this.list_ = new ArrayList<PlacedGlyph>();
        }

        @Override
        public PaperType getPaperType() {
            return this.paperType_;
        }

        @Override
        public boolean canMerge() {
            return true;
        }

        @Override
        public Paper createSheet() {
            return new SortedPaper3D(this.getPaperType(), this.graphics_, this.bounds_);
        }

        @Override
        public void mergeSheet(Paper other) {
            SortedPaper3D sOther = (SortedPaper3D)other;
            this.list_.addAll(sOther.list_);
            this.iseq_ = Math.max(this.iseq_, sOther.iseq_);
        }

        void placeGlyph(double gx, double gy, double dz, Glyph glyph, Color color) {
            short sx = this.xPacker_.toShort(gx);
            short sy = this.yPacker_.toShort(gy);
            this.list_.add(new PlacedGlyph(glyph, sx, sy, dz, color, this.iseq_++));
        }

        void placeDecal(Decal decal) {
            decal.paintDecal(this.graphics_);
        }

        void flush() {
            List<PlacedGlyph> points = this.getSortedPoints();
            Color color0 = this.graphics_.getColor();
            for (PlacedGlyph pg : points) {
                double px = this.xPacker_.fromShort(pg.sx_);
                double py = this.yPacker_.fromShort(pg.sy_);
                this.graphics_.setColor(pg.color_);
                this.graphics_.translate(px, py);
                pg.glyph_.paintGlyph(this.graphics_);
                this.graphics_.translate(-px, -py);
            }
            this.graphics_.setColor(color0);
        }

        List<PlacedGlyph> getSortedPoints() {
            if (!SortedPaper3D.singleColor(this.list_)) {
                Collections.sort(this.list_, Point3D.getComparator(false, true));
            }
            return this.list_;
        }

        private static boolean singleColor(List<PlacedGlyph> list) {
            if (list.size() > 0) {
                Iterator<PlacedGlyph> it = list.iterator();
                Color color = it.next().color_;
                while (it.hasNext()) {
                    if (PlotUtil.equals(color, it.next().color_)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

