/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.paper;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Arrays;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.ttools.plot2.paper.RgbPaperType3D;

public class ZBufferPaperType3D
extends RgbPaperType3D {
    public ZBufferPaperType3D() {
        super("ZBuffer", true);
    }

    @Override
    protected RgbPaperType3D.RgbPaper3D createPaper3D(Rectangle bounds) {
        return new ZBufferPaper(this, bounds);
    }

    private static class ZBufferPaper
    extends RgbPaperType3D.RgbPaper3D {
        private final int[] rgbs_ = this.getRgbImage().getBuffer();
        private final float[] zs_;
        private Color lastColor_;
        private int lastRgb_;

        public ZBufferPaper(PaperType paperType, Rectangle bounds) {
            super(paperType, bounds);
            this.zs_ = new float[bounds.width * bounds.height];
            Arrays.fill(this.zs_, Float.POSITIVE_INFINITY);
        }

        @Override
        protected void placePixels(int xoff, int yoff, double dz, Pixer pixer, Color color) {
            if (color != this.lastColor_) {
                this.lastColor_ = color;
                this.lastRgb_ = color.getRGB();
            }
            int rgb = this.lastRgb_;
            float fz = (float)dz;
            while (pixer.next()) {
                int index = this.getPixelIndex(xoff, yoff, pixer);
                if (!(fz <= this.zs_[index])) continue;
                this.zs_[index] = fz;
                this.rgbs_[index] = rgb;
            }
        }

        @Override
        public boolean canMerge() {
            return true;
        }

        @Override
        public Paper createSheet() {
            return new ZBufferPaper(this.getPaperType(), this.getBounds());
        }

        @Override
        public void mergeSheet(Paper other) {
            ZBufferPaper zbOther = (ZBufferPaper)other;
            int[] rgbs1 = zbOther.rgbs_;
            float[] zs1 = zbOther.zs_;
            int n = this.rgbs_.length;
            for (int i = 0; i < n; ++i) {
                float z1 = zs1[i];
                if (!(z1 < this.zs_[i])) continue;
                this.zs_[i] = z1;
                this.rgbs_[i] = rgbs1[i];
            }
        }

        @Override
        public void flush() {
        }
    }
}

