/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.Icon;
import uk.ac.starlink.table.Domain;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.GangContext;
import uk.ac.starlink.ttools.plot2.GangerFactory;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.PlotCaching;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotScene;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.ShadeAxisFactory;
import uk.ac.starlink.ttools.plot2.ShadeAxisKit;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.Trimming;
import uk.ac.starlink.ttools.plot2.ZoneContent;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.RampKeySet;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.DataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.Input;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.geom.MatrixFormat;
import uk.ac.starlink.ttools.plot2.geom.MatrixGanger;
import uk.ac.starlink.ttools.plot2.geom.MatrixPlotType;
import uk.ac.starlink.ttools.plot2.geom.MatrixShape;
import uk.ac.starlink.ttools.plot2.geom.PlaneAspect;
import uk.ac.starlink.ttools.plot2.geom.PlaneDataGeom;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.XyKeyPair;
import uk.ac.starlink.ttools.plot2.paper.Compositor;
import uk.ac.starlink.ttools.plot2.paper.PaperTypeSelector;
import uk.ac.starlink.ttools.plot2.task.AbstractPlot2Task;
import uk.ac.starlink.ttools.plot2.task.ConfigParameter;
import uk.ac.starlink.ttools.plot2.task.ConfigParameterFactory;
import uk.ac.starlink.ttools.plot2.task.CoordValue;
import uk.ac.starlink.ttools.plot2.task.JELDataSpec;
import uk.ac.starlink.ttools.plot2.task.ParameterFinder;
import uk.ac.starlink.ttools.plot2.task.PlotConfiguration;
import uk.ac.starlink.ttools.plot2.task.PlotContext;
import uk.ac.starlink.ttools.plot2.task.TypedPlot2Task;

public class MatrixPlot2Task
extends TypedPlot2Task<PlaneSurfaceFactory.Profile, PlaneAspect> {
    private final Parameter<?>[] params_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.task");
    private static final MatrixPlotType PLOT_TYPE = MatrixPlotType.getInstance();
    private static final boolean XDIAG = true;
    private static final Map<ConfigKey<?>, XyKeyPair<?>> XYKEY_MAP = Collections.unmodifiableMap(MatrixPlot2Task.createXyKeyPairMap());

    public MatrixPlot2Task() {
        super(PLOT_TYPE, null);
        Map<String, XyKeyPair> xyNameMap = XYKEY_MAP.entrySet().stream().collect(Collectors.toMap(e -> ((ConfigKey)e.getKey()).getMeta().getShortName(), e -> (XyKeyPair)e.getValue()));
        ArrayList paramList = new ArrayList();
        for (Parameter<?> param : super.getParameters()) {
            String pname = param.getName();
            XyKeyPair xyKey = xyNameMap.get(pname);
            if (xyKey != null) {
                if (pname.equals(xyKey.getKeyX().getMeta().getShortName())) {
                    paramList.add(MatrixPlot2Task.createExampleXyParameter(xyKey));
                    continue;
                }
                assert (pname.equals(xyKey.getKeyY().getMeta().getShortName()));
                continue;
            }
            if (pname.equals(PlaneSurfaceFactory.XYFACTOR_KEY.getMeta().getShortName())) continue;
            paramList.add(param);
        }
        this.params_ = paramList.toArray(new Parameter[0]);
    }

    @Override
    public String getPurpose() {
        return "Draws a matrix of plane plots";
    }

    @Override
    public Parameter<?>[] getParameters() {
        return this.params_;
    }

    @Override
    protected <P, A> PlotConfiguration<P, A> createPlotConfiguration(Environment env, PlotContext<P, A> context) throws TaskException {
        PlotConfiguration<PlaneSurfaceFactory.Profile, PlaneAspect> planeConfig;
        PlotContext<PlaneSurfaceFactory.Profile, PlaneAspect> planeContext = context;
        PlotConfiguration<PlaneSurfaceFactory.Profile, PlaneAspect> config = planeConfig = this.createPlanePlotConfiguration(env, planeContext);
        return config;
    }

    private PlotConfiguration<PlaneSurfaceFactory.Profile, PlaneAspect> createPlanePlotConfiguration(Environment env, PlotContext<PlaneSurfaceFactory.Profile, PlaneAspect> context) throws TaskException {
        String[] legendSeq;
        final PlaneSurfaceFactory surfFact = PLOT_TYPE.getSurfaceFactory();
        final PaperTypeSelector ptSel = PLOT_TYPE.getPaperTypeSelector();
        GangerFactory<PlaneSurfaceFactory.Profile, PlaneAspect> gangerFact = PLOT_TYPE.getGangerFactory();
        Map<String, Plotter<?>> plotterMap = MatrixPlot2Task.getPlotters(env, context);
        String[] layerSeq = (String[])this.getSequenceParameter().objectValue(env);
        if (layerSeq == null || layerSeq.length == 0) {
            layerSeq = plotterMap.keySet().toArray(new String[0]);
        }
        if ((legendSeq = (String[])this.getLegendSequenceParameter().objectValue(env)) == null || legendSeq.length == 0) {
            legendSeq = layerSeq;
        }
        LinkedHashMap activePlotterMap = new LinkedHashMap(plotterMap);
        activePlotterMap.keySet().retainAll(Arrays.asList(layerSeq));
        final Plotter[] activePlotters = activePlotterMap.values().toArray(new Plotter[0]);
        GangContext gangContext = new GangContext(){

            @Override
            public Plotter<?>[] getPlotters() {
                return activePlotters;
            }

            @Override
            public String[] getRequestedZoneNames() {
                return new String[0];
            }
        };
        Padding padding = (Padding)this.getPaddingParameter().objectValue(env);
        ConfigMap gangConfig = MatrixPlot2Task.createBasicConfigMap(env, gangerFact.getGangerKeys());
        final MatrixGanger ganger = (MatrixGanger)gangerFact.createGanger(padding, gangConfig, gangContext);
        MatrixShape shape = ganger.getShape();
        final int nz = ganger.getZoneCount();
        final int xpix = this.getXpixParameter().intValue(env);
        final int ypix = this.getYpixParameter().intValue(env);
        final boolean forceBitmap = this.getBitmapParameter().booleanValue(env);
        final DataStoreFactory storeFact = (DataStoreFactory)this.getDataStoreParameter().objectValue(env);
        final Compositor compositor = (Compositor)this.getCompositorParameter().objectValue(env);
        Map<String, PlotLayer[]> layersMap = this.createLayersMap(env, context, shape);
        PlotLayer[] allLayers = (PlotLayer[])layersMap.values().stream().flatMap(Arrays::stream).filter(layer -> layer != null).toArray(PlotLayer[]::new);
        final DataSpec[] dataSpecs = (DataSpec[])Arrays.stream(allLayers).map(PlotLayer::getDataSpec).filter(d -> d != null).toArray(DataSpec[]::new);
        ConfigKey<?>[] profileKeys = MatrixPlot2Task.getMatrixProfileKeys(surfFact);
        ConfigKey<?>[] aspectKeys = surfFact.getAspectKeys();
        ConfigKey<?>[] navKeys = surfFact.getNavigatorKeys();
        ConfigKey[] shadeKeys = new ConfigKey[]{StyleKeys.SHADE_LOW, StyleKeys.SHADE_HIGH};
        ConfigKey<?>[] auxKeys = StyleKeys.AUX_RAMP.getKeys();
        ConfigMap aspectConfig0 = MatrixPlot2Task.createBasicConfigMap(env, aspectKeys);
        final ConfigMap navConfig = MatrixPlot2Task.createBasicConfigMap(env, navKeys);
        ConfigMap shadeConfig = MatrixPlot2Task.createBasicConfigMap(env, shadeKeys);
        ConfigMap auxConfig = MatrixPlot2Task.createBasicConfigMap(env, auxKeys);
        LinkedHashMap<String, PlotLayer> layerMap = new LinkedHashMap<String, PlotLayer>();
        for (Map.Entry<String, PlotLayer[]> entry : layersMap.entrySet()) {
            PlotLayer layer1 = Arrays.stream((Object[])entry.getValue()).filter(l -> l != null).findFirst().orElse(null);
            if (layer1 == null) continue;
            layerMap.put(entry.getKey(), layer1);
        }
        Icon legend = this.createLegend(env, layerMap, "", legendSeq);
        String title = this.createTitleParameter(null).stringValue(env);
        float[] legPos = this.createLegendPositionParameter(null).floatsValue(env);
        final Trimming[] trimmings = new Trimming[]{new Trimming(legend, legPos, title)};
        Span shadeFixSpan = PlotUtil.createSpan(shadeConfig.get(StyleKeys.SHADE_LOW), shadeConfig.get(StyleKeys.SHADE_HIGH));
        RampKeySet.Ramp ramp = StyleKeys.AUX_RAMP.createValue(auxConfig);
        ShadeAxisFactory shadeFact = this.createShadeAxisFactory(env, allLayers, "");
        final ShadeAxisKit[] shadeKits = new ShadeAxisKit[]{new ShadeAxisKit(shadeFact, shadeFixSpan, null)};
        PlaneSurfaceFactory.Profile[] initialProfiles = PlotUtil.createProfileArray(surfFact, nz);
        final ConfigMap[] aspectConfigs = new ConfigMap[nz];
        for (int iz = 0; iz < nz; ++iz) {
            MatrixShape.Cell cell = shape.getCell(iz);
            int ix = cell.getX();
            int iy = cell.getY();
            ConfigMap profileConfig = this.createCellConfigMap(env, profileKeys, cell, layerSeq);
            PlaneSurfaceFactory.Profile profile = (PlaneSurfaceFactory.Profile)surfFact.createProfile(profileConfig);
            ConfigMap aspectConfig = this.createCellConfigMap(env, aspectKeys, cell, layerSeq);
            initialProfiles[iz] = profile;
            aspectConfigs[iz] = aspectConfig;
        }
        final PlaneSurfaceFactory.Profile[] profiles = ganger.adjustProfiles(initialProfiles);
        ArrayList layerLists = new ArrayList(nz);
        for (int iz = 0; iz < nz; ++iz) {
            layerLists.add(new ArrayList());
        }
        for (String suffix : layerSeq) {
            PlotLayer[] layers = layersMap.get(suffix);
            for (int iz = 0; iz < nz; ++iz) {
                PlotLayer layer2 = layers[iz];
                if (layer2 == null) continue;
                ((List)layerLists.get(iz)).add(layer2);
            }
        }
        final PlotLayer[][] layerArrays = new PlotLayer[nz][];
        for (int iz = 0; iz < nz; ++iz) {
            layerArrays[iz] = ((List)layerLists.get(iz)).toArray(new PlotLayer[0]);
        }
        return new PlotConfiguration<PlaneSurfaceFactory.Profile, PlaneAspect>(){

            @Override
            public DataStore createDataStore(DataStore prevStore) throws IOException, InterruptedException {
                long t0 = System.currentTimeMillis();
                DataStore store = storeFact.readDataStore(dataSpecs, prevStore);
                PlotUtil.logTimeFromStart(logger_, "Data", t0);
                return store;
            }

            @Override
            public Dimension getPlotSize() {
                return new Dimension(xpix, ypix);
            }

            @Override
            public Navigator<PlaneAspect> createNavigator() {
                return surfFact.createNavigator(navConfig);
            }

            @Override
            public PlotScene<PlaneSurfaceFactory.Profile, PlaneAspect> createPlotScene(DataStore dataStore, PlotCaching caching) {
                return PlotScene.createGangScene(ganger, surfFact, layerArrays, profiles, aspectConfigs, trimmings, shadeKits, ptSel, compositor, dataStore, caching);
            }

            @Override
            public Icon createPlotIcon(DataStore dataStore) {
                ZoneContent<P, A>[] contents = PlotUtil.createZoneContentArray(surfFact, nz);
                long t0 = System.currentTimeMillis();
                for (int iz = 0; iz < nz; ++iz) {
                    PlaneSurfaceFactory.Profile profile = profiles[iz];
                    ConfigMap config = aspectConfigs[iz];
                    PlotLayer[] layers = layerArrays[iz];
                    Range[] ranges = surfFact.useRanges(profile, config) ? surfFact.readRanges(profile, layers, dataStore) : null;
                    PlaneAspect aspect = (PlaneAspect)surfFact.createAspect(profile, config, ranges);
                    contents[iz] = new ZoneContent<PlaneSurfaceFactory.Profile, PlaneAspect>(profile, aspect, layers);
                }
                return AbstractPlot2Task.createPlotIcon(ganger, surfFact, contents, trimmings, shadeKits, ptSel, compositor, dataStore, xpix, ypix, forceBitmap);
            }
        };
    }

    private ConfigMap createCellConfigMap(Environment env, ConfigKey<?>[] keys, MatrixShape.Cell cell, final String[] suffixes) throws TaskException {
        int ix = cell.getX();
        int iy = cell.getY();
        final HashMap icMap = new HashMap();
        for (ConfigKey<?> key : keys) {
            int icoord;
            ConfigKey<?> yKey;
            XyKeyPair<?> xyKey = XYKEY_MAP.get(key);
            ConfigKey<?> xKey = xyKey == null ? null : xyKey.getKeyX();
            ConfigKey<?> configKey = yKey = xyKey == null ? null : xyKey.getKeyY();
            if (key.equals(xKey)) {
                if (ix == iy) {
                    // empty if block
                }
                icoord = ix;
            } else {
                icoord = key.equals(yKey) && ix != iy ? iy : -1;
            }
            if (icoord < 0) continue;
            icMap.put(key, icoord);
        }
        ConfigParameterFactory cpFact = new ConfigParameterFactory(){

            @Override
            public <T> ConfigParameter<T> getParameter(Environment env, ConfigKey<T> key) throws TaskException {
                if (icMap.containsKey(key)) {
                    String dflt;
                    int icoord = (Integer)icMap.get(key);
                    String coordName = MatrixPlotType.getCoordMeta(icoord).getShortName();
                    XyKeyPair keyPair = (XyKeyPair)XYKEY_MAP.get(key);
                    ConfigParameter param = new ConfigParameter(keyPair.createKey(coordName));
                    if ((key == PlaneSurfaceFactory.XLABEL_KEY || key == PlaneSurfaceFactory.YLABEL_KEY) && (dflt = MatrixPlot2Task.getPosCoordExpression(env, icoord, suffixes)) != null) {
                        param.setStringDefault(dflt);
                    }
                    return param;
                }
                return new ConfigParameter<T>(key);
            }
        };
        return MatrixPlot2Task.createConfigMap(env, keys, cpFact);
    }

    private Map<String, PlotLayer[]> createLayersMap(Environment env, PlotContext<?, ?> context, MatrixShape shape) throws TaskException {
        Map<String, Plotter<?>> plotterMap = MatrixPlot2Task.getPlotters(env, context);
        LinkedHashMap<String, PlotLayer[]> layersMap = new LinkedHashMap<String, PlotLayer[]>();
        PlaneSurfaceFactory surfFact = PLOT_TYPE.getSurfaceFactory();
        for (Map.Entry<String, Plotter<?>> entry : plotterMap.entrySet()) {
            String suffix = entry.getKey();
            Plotter<?> plotter = entry.getValue();
            layersMap.put(suffix, this.createPlotLayers(env, suffix, plotter, surfFact, shape));
        }
        return layersMap;
    }

    private <S extends Style> PlotLayer[] createPlotLayers(Environment env, String layerSuffix, Plotter<S> plotter, SurfaceFactory<?, ?> surfFact, MatrixShape shape) throws TaskException {
        S style;
        ConfigMap profileConfig = MatrixPlot2Task.createBasicConfigMap(env, MatrixPlot2Task.getMatrixProfileKeys(surfFact));
        ConfigMap captionConfig = MatrixPlot2Task.createBasicConfigMap(env, StyleKeys.CAPTIONER.getKeys());
        ConfigMap layerConfig = MatrixPlot2Task.createLayerSuffixedConfigMap(env, plotter.getStyleKeys(), layerSuffix);
        ConfigMap auxConfig = MatrixPlot2Task.createBasicConfigMap(env, StyleKeys.AUX_RAMP.getKeys());
        ConfigMap config = new ConfigMap();
        config.putAll(profileConfig);
        config.putAll(captionConfig);
        config.putAll(auxConfig);
        config.putAll(layerConfig);
        try {
            style = plotter.createStyle(config);
            assert (style.equals(plotter.createStyle(config)));
        }
        catch (ConfigException e) {
            throw new UsageException(e.getConfigKey().getMeta().getShortName() + ": " + e.getMessage(), (Throwable)e);
        }
        CoordGroup cgrp = plotter.getCoordGroup();
        boolean isOnDiag = MatrixFormat.isOnDiagonal(cgrp);
        boolean isOffDiag = MatrixFormat.isOffDiagonal(cgrp);
        int npos = cgrp.getBasicPositionCount();
        Coord[] extraCoords = cgrp.getExtraCoords();
        boolean hasPos = npos + cgrp.getExtraPositionCount() > 0;
        PlaneDataGeom geom = hasPos ? PlaneDataGeom.INSTANCE : null;
        StarTable table = MatrixPlot2Task.getInputTable(env, layerSuffix);
        int ncell = shape.getCellCount();
        PlotLayer[] layers = new PlotLayer[ncell];
        for (int icell = 0; icell < ncell; ++icell) {
            int iex0;
            boolean hasCell;
            MatrixShape.Cell cell = shape.getCell(icell);
            int ix = cell.getX();
            int iy = cell.getY();
            Coord[] posCoords = hasPos ? geom.getPosCoords() : new Coord[]{};
            ArrayList<CoordValue> cvlist = new ArrayList<CoordValue>();
            if (isOffDiag) {
                if (ix != iy) {
                    hasCell = true;
                    for (int ipos = 0; ipos < npos; ++ipos) {
                        String posSuffix = npos > 1 ? PlotUtil.getIndexSuffix(ipos) : "";
                        cvlist.add(MatrixPlot2Task.getPosCoordValue(env, ix, posSuffix, layerSuffix, true));
                        cvlist.add(MatrixPlot2Task.getPosCoordValue(env, iy, posSuffix, layerSuffix, true));
                    }
                } else {
                    hasCell = false;
                }
            } else if (isOnDiag) {
                if (ix == iy) {
                    hasCell = true;
                    cvlist.add(MatrixPlot2Task.getPosCoordValue(env, ix, "", layerSuffix, true));
                } else {
                    hasCell = false;
                }
            } else {
                hasCell = true;
            }
            if (!hasCell) continue;
            for (int iex = iex0 = isOnDiag ? 1 : 0; iex < extraCoords.length; ++iex) {
                cvlist.add(MatrixPlot2Task.getCoordValue(env, extraCoords[iex], layerSuffix));
            }
            CoordValue[] coordVals = cvlist.toArray(new CoordValue[0]);
            JELDataSpec dataSpec = new JELDataSpec(table, null, coordVals);
            layers[icell] = plotter.createLayer(geom, dataSpec, style);
        }
        return layers;
    }

    private static Map<ConfigKey<?>, XyKeyPair<?>> createXyKeyPairMap() {
        HashMap map = new HashMap();
        for (XyKeyPair<?> xy : PLOT_TYPE.getSurfaceFactory().getXyKeyPairs()) {
            map.put(xy.getKeyX(), xy);
            map.put(xy.getKeyY(), xy);
        }
        return map;
    }

    private static ConfigKey<?>[] getMatrixProfileKeys(SurfaceFactory<?, ?> surfFact) {
        return (ConfigKey[])Arrays.stream(surfFact.getProfileKeys()).filter(k -> k != PlaneSurfaceFactory.XYFACTOR_KEY).toArray(ConfigKey[]::new);
    }

    private static StringParameter createPosCoordParameter(int icoord, String posSuffix, String layerSuffix, boolean fullDetail) {
        int ic1 = icoord + 1;
        boolean hasLayerSuffix = layerSuffix.length() > 0;
        boolean hasPosSuffix = posSuffix.length() > 0;
        Input templateInput = PlaneDataGeom.X_COORD.getInputs()[0];
        InputMeta templateMeta = templateInput.getMeta();
        String cName = templateMeta.getShortName() + posSuffix + ic1;
        Domain<?> domain = templateInput.getDomain();
        StringParameter param = new StringParameter(cName + layerSuffix);
        String prompt = "Value " + (hasPosSuffix ? posSuffix + " " : "") + "for plot coordinate " + ic1;
        if (fullDetail) {
            prompt = prompt + (hasLayerSuffix ? ", for layer " + layerSuffix : "");
        }
        StringBuffer dbuf = new StringBuffer().append("<p>Numeric value for coordinate #").append(ic1).append(" in the matrix plot.\n").append("N such values must be supplied for an NxN grid ").append("of scatter plots.\n").append("</p>\n");
        dbuf.append("<p>");
        if (fullDetail) {
            dbuf.append("This parameter gives a column name, ").append("fixed value, or algebraic expression for the\n").append("<code>").append(cName).append("</code> coordinate\n");
            if (hasLayerSuffix) {
                dbuf.append("for layer <code>").append(layerSuffix).append("</code>");
            }
            dbuf.append(".\n");
        }
        dbuf.append("The value is a numeric algebraic expression ").append("based on column names\n").append("as described in <ref id='jel'/>.\n").append("</p>\n");
        param.setDescription(dbuf.toString());
        param.setUsage("<expr>");
        return param;
    }

    private static CoordValue getPosCoordValue(Environment env, final int icoord, final String posSuffix, String layerSuffix, boolean requireValue) throws TaskException {
        FloatingCoord templateCoord = PlaneDataGeom.X_COORD;
        Object exprParam = new ParameterFinder<Parameter<String>>(){

            @Override
            public Parameter<String> createParameter(String sfix) {
                return MatrixPlot2Task.createPosCoordParameter(icoord, posSuffix, sfix, true);
            }
        }.getParameter(env, layerSuffix);
        exprParam.setNullPermitted(!requireValue);
        String expr = exprParam.stringValue(env);
        return new CoordValue(templateCoord, new String[]{expr}, new DomainMapper[]{null});
    }

    private static String getPosCoordExpression(Environment env, int icoord, String[] layerSuffixes) throws TaskException {
        String posSuffix = "";
        for (String layerSuffix : layerSuffixes) {
            String expr;
            CoordValue cval = MatrixPlot2Task.getPosCoordValue(env, icoord, posSuffix, layerSuffix, false);
            String[] exprs = cval.getExpressions();
            if (exprs.length <= 0 || (expr = exprs[0]) == null || expr.trim().length() <= 0) continue;
            return expr;
        }
        return null;
    }

    private static <T> Parameter<T> createExampleXyParameter(XyKeyPair<T> xyKey) {
        String descrip;
        ConfigKey<T> key = xyKey.createKey("xK");
        ConfigParameter<T> param = new ConfigParameter<T>(key);
        param.setName(param.getName().replaceFirst("[xX][kK]", "xK"));
        String prompt = param.getPrompt();
        if (prompt != null) {
            param.setPrompt(prompt.replaceAll(" [xX][kK] ", " xK "));
        }
        if ((descrip = param.getDescription()) != null) {
            descrip = descrip.replaceAll(" [xX][kK] ", " xK ");
            descrip = descrip + String.join((CharSequence)"\n", "<p>The xK axis refers to any axes in the matrix", "on which input coordinate #K is plotted.", "Hence", "<code>" + xyKey.createKey("x2").getMeta().getShortName() + "</code>", "affects the axes on which the <code>x2</code> coordinates", "are plotted.", "</p>", "");
            param.setDescription(descrip);
        }
        return param;
    }
}

