/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.GangerFactory;
import uk.ac.starlink.ttools.plot2.PlotType;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.SkySysConfigKey;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.geom.CubePlotType;
import uk.ac.starlink.ttools.plot2.geom.MatrixGangerFactory;
import uk.ac.starlink.ttools.plot2.geom.MatrixPlotType;
import uk.ac.starlink.ttools.plot2.geom.MatrixShape;
import uk.ac.starlink.ttools.plot2.geom.PlanePlotType;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.SkyPlotType;
import uk.ac.starlink.ttools.plot2.geom.SkySurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.SkySys;
import uk.ac.starlink.ttools.plot2.geom.SpherePlotType;
import uk.ac.starlink.ttools.plot2.geom.TimePlotType;
import uk.ac.starlink.ttools.plot2.geom.XyKeyPair;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.layer.ShapeModePlotter;
import uk.ac.starlink.ttools.plot2.task.AbstractPlot2Task;
import uk.ac.starlink.ttools.plot2.task.CoordSpec;
import uk.ac.starlink.ttools.plot2.task.LayerSpec;
import uk.ac.starlink.ttools.plot2.task.PlotContext;
import uk.ac.starlink.ttools.plot2.task.PlotSpec;
import uk.ac.starlink.ttools.plot2.task.ShadeSpec;
import uk.ac.starlink.ttools.plot2.task.Suffixer;
import uk.ac.starlink.ttools.plot2.task.TrimmingSpec;
import uk.ac.starlink.ttools.plot2.task.TypedPlot2Task;
import uk.ac.starlink.ttools.task.CredibleString;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.InputTableParameter;
import uk.ac.starlink.ttools.task.Setting;
import uk.ac.starlink.ttools.task.SettingGroup;
import uk.ac.starlink.ttools.task.StiltsCommand;
import uk.ac.starlink.ttools.task.TableNamer;
import uk.ac.starlink.util.LoadException;

public class PlotStiltsCommand
extends StiltsCommand {
    private final AbstractPlot2Task plotTask_;
    private static final ConfigKey<?>[] AUX_KEYS = PlotStiltsCommand.getAuxKeys();

    public PlotStiltsCommand(AbstractPlot2Task task, String taskName, SettingGroup[] groups) {
        super(task, taskName, groups);
        this.plotTask_ = task;
    }

    @Override
    public AbstractPlot2Task getTask() {
        return this.plotTask_;
    }

    private static AbstractPlot2Task createTask(String taskName) throws LoadException {
        return (AbstractPlot2Task)Stilts.getPlot2TaskFactory().createObject(taskName);
    }

    public static <P, A> PlotStiltsCommand createPlotCommand(PlotSpec<P, A> plotSpec, TableNamer tableNamer, Suffixer layerSuffixer, Suffixer zoneSuffixer) throws LoadException {
        String ltype;
        int iz;
        PlotType<P, A> plotType = plotSpec.getPlotType();
        Dimension extSize = plotSpec.getExtSize();
        ConfigMap globalConfig = plotSpec.getGlobalConfig();
        ConfigMap[] zoneConfigs = plotSpec.getZoneConfigs();
        TrimmingSpec[] trimSpecs = plotSpec.getTrimmingSpecs();
        ShadeSpec[] shadeSpecs = plotSpec.getShadeSpecs();
        LayerSpec[] layerSpecs = plotSpec.getLayerSpecs();
        GangerFactory<P, A> gangerFact = plotType.getGangerFactory();
        boolean hasIndependentZones = gangerFact.hasIndependentZones();
        int nz = zoneConfigs.length;
        boolean isShadeGlobal = nz > 1 && shadeSpecs.length == 1;
        boolean isTrimGlobal = nz > 1 && trimSpecs.length == 1;
        String taskName = PlotStiltsCommand.getPlotTaskName(plotType);
        AbstractPlot2Task task = PlotStiltsCommand.createTask(taskName);
        ArrayList<Setting> taskSettings = new ArrayList<Setting>();
        if (extSize != null) {
            Integer xp = extSize.width;
            Integer yp = extSize.height;
            taskSettings.add(PlotStiltsCommand.createParamSetting(task.getXpixParameter(), xp));
            taskSettings.add(PlotStiltsCommand.createParamSetting(task.getYpixParameter(), yp));
        }
        taskSettings.addAll(Arrays.asList(PlotStiltsCommand.createParamSetting(task.getPaddingParameter(), plotSpec.getPadding())));
        ConfigKey<?>[] gangKeys = gangerFact.getGangerKeys();
        ArrayList<Setting> globalSettings = new ArrayList<Setting>();
        globalSettings.addAll(PlotStiltsCommand.getConfigSettings(globalConfig, gangKeys));
        globalSettings.add(null);
        globalSettings.addAll(PlotStiltsCommand.getGlobalSettings(plotSpec));
        SurfaceFactory<P, A> sfact = plotType.getSurfaceFactory();
        ConfigKey<?>[] profileKeys = sfact.getProfileKeys();
        ConfigKey<?>[] aspectKeys = sfact.getAspectKeys();
        LinkedHashMap<String, ArrayList<Setting>> zoneSettings = new LinkedHashMap<String, ArrayList<Setting>>();
        String[] zkeys = zoneSuffixer.createSuffixes(nz).toArray(new String[0]);
        ZoneAdjuster[] zadjusters = new ZoneAdjuster[nz];
        for (iz = 0; iz < nz; ++iz) {
            ArrayList<LayerSpec> lspecs = new ArrayList<LayerSpec>();
            for (LayerSpec ls : layerSpecs) {
                if (ls.getZoneIndex() != iz) continue;
                lspecs.add(ls);
            }
            zadjusters[iz] = PlotStiltsCommand.createZoneAdjuster(zoneConfigs[iz], lspecs, plotType);
        }
        if (hasIndependentZones || nz == 1) {
            assert (!(plotSpec.getPlotType() instanceof MatrixPlotType));
            for (iz = 0; iz < nz; ++iz) {
                ConfigMap zoneConfig = zoneConfigs[iz];
                ArrayList<Setting> settings = new ArrayList<Setting>();
                settings.addAll(PlotStiltsCommand.getConfigSettings(zoneConfig, profileKeys));
                settings.add(null);
                settings.addAll(PlotStiltsCommand.getConfigSettings(zoneConfig, aspectKeys));
                settings.add(null);
                TrimmingSpec trimSpec = isTrimGlobal ? null : trimSpecs[iz];
                settings.addAll(PlotStiltsCommand.getTrimSettings(task, trimSpec));
                ShadeSpec shadeSpec = isShadeGlobal ? null : shadeSpecs[iz];
                settings.addAll(PlotStiltsCommand.getShadeSettings(task, shadeSpec));
                zadjusters[iz].adjustZoneSettings(settings);
                zoneSettings.put(zkeys[iz], settings);
            }
        }
        TrimmingSpec trimSpec = isTrimGlobal ? trimSpecs[0] : null;
        globalSettings.addAll(PlotStiltsCommand.getTrimSettings(task, trimSpec));
        ShadeSpec shadeSpec = isShadeGlobal ? shadeSpecs[0] : null;
        globalSettings.addAll(PlotStiltsCommand.getShadeSettings(task, shadeSpec));
        LinkedHashMap<String, String> layerTypes = new LinkedHashMap<String, String>();
        LinkedHashMap<String, ArrayList<Setting>> layerSettings = new LinkedHashMap<String, ArrayList<Setting>>();
        int nl = layerSpecs.length;
        ArrayList<String> legKeys = new ArrayList<String>(nl);
        List<String> lkeys = layerSuffixer.createSuffixes(nl);
        boolean excludeLegend = false;
        for (int il = 0; il < nl; ++il) {
            TrimmingSpec.LegendSpec legSpec;
            LayerSpec lspec = layerSpecs[il];
            int iz2 = lspec.getZoneIndex();
            ArrayList<Setting> lsettings = new ArrayList<Setting>();
            String lkey = lkeys.get(il);
            if (iz2 >= 0) {
                lsettings.add(new Setting("zone", zkeys[iz2], ""));
                lsettings.add(null);
            }
            Plotter<?> plotter = lspec.getPlotter();
            ArrayList<Setting> modeSettings = new ArrayList<Setting>();
            if (plotter instanceof ShapeModePlotter) {
                ShapeModePlotter sPlotter = (ShapeModePlotter)plotter;
                ShapeForm form = sPlotter.getForm();
                ShapeMode mode = sPlotter.getMode();
                ltype = form.getFormName();
                modeSettings.add(new Setting("shading", mode.getModeName(), null));
            } else {
                ltype = plotter.getPlotterName();
            }
            lsettings.addAll(PlotStiltsCommand.createInputTableSettings(lspec, tableNamer));
            lsettings.add(null);
            lsettings.addAll(PlotStiltsCommand.createGeomSettings(lspec, task));
            lsettings.addAll(PlotStiltsCommand.createCoordSettings(lspec));
            lsettings.add(null);
            lsettings.addAll(modeSettings);
            lsettings.addAll(PlotStiltsCommand.getConfigSettings(lspec.getConfig(), plotter.getStyleKeys()));
            if (iz2 >= 0) {
                zadjusters[iz2].adjustLayerSettings(lspec, lsettings);
            }
            lsettings.add(null);
            TrimmingSpec ztrimSpec = iz2 >= 0 && iz2 < trimSpecs.length && trimSpecs[iz2] != null ? trimSpecs[iz2] : trimSpec;
            TrimmingSpec.LegendSpec legendSpec = legSpec = ztrimSpec == null ? null : ztrimSpec.getLegendSpec();
            if (legSpec != null) {
                String leglabel = lspec.getLegendLabel();
                if (leglabel != null) {
                    lsettings.add(PlotStiltsCommand.createParamSetting(AbstractPlot2Task.createLabelParameter(""), leglabel));
                    legKeys.add(lkey);
                } else {
                    excludeLegend = true;
                }
                lsettings.add(null);
            }
            layerTypes.put(lkey, ltype);
            layerSettings.put(lkey, lsettings);
        }
        List<Setting> commonZoneSettings = PlotStiltsCommand.extractCommonSettings(zoneSettings.values());
        List<Setting> commonLayerSettings = PlotStiltsCommand.extractCommonSettings(layerSettings.values());
        ArrayList<Setting> trailSettings = new ArrayList<Setting>();
        if (lkeys.size() > 1) {
            Setting seqSetting = PlotStiltsCommand.createParamSetting(task.getSequenceParameter(), lkeys.toArray(new String[0]));
            trailSettings.add(PlotStiltsCommand.asDefaultSetting(seqSetting));
        }
        if (excludeLegend) {
            trailSettings.add(PlotStiltsCommand.createParamSetting(task.getLegendSequenceParameter(), legKeys.toArray(new String[0])));
        }
        trailSettings.add(null);
        trailSettings.add(PlotStiltsCommand.createParamSetting(AbstractPlot2Task.createPaintModeParameter().getOutputParameter(), null));
        ArrayList<SettingGroup> groups = new ArrayList<SettingGroup>();
        groups.addAll(PlotStiltsCommand.toGroups(1, taskSettings));
        groups.addAll(PlotStiltsCommand.toGroups(1, globalSettings));
        groups.addAll(PlotStiltsCommand.toGroups(1, commonZoneSettings));
        for (String zkey : zoneSettings.keySet()) {
            List zsettings = (List)zoneSettings.get(zkey);
            groups.addAll(PlotStiltsCommand.toGroups(1, PlotStiltsCommand.addSuffixes(zsettings, zkey)));
        }
        groups.addAll(PlotStiltsCommand.toGroups(1, commonLayerSettings));
        for (String lkey : layerTypes.keySet()) {
            ltype = (String)layerTypes.get(lkey);
            List lsettings = (List)layerSettings.get(lkey);
            groups.add(new SettingGroup(1, new Setting[]{new Setting("layer" + lkey, ltype, null)}));
            groups.addAll(PlotStiltsCommand.toGroups(2, PlotStiltsCommand.addSuffixes(lsettings, lkey)));
        }
        groups.addAll(PlotStiltsCommand.toGroups(1, trailSettings));
        return new PlotStiltsCommand(task, taskName, groups.toArray(new SettingGroup[0]));
    }

    private static String getPlotTaskName(PlotType<?, ?> ptype) {
        if (ptype instanceof MatrixPlotType) {
            return "plot2corner";
        }
        if (ptype instanceof PlanePlotType) {
            return "plot2plane";
        }
        if (ptype instanceof SkyPlotType) {
            return "plot2sky";
        }
        if (ptype instanceof CubePlotType) {
            return "plot2cube";
        }
        if (ptype instanceof SpherePlotType) {
            return "plot2sphere";
        }
        if (ptype instanceof TimePlotType) {
            return "plot2time";
        }
        throw new IllegalArgumentException("Unknown plot type " + ptype);
    }

    private static List<Setting> getShadeSettings(AbstractPlot2Task task, ShadeSpec shadeSpec) {
        ArrayList<Setting> settings = new ArrayList<Setting>();
        if (shadeSpec != null) {
            settings.addAll(PlotStiltsCommand.getConfigSettings(shadeSpec.getConfig(), AUX_KEYS));
            settings.add(null);
            boolean isVisible = shadeSpec.isVisible();
            settings.add(PlotStiltsCommand.createParamSetting(task.createAuxVisibleParameter(null), isVisible));
            if (isVisible) {
                settings.addAll(Arrays.asList(PlotStiltsCommand.createParamSetting(task.createAuxLabelParameter(null), shadeSpec.getLabel()), PlotStiltsCommand.createParamSetting(task.createAuxCrowdParameter(null), shadeSpec.getCrowding())));
            }
            settings.add(null);
        }
        return settings;
    }

    private static List<Setting> getTrimSettings(AbstractPlot2Task task, TrimmingSpec trimSpec) {
        ArrayList<Setting> settings = new ArrayList<Setting>();
        if (trimSpec != null) {
            settings.add(PlotStiltsCommand.createParamSetting(task.createTitleParameter(null), trimSpec.getTitle()));
            TrimmingSpec.LegendSpec legSpec = trimSpec.getLegendSpec();
            boolean hasLegend = legSpec != null;
            settings.add(PlotStiltsCommand.createParamSetting(task.getLegendParameter(), hasLegend));
            if (hasLegend) {
                settings.addAll(Arrays.asList(PlotStiltsCommand.createParamSetting(task.getLegendBorderParameter(), legSpec.hasBorder()), PlotStiltsCommand.createParamSetting(task.getLegendOpaqueParameter(), legSpec.isOpaque()), PlotStiltsCommand.createParamSetting(task.createLegendPositionParameter(null), PlotStiltsCommand.toDoubles(legSpec.getPosition()))));
            }
            settings.add(null);
        }
        return settings;
    }

    private static List<Setting> addSuffixes(List<Setting> settings, String suffix) {
        ArrayList<Setting> outList = new ArrayList<Setting>(settings.size());
        for (Setting s : settings) {
            outList.add(s == null ? null : s.appendSuffix(suffix));
        }
        return outList;
    }

    private static List<Setting> extractCommonSettings(Collection<List<Setting>> lists) {
        ArrayList<Setting> common = new ArrayList<Setting>();
        if (lists.size() > 1) {
            LinkedHashSet<String> allkeys = new LinkedHashSet<String>();
            for (List<Setting> list : lists) {
                for (Setting s : list) {
                    if (s == null) continue;
                    allkeys.add(s.getKey());
                }
            }
            for (String key : allkeys) {
                int nsame = 0;
                int ndiff = 0;
                Setting s0 = null;
                for (List<Setting> list : lists) {
                    Setting s1 = PlotStiltsCommand.findSetting(list, key);
                    if (s1 == null) continue;
                    if (s0 == null) {
                        s0 = s1;
                    }
                    if (s1.equals(s0)) {
                        ++nsame;
                        continue;
                    }
                    ++ndiff;
                }
                if (nsame <= true || ndiff != 0) continue;
                common.add(s0);
                for (List<Setting> list : lists) {
                    list.remove(s0);
                }
            }
        }
        return common;
    }

    private static Setting findSetting(List<Setting> settings, String key) {
        for (Setting s : settings) {
            if (s == null || !s.getKey().equals(key)) continue;
            return s;
        }
        return null;
    }

    private static List<Setting> getConfigSettings(ConfigMap config, ConfigKey<?>[] keys) {
        int nk = keys.length;
        ArrayList<Setting> settings = new ArrayList<Setting>(nk);
        for (int ik = 0; ik < nk; ++ik) {
            settings.add(PlotStiltsCommand.createConfigSetting(keys[ik], config));
        }
        return settings;
    }

    private static <T> Setting createConfigSetting(ConfigKey<T> key, ConfigMap map) {
        return PlotStiltsCommand.createNamedConfigSetting(key, map, PlotStiltsCommand.getSettingKey(key));
    }

    private static <T> Setting createNamedConfigSetting(ConfigKey<T> configKey, ConfigMap config, String settingKey) {
        return new Setting(settingKey, configKey.valueToString(config.get(configKey)), configKey.valueToString(configKey.getDefaultValue()));
    }

    private static String getSettingKey(ConfigKey<?> key) {
        return key.getMeta().getShortName();
    }

    private static Setting asDefaultSetting(Setting setting) {
        return setting.resetDefault(setting.getStringValue());
    }

    private static List<Setting> createInputTableSettings(LayerSpec lspec, TableNamer namer) {
        ArrayList settings = new ArrayList();
        StarTable table = lspec.getTable();
        if (table != null) {
            CredibleString selection = lspec.getSelectExpr();
            String suffix = "";
            InputTableParameter inParam = AbstractPlot2Task.createTableParameter(suffix);
            FilterParameter filterParam = AbstractPlot2Task.createFilterParameter(suffix, inParam);
            return StiltsCommand.createInputTableSettings(inParam, table, namer, filterParam, selection);
        }
        return Collections.emptyList();
    }

    private static List<Setting> createCoordSettings(LayerSpec lspec) {
        ArrayList<Setting> settings = new ArrayList<Setting>();
        for (CoordSpec cspec : lspec.getCoordSpecs()) {
            String inName = cspec.getInputName();
            settings.add(new Setting(inName, cspec.getValueExpr(), null));
            DomainMapper dm = cspec.getDomainMapper();
            DomainMapper dfltDm = cspec.getDefaultDomainMapper();
            if (dm == null) continue;
            Setting setting = new Setting(inName + "type", dm.getSourceName(), dfltDm == null ? null : dfltDm.getSourceName());
            settings.add(setting);
        }
        return settings;
    }

    private static List<Setting> createGeomSettings(LayerSpec lspec, AbstractPlot2Task task) {
        PlotContext context = task instanceof TypedPlot2Task ? ((TypedPlot2Task)task).getPlotContext() : null;
        Parameter<?> geomParam = context == null ? null : context.getGeomParameter("");
        ArrayList<Setting> settings = new ArrayList<Setting>();
        if (geomParam != null && DataGeom.class.isAssignableFrom(geomParam.getValueClass())) {
            Parameter<?> typedGeomParam = geomParam;
            DataGeom geom = lspec.getDataGeom();
            if (geom != null) {
                settings.add(PlotStiltsCommand.createParamSetting(typedGeomParam, geom));
            }
        }
        return settings;
    }

    private static <T> T getExplicitValue(ConfigKey<T> key, ConfigMap config) {
        return config.keySet().contains(key) ? (T)config.get(key) : null;
    }

    private static double[] toDoubles(float[] farray) {
        if (farray == null) {
            return null;
        }
        int n = farray.length;
        double[] darray = new double[n];
        for (int i = 0; i < n; ++i) {
            double dval = farray[i];
            darray[i] = PlotUtil.roundNumber(dval, 1.0E-5 * dval);
        }
        return darray;
    }

    private static ZoneAdjuster createZoneAdjuster(ConfigMap config, List<LayerSpec> lspecs, PlotType<?, ?> plotType) {
        if (plotType instanceof SkyPlotType) {
            return new SkySysZoneAdjuster(config, lspecs);
        }
        return new ZoneAdjuster(){

            @Override
            public void adjustZoneSettings(List<Setting> zsettings) {
            }

            @Override
            public void adjustLayerSettings(LayerSpec lspec, List<Setting> lsettings) {
            }
        };
    }

    private static List<Setting> getGlobalSettings(PlotSpec<?, ?> plotSpec) {
        if (plotSpec.getPlotType() instanceof MatrixPlotType) {
            return PlotStiltsCommand.getMatrixGlobalSettings(plotSpec);
        }
        return Collections.emptyList();
    }

    private static ConfigKey<?>[] getAuxKeys() {
        ArrayList keys = new ArrayList();
        keys.addAll(Arrays.asList(StyleKeys.AUX_RAMP.getKeys()));
        keys.add(StyleKeys.SHADE_LOW);
        keys.add(StyleKeys.SHADE_HIGH);
        return keys.toArray(new ConfigKey[0]);
    }

    private static List<Setting> getMatrixGlobalSettings(PlotSpec<?, ?> plotSpec) {
        PlotType<?, ?> plotType = plotSpec.getPlotType();
        GangerFactory<?, ?> gangerFact0 = plotType.getGangerFactory();
        SurfaceFactory<?, ?> surfFact0 = plotType.getSurfaceFactory();
        if (!(gangerFact0 instanceof MatrixGangerFactory) || !(surfFact0 instanceof PlaneSurfaceFactory)) {
            assert (false);
            return Collections.emptyList();
        }
        MatrixGangerFactory gangerFact = (MatrixGangerFactory)gangerFact0;
        PlaneSurfaceFactory surfFact = (PlaneSurfaceFactory)surfFact0;
        Plotter[] plotters = (Plotter[])Arrays.stream(plotSpec.getLayerSpecs()).map(LayerSpec::getPlotter).toArray(Plotter[]::new);
        ConfigMap globalConfig = plotSpec.getGlobalConfig();
        ConfigMap[] zoneConfigs = plotSpec.getZoneConfigs();
        MatrixShape shape = gangerFact.getShape(globalConfig, plotters);
        int nc = shape.getWidth();
        int nz = shape.getCellCount();
        assert (zoneConfigs.length == nz);
        String[] coordNames = (String[])IntStream.range(0, nc).mapToObj(MatrixPlotType::getCoordName).toArray(String[]::new);
        XyKeyPair<?>[] xyKeyPairs = surfFact.getXyKeyPairs();
        ArrayList settingMaps = new ArrayList(nc);
        for (int ic = 0; ic < nc; ++ic) {
            settingMaps.add(new LinkedHashMap());
        }
        for (int iz = 0; iz < nz; ++iz) {
            int iy;
            ConfigMap zconfig = zoneConfigs[iz];
            MatrixShape.Cell cell = shape.getCell(iz);
            int ix = cell.getX();
            if (ix == (iy = cell.getY())) continue;
            for (XyKeyPair<?> xyPair : xyKeyPairs) {
                String xname = PlotStiltsCommand.getSettingKey(xyPair.createKey(coordNames[ix]));
                String yname = PlotStiltsCommand.getSettingKey(xyPair.createKey(coordNames[iy]));
                Map xmap = (Map)settingMaps.get(ix);
                Map ymap = (Map)settingMaps.get(iy);
                if (!xmap.containsKey(xname)) {
                    xmap.put(xname, PlotStiltsCommand.createNamedConfigSetting(xyPair.getKeyX(), zconfig, xname));
                }
                if (ymap.containsKey(yname)) continue;
                ymap.put(yname, PlotStiltsCommand.createNamedConfigSetting(xyPair.getKeyY(), zconfig, yname));
            }
        }
        ArrayList<Setting> settings = new ArrayList<Setting>();
        for (Map map : settingMaps) {
            settings.addAll(map.values());
            settings.add(null);
        }
        ArrayList profileKeyList = new ArrayList(Arrays.asList(surfFact.getProfileKeys()));
        for (XyKeyPair<?> xyk : xyKeyPairs) {
            profileKeyList.remove(xyk.getKeyX());
            profileKeyList.remove(xyk.getKeyY());
        }
        ConfigKey[] configKeyArray = profileKeyList.toArray(new ConfigKey[0]);
        settings.add(null);
        settings.addAll(PlotStiltsCommand.getConfigSettings(globalConfig, configKeyArray));
        return settings;
    }

    private static class SkySysZoneAdjuster
    implements ZoneAdjuster {
        private static final ConfigKey<SkySys> VIEWSYS_KEY = SkySurfaceFactory.VIEWSYS_KEY;
        private final SkySys viewsys_;
        private final boolean sysDiffers_;

        SkySysZoneAdjuster(ConfigMap zconfig, List<LayerSpec> lspecs) {
            this.viewsys_ = (SkySys)PlotStiltsCommand.getExplicitValue(SkySysZoneAdjuster.VIEWSYS_KEY, zconfig);
            boolean differs = false;
            for (LayerSpec lspec : lspecs) {
                ConfigMap lconfig = lspec.getConfig();
                for (ConfigKey<?> key : lconfig.keySet()) {
                    SkySys cmpsys;
                    SkySysConfigKey sysKey;
                    if (!(key instanceof SkySysConfigKey) || !(sysKey = (SkySysConfigKey)key).isViewComparison() || (cmpsys = lconfig.get(sysKey)) == null || cmpsys.equals(this.viewsys_)) continue;
                    differs = true;
                }
            }
            this.sysDiffers_ = differs;
        }

        @Override
        public void adjustZoneSettings(List<Setting> zsettings) {
            for (int i = 0; i < zsettings.size(); ++i) {
                Setting zs = zsettings.get(i);
                if (zs == null || !zs.getKey().equals(PlotStiltsCommand.getSettingKey(SkySysZoneAdjuster.VIEWSYS_KEY))) continue;
                String dflt = this.sysDiffers_ ? null : zs.getStringValue();
                zsettings.set(i, zs.resetDefault(dflt));
            }
        }

        @Override
        public void adjustLayerSettings(LayerSpec lspec, List<Setting> lsettings) {
            ConfigMap lconfig = lspec.getConfig();
            for (ConfigKey<?> key : lconfig.keySet()) {
                SkySysConfigKey sysKey;
                if (!(key instanceof SkySysConfigKey) || !(sysKey = (SkySysConfigKey)key).isViewComparison()) continue;
                int isys = -1;
                for (int i = 0; i < lsettings.size(); ++i) {
                    Setting ls = lsettings.get(i);
                    if (ls == null || !ls.getKey().equals(PlotStiltsCommand.getSettingKey(sysKey))) continue;
                    isys = i;
                }
                if (isys < 0) {
                    lsettings.add(PlotStiltsCommand.createConfigSetting(sysKey, lconfig));
                    isys = lsettings.size() - 1;
                }
                Setting sysSetting = lsettings.get(isys);
                String dflt = this.sysDiffers_ ? null : sysSetting.getStringValue();
                lsettings.set(isys, sysSetting.resetDefault(dflt));
            }
        }
    }

    private static interface ZoneAdjuster {
        public void adjustZoneSettings(List<Setting> var1);

        public void adjustLayerSettings(LayerSpec var1, List<Setting> var2);
    }
}

