/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Formatter;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.layer.ShapeModePlotter;
import uk.ac.starlink.ttools.plot2.task.LayerType;
import uk.ac.starlink.ttools.plot2.task.LayerTypeParameter;
import uk.ac.starlink.ttools.plot2.task.ParameterFinder;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;

public class ShapeFamilyLayerType
implements LayerType {
    private final ShapeForm form_;
    private final List<ShapeModePlotter> plotters_;
    public static final String SHADING_PREFIX = "shading";

    public ShapeFamilyLayerType(ShapeForm form, List<ShapeModePlotter> plotters) {
        this.form_ = form;
        this.plotters_ = plotters;
    }

    public ShapeForm getShapeForm() {
        return this.form_;
    }

    public ShapeModePlotter[] getShapeModePlotters() {
        return this.plotters_.toArray(new ShapeModePlotter[0]);
    }

    @Override
    public String getName() {
        return this.form_.getFormName();
    }

    @Override
    public String getXmlDescription() {
        return this.form_.getFormDescription();
    }

    @Override
    public Parameter<?>[] getAssociatedParameters(String suffix) {
        return new Parameter[]{this.createShapeModeParameter(suffix)};
    }

    @Override
    public Plotter<?> getPlotter(Environment env, String suffix) throws TaskException {
        ShapeMode mode = (ShapeMode)new ParameterFinder<Parameter<ShapeMode>>(){

            @Override
            public Parameter<ShapeMode> createParameter(String sfix) {
                return ShapeFamilyLayerType.this.createShapeModeParameter(sfix);
            }
        }.getParameter(env, suffix).objectValue(env);
        for (ShapeModePlotter plotter : this.plotters_) {
            if (!plotter.getMode().equals(mode)) continue;
            return plotter;
        }
        throw new TaskException("Unknown mode " + mode);
    }

    @Override
    public CoordGroup getCoordGroup() {
        return this.plotters_.size() > 0 ? this.plotters_.get(0).getCoordGroup() : CoordGroup.createEmptyCoordGroup();
    }

    @Override
    public Coord[] getExtraCoords() {
        ArrayList<Coord> coordList = new ArrayList<Coord>();
        if (this.plotters_.size() > 0) {
            ShapeModePlotter plotter = this.plotters_.get(0);
            ShapeMode mode = plotter.getMode();
            coordList.addAll(Arrays.asList(plotter.getCoordGroup().getExtraCoords()));
            coordList.removeAll(Arrays.asList(mode.getExtraCoords()));
        }
        return coordList.toArray(new Coord[0]);
    }

    @Override
    public ConfigKey<?>[] getStyleKeys() {
        ArrayList keyList = new ArrayList();
        if (this.plotters_.size() > 0) {
            ShapeModePlotter plotter = this.plotters_.get(0);
            ShapeMode mode = plotter.getMode();
            keyList.addAll(Arrays.asList(plotter.getStyleKeys()));
            keyList.removeAll(Arrays.asList(mode.getConfigKeys()));
        }
        return keyList.toArray(new ConfigKey[0]);
    }

    public ChoiceParameter<ShapeMode> createShapeModeParameter(String suffix) {
        int nmode = this.plotters_.size();
        ShapeMode[] modes = new ShapeMode[nmode];
        for (int im = 0; im < nmode; ++im) {
            modes[im] = this.plotters_.get(im).getMode();
        }
        ShapeModeParameter param = new ShapeModeParameter(SHADING_PREFIX, suffix, modes);
        param.setNullPermitted(false);
        param.setDefaultOption(((ShapeMode[])param.getOptions())[0]);
        return param;
    }

    private static class ShapeModeParameter
    extends ChoiceParameter<ShapeMode>
    implements ExtraParameter {
        private final String suffix_;

        public ShapeModeParameter(String prefix, String suffix, ShapeMode[] modes) {
            super(prefix + suffix, ShapeMode.class, (Object[])modes);
            this.suffix_ = suffix;
            this.setPrompt("Colouring policy");
            this.setUsage(super.getUsage() + " <shade-params" + suffix + ">");
            StringBuffer sbuf = new StringBuffer();
            for (ShapeMode mode : modes) {
                String mname = mode.getModeName();
                sbuf.append("<li>").append("<code>").append("<ref id='shading-").append(mname).append("' plaintextref='yes'>").append(mname).append("</ref>").append("</code>").append("</li>\n");
            }
            String items = sbuf.toString();
            this.setDescription(new String[]{"<p>Determines how plotted objects in layer " + suffix, "are coloured.", "This may be influenced by how many objects are plotted", "over each other as well as the values of other parameters.", "Available options (<ref id='ShapeMode'/>) are:", "<ul>", items, "</ul>", "Each of these options comes with its own set of parameters", "to specify the details of how colouring is done.", "</p>"});
        }

        public String stringifyOption(ShapeMode mode) {
            return mode.getModeName().toLowerCase();
        }

        @Override
        public String getExtraUsage(TableEnvironment env) {
            StringBuffer sbuf = new StringBuffer().append("\n   ").append("Available shading types, ").append("with associated parmeters:\n");
            for (ShapeMode mode : (ShapeMode[])this.getOptions()) {
                ArrayList<String> modeWords = new ArrayList<String>();
                modeWords.add(this.getName() + "=" + mode.getModeName());
                Parameter<?>[] coordParams = LayerTypeParameter.getCoordParams(mode.getExtraCoords(), this.suffix_, false);
                Parameter<?>[] configParams = LayerTypeParameter.getLayerConfigParams(mode.getConfigKeys(), this.suffix_, false);
                modeWords.addAll(LayerTypeParameter.usageWords(coordParams));
                modeWords.addAll(LayerTypeParameter.usageWords(configParams));
                sbuf.append(Formatter.formatWords(modeWords, 6));
            }
            return sbuf.toString();
        }
    }
}

