/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import java.util.ArrayList;
import java.util.List;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;

public abstract class NamedObjectParameter<T>
extends Parameter<T> {
    private final List<NamedOption<T>> optList_ = new ArrayList<NamedOption<T>>();
    private boolean usageSet_;

    public NamedObjectParameter(String name, Class<T> clazz) {
        super(name, clazz, true);
    }

    public void addOption(String name, T option) {
        this.optList_.add(new NamedOption<T>(name, option));
    }

    public T stringToObject(Environment env, String sval) throws TaskException {
        for (NamedOption<T> opt : this.optList_) {
            if (!opt.name_.equalsIgnoreCase(sval)) continue;
            return opt.option_;
        }
        try {
            return this.fromString(sval);
        }
        catch (RuntimeException e) {
            throw new ParameterValueException((Parameter)this, "Bad format " + sval, (Throwable)e);
        }
    }

    public void setDefaultOption(T option) {
        if (option == null) {
            super.setStringDefault(null);
            return;
        }
        for (NamedOption<T> opt : this.optList_) {
            if (!opt.option_.equals(option)) continue;
            super.setStringDefault(opt.name_);
            return;
        }
        super.setStringDefault(this.toString(option));
    }

    public String toString(T option) {
        return option.toString();
    }

    public abstract T fromString(String var1);

    public String getOptionList() {
        StringBuffer sbuf = new StringBuffer().append("<ul>\n");
        for (NamedOption<T> opt : this.optList_) {
            sbuf.append("<li>").append("<code>").append("<![CDATA[").append(opt.name_).append("]]>").append("</code>").append("</li>").append('\n');
        }
        sbuf.append("</ul>\n");
        return sbuf.toString();
    }

    public String[] getNames() {
        String[] names = new String[this.optList_.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.optList_.get((int)i).name_;
        }
        return names;
    }

    public T[] getOptions() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.optList_.size(); ++i) {
            list.add(this.optList_.get((int)i).option_);
        }
        return this.toArray(list);
    }

    public void setUsage(String usage) {
        this.usageSet_ = true;
        super.setUsage(usage);
    }

    public String getUsage() {
        if (this.usageSet_) {
            return super.getUsage();
        }
        int nopt = this.optList_.size();
        StringBuffer sbuf = new StringBuffer();
        if (nopt > 4) {
            for (int i = 0; i < 2; ++i) {
                sbuf.append(this.optList_.get((int)i).name_);
                sbuf.append('|');
            }
            sbuf.append("...");
        } else {
            for (int i = 0; i < nopt; ++i) {
                if (i > 0) {
                    sbuf.append('|');
                }
                sbuf.append(this.optList_.get((int)i).name_);
            }
        }
        return sbuf.toString();
    }

    private static class NamedOption<T> {
        final String name_;
        final T option_;

        NamedOption(String name, T option) {
            this.name_ = name;
            this.option_ = option;
        }
    }
}

