/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.OutputStreamParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot.GraphicExporter;
import uk.ac.starlink.ttools.plottask.PaintMode;
import uk.ac.starlink.ttools.plottask.Painter;

public class PaintModeParameter
extends ChoiceParameter<PaintMode> {
    private final OutputStreamParameter outParam_ = new OutputStreamParameter("out");
    private final ChoiceParameter<GraphicExporter> formatParam_;

    public PaintModeParameter(String name, GraphicExporter[] exporters) {
        super(name, PaintMode.class, (Object[])PaintMode.getKnownModes(exporters));
        this.outParam_.setPrompt("Output file for graphics");
        this.outParam_.setStringDefault(null);
        this.outParam_.setNullPermitted(false);
        this.formatParam_ = new ChoiceParameter("ofmt", (Object[])exporters);
        this.formatParam_.setPrompt("Graphics format for plot output");
        StringBuffer fmtbuf = new StringBuffer().append("<p>Graphics format in which the plot is written to\n").append("the output file, see <ref id='graphicExporter'/>.\n").append("One of:\n").append("<ul>\n");
        for (int ie = 0; ie < exporters.length; ++ie) {
            GraphicExporter exporter = exporters[ie];
            fmtbuf.append("<li><code>").append(exporter.getName()).append("</code>: ").append(exporter.getDescription());
            fmtbuf.append("</li>").append("\n");
        }
        fmtbuf.append("</ul>\n").append("May default to a sensible value depending on the\n").append("filename given by ").append("<code>").append(this.outParam_.getName()).append("</code>.\n").append("</p>");
        this.formatParam_.setDescription(fmtbuf.toString());
        PaintMode[] modes = PaintMode.getKnownModes(exporters);
        StringBuffer modebuf = new StringBuffer().append("<p>Determines how the drawn plot will be output, ").append("see <ref id='paintMode'/>.\n").append("<ul>\n");
        for (int im = 0; im < modes.length; ++im) {
            PaintMode mode = modes[im];
            modebuf.append("<li><code>").append("<ref id='paintmode-").append(mode.getName()).append("'>").append(mode.getName()).append("</ref>").append("</code>:\n").append(mode.getDescription(this)).append("</li>").append("\n");
        }
        modebuf.append("</ul>\n").append("</p>");
        this.setDescription(modebuf.toString());
        this.setPrompt("Mode for graphical output");
        this.setStringDefault(modes[modes.length - 1].getName());
    }

    public OutputStreamParameter getOutputParameter() {
        return this.outParam_;
    }

    public ChoiceParameter<GraphicExporter> getFormatParameter() {
        return this.formatParam_;
    }

    public void setValueFromPainter(Environment env, final Painter painter) throws TaskException {
        this.setValueFromObject(env, new PaintMode(painter.toString()){

            @Override
            public Painter createPainter(Environment env, PaintModeParameter param) {
                return painter;
            }

            @Override
            public String getDescription(PaintModeParameter param) {
                return null;
            }

            @Override
            public String getModeUsage(PaintModeParameter param) {
                return null;
            }
        });
    }

    public Painter painterValue(Environment env) throws TaskException {
        return ((PaintMode)this.objectValue(env)).createPainter(env, this);
    }
}

