/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import gnu.jel.CompilationException;
import java.io.IOException;
import uk.ac.starlink.table.EmptyStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.jel.SequentialJELRowReader;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PointSequence;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plottask.PlotDataException;

public abstract class TablePlotData
implements PlotData {
    private final StarTable table_;
    private final String[] setExprs_;
    private final String[] setNames_;
    private final Style[] setStyles_;
    private final String labelExpr_;
    private final int nset_;

    protected TablePlotData(StarTable table, String[] setExprs, String[] setNames, Style[] setStyles, String labelExpr) {
        this.table_ = table;
        this.setExprs_ = (String[])setExprs.clone();
        this.setNames_ = (String[])setNames.clone();
        this.setStyles_ = (Style[])setStyles.clone();
        this.nset_ = this.setExprs_.length;
        this.labelExpr_ = labelExpr;
        if (setNames.length != this.nset_ || setStyles.length != this.nset_) {
            throw new IllegalArgumentException("Inconsistent set count");
        }
    }

    protected abstract PointSequence createPointSequence(SequentialJELRowReader var1) throws CompilationException;

    @Override
    public int getSetCount() {
        return this.nset_;
    }

    @Override
    public String getSetName(int iset) {
        return this.setNames_[iset];
    }

    @Override
    public Style getSetStyle(int iset) {
        return this.setStyles_[iset];
    }

    @Override
    public boolean hasLabels() {
        return this.labelExpr_ != null;
    }

    @Override
    public PointSequence getPointSequence() {
        try {
            return this.createPointSequence(new SequentialJELRowReader(this.table_));
        }
        catch (IOException e) {
            throw new PlotDataException(e);
        }
        catch (CompilationException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Compilation error should have showed up earlier"))).initCause(e));
        }
    }

    public void checkExpressions() throws CompilationException {
        SequentialJELRowReader dummyRdr;
        try {
            dummyRdr = new SequentialJELRowReader((StarTable)new EmptyStarTable(this.table_));
        }
        catch (IOException e) {
            throw new AssertionError((Object)"That shouldn't happen");
        }
        this.createPointSequence(dummyRdr);
    }
}

