/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.scheme;

import java.util.Random;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public abstract class AttractorFamily {
    private final String name_;
    private final int ndim_;
    private final int nparam_;
    private final double maxAbsParam_;
    private final double fillThresh_;
    public static final AttractorFamily CLIFFORD = AttractorFamily.createClifford();
    public static final AttractorFamily RAMPE = AttractorFamily.createRampe();
    public static final AttractorFamily HENON = AttractorFamily.createHenon();

    protected AttractorFamily(String name, int ndim, int nparam, double maxAbsParam, double fillThresh) {
        this.name_ = name;
        this.ndim_ = ndim;
        this.nparam_ = nparam;
        this.maxAbsParam_ = maxAbsParam;
        this.fillThresh_ = fillThresh;
    }

    public String getName() {
        return this.name_;
    }

    public int getDimCount() {
        return this.ndim_;
    }

    public int getParamCount() {
        return this.nparam_;
    }

    public double getMaxAbsParam() {
        return this.maxAbsParam_;
    }

    public double getFillThreshold() {
        return this.fillThresh_;
    }

    public abstract String[] getEquations();

    public abstract String getDocUrl();

    public abstract UnaryOperator<double[]> createOperator(double[] var1);

    public Attractor createAttractor(double[] params, double[] seed) {
        return new Attractor(this, params, seed == null ? new double[this.nparam_] : seed);
    }

    public Attractor createAttractor(Random rnd) {
        return new Attractor(this, AttractorFamily.randoms(rnd, this.getParamCount(), this.maxAbsParam_), new double[this.nparam_]);
    }

    public abstract double[][] getExamples();

    public static double[] randoms(Random rnd, int n, double absmax) {
        double[] rnds = new double[n];
        for (int i = 0; i < n; ++i) {
            double r = 2.0 * absmax * rnd.nextDouble() - absmax;
            rnds[i] = r = (double)((int)(r * 100.0)) / 100.0;
        }
        return rnds;
    }

    public static double getSpaceFraction(Attractor att, int nbin) {
        int ndim = att.getFamily().getDimCount();
        int np = (int)Math.pow(2 * nbin, ndim);
        Bounds bounds = att.pointStream().skip(100L).limit(np).collect(() -> new Bounds(ndim), Bounds::update, Bounds::combine);
        Grid grid = att.pointStream().skip(100L).limit(np).collect(() -> new Grid(bounds, nbin), Grid::accept, Grid::combine);
        return grid.getFillFraction();
    }

    public static Stream<Attractor> getStrangeAttractors(AttractorFamily family) {
        int nbin = 100;
        Random rnd = new Random(-445297L);
        return Stream.generate(() -> family.createAttractor(AttractorFamily.randoms(rnd, family.getParamCount(), family.maxAbsParam_), null)).filter(att -> AttractorFamily.getSpaceFraction(att, 100) > family.fillThresh_);
    }

    private static AttractorFamily createClifford() {
        return new AttractorFamily("clifford", 2, 4, 2.0, 0.3){

            @Override
            public String getDocUrl() {
                return "https://examples.pyviz.org/attractors/attractors.html";
            }

            @Override
            public UnaryOperator<double[]> createOperator(double[] params) {
                double a = params[0];
                double b = params[1];
                double c = params[2];
                double d = params[3];
                return xy -> {
                    double x = xy[0];
                    double y = xy[1];
                    return new double[]{Math.sin(a * y) + c * Math.cos(a * x), Math.sin(b * x) + d * Math.cos(b * y)};
                };
            }

            @Override
            public String[] getEquations() {
                return new String[]{"x' = sin(a*y) + c * cos(a*x)", "y' = sin(b*x) + d * cos(b*y)"};
            }

            @Override
            public double[][] getExamples() {
                return new double[][]{{-1.31, -1.34, 1.19, -1.32}, {1.32, -1.44, -1.7, -1.58}, {1.27, -1.35, 0.82, 1.8}, {-1.9, 1.18, -1.21, 1.07}, {-1.27, -1.28, 1.0, -1.26}, {1.8, 0.9, -1.8, 0.8}};
            }
        };
    }

    private static AttractorFamily createRampe() {
        return new AttractorFamily("rampe", 3, 6, 2.0, 0.01){

            @Override
            public String getDocUrl() {
                return "https://softologyblog.wordpress.com/2009/10/19/3d-strange-attractors/";
            }

            @Override
            public UnaryOperator<double[]> createOperator(double[] params) {
                double a = params[0];
                double b = params[1];
                double c = params[2];
                double d = params[3];
                double e = params[4];
                double f = params[5];
                return xyz -> {
                    double x = xyz[0];
                    double y = xyz[1];
                    double z = xyz[2];
                    return new double[]{x * z * Math.sin(a * x) - Math.cos(b * y), y * x * Math.sin(c * y) - Math.cos(d * z), z * y * Math.sin(e * z) - Math.cos(f * x)};
                };
            }

            @Override
            public String[] getEquations() {
                return new String[]{"x' = x * z * sin(a*x) - cos(b*y)", "y' = y * x * sin(c*y) - cos(d*z)", "z' = z * y * sin(e*z) - cos(f*x)"};
            }

            @Override
            public double[][] getExamples() {
                return new double[][]{{1.82, -1.06, -0.92, 0.23, 1.92, -0.98}, {-1.81, 1.35, -0.85, 0.32, 1.68, -1.62}, {0.23, -1.77, 1.32, -1.44, -1.7, -1.58}, {-0.3, 1.78, -0.87, 1.69, 1.42, 1.21}, {1.42, -1.98, 0.39, 1.32, 1.79, -0.37}};
            }
        };
    }

    private static AttractorFamily createHenon() {
        return new AttractorFamily("henon", 2, 3, 2.0, 0.01){

            @Override
            public String getDocUrl() {
                return "https://en.wikipedia.org/wiki/H%C3%A9non_map";
            }

            @Override
            public UnaryOperator<double[]> createOperator(double[] params) {
                double a = params[0];
                double b = params[1];
                double c = params[2];
                return xy -> {
                    double x = xy[0];
                    double y = xy[1];
                    return new double[]{y + a + b * x * x, c * x};
                };
            }

            @Override
            public String[] getEquations() {
                return new String[]{"x' = y + a + b*x*x", "y' = c*x"};
            }

            @Override
            public double[][] getExamples() {
                return new double[][]{{-0.8, 1.85, 0.24}, {-0.68, 1.64, 0.36}, {1.73, 0.29, -0.99}, {0.88, -0.9, -0.93}, {1.4, -1.13, -0.01}};
            }
        };
    }

    private static class Bounds {
        final int ndim_;
        double[] mins_;
        double[] maxs_;

        Bounds(int ndim) {
            this.ndim_ = ndim;
            this.mins_ = new double[ndim];
            this.maxs_ = new double[ndim];
            for (int i = 0; i < ndim; ++i) {
                this.mins_[i] = Double.MAX_VALUE;
                this.maxs_[i] = -1.7976931348623157E308;
            }
        }

        void update(double[] point) {
            for (int i = 0; i < this.ndim_; ++i) {
                this.mins_[i] = Math.min(this.mins_[i], point[i]);
                this.maxs_[i] = Math.max(this.maxs_[i], point[i]);
            }
        }

        Bounds combine(Bounds other) {
            for (int i = 0; i < this.ndim_; ++i) {
                this.mins_[i] = Math.min(this.mins_[i], other.mins_[i]);
                this.maxs_[i] = Math.max(this.maxs_[i], other.maxs_[i]);
            }
            return this;
        }

        public String toString() {
            StringBuffer sbuf = new StringBuffer();
            for (int i = 0; i < this.ndim_; ++i) {
                sbuf.append((float)this.mins_[i] + " - " + (float)this.maxs_[i]).append(" ; ");
            }
            return sbuf.toString();
        }
    }

    private static class Grid {
        private final Bounds bounds_;
        private final int nbin_;
        private final int ndim_;
        private final double[] factors_;
        private int[] grid_;

        Grid(Bounds bounds, int nbin) {
            this.bounds_ = bounds;
            this.nbin_ = nbin;
            this.ndim_ = bounds.ndim_;
            this.factors_ = new double[this.ndim_];
            int npix = 1;
            for (int i = 0; i < this.ndim_; ++i) {
                this.factors_[i] = 0.99999999 * (double)nbin / (bounds.maxs_[i] - bounds.mins_[i]);
                npix *= nbin;
            }
            this.grid_ = new int[npix];
        }

        public void accept(double[] point) {
            int n = this.toBinIndex(point);
            this.grid_[n] = this.grid_[n] + 1;
        }

        public double getFillFraction() {
            int nf = 0;
            for (int i = 0; i < this.grid_.length; ++i) {
                if (this.grid_[i] <= 0) continue;
                ++nf;
            }
            return 1.0 * (double)nf / (double)this.grid_.length;
        }

        public Grid combine(Grid other) {
            for (int i = 0; i < this.grid_.length; ++i) {
                int n = i;
                this.grid_[n] = this.grid_[n] + other.grid_[i];
            }
            return this;
        }

        private int toBinIndex(double[] point) {
            int ibin = 0;
            int step = 1;
            for (int i = 0; i < this.ndim_; ++i) {
                ibin += step * this.toBinCoord(i, point[i]);
                step *= this.nbin_;
            }
            return ibin;
        }

        private int toBinCoord(int idim, double value) {
            int ibin = (int)(this.factors_[idim] * (value - this.bounds_.mins_[idim]));
            return Math.min(this.nbin_ - 1, Math.max(0, ibin));
        }
    }

    public static class Attractor {
        private final AttractorFamily family_;
        private final double[] params_;
        private final double[] seed_;
        private final UnaryOperator<double[]> func_;

        public Attractor(AttractorFamily family, double[] params, double[] seed) {
            this.family_ = family;
            this.params_ = params;
            this.seed_ = seed;
            this.func_ = family.createOperator(params);
        }

        public AttractorFamily getFamily() {
            return this.family_;
        }

        public Stream<double[]> pointStream() {
            return Stream.iterate(this.seed_, this.func_);
        }

        public String toString() {
            StringBuffer sbuf = new StringBuffer().append(this.family_.getName()).append('(');
            for (int i = 0; i < this.params_.length; ++i) {
                if (i > 0) {
                    sbuf.append(',');
                }
                sbuf.append(this.params_[i]);
            }
            sbuf.append(')');
            return sbuf.toString();
        }
    }
}

