/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.scheme;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.DoubleFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.AccessRowSequence;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Documented;
import uk.ac.starlink.table.HealpixTableInfo;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableScheme;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.filter.AddSkyCoordsFilter;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ColumnMetadataFilter;
import uk.ac.starlink.ttools.filter.KeepColumnFilter;
import uk.ac.starlink.ttools.filter.ReplaceColumnFilter;
import uk.ac.starlink.ttools.scheme.SkySimData;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.URLDataSource;

public class SkySimScheme
implements TableScheme,
Documented {
    private final String tableName_ = "skysimdata.fits";
    private final String cnameWeight_ = "count";
    private final String stdevSuffix_ = "_stdev";
    private SkySimData simData_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.scheme");

    public String getSchemeName() {
        return "skysim";
    }

    public String getSchemeUsage() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<nrow>");
        return sbuf.toString();
    }

    public String getXmlDescription() {
        return DocUtils.join(new String[]{"<p>Generates a simulated all-sky star catalogue", "with a specified number of rows.", "This is intended to provide crude test catalogues", "when no suitable real dataset of the required size", "is available.", "In the current implementation the row count,", "is the only parameter,", "so the specification", "\"<code>:" + this.getSchemeName() + ":5e6</code>\"", "would give a 5 million-row simulated catalogue.", "The row count may be given as a plain integer (<code>1000</code>),\nor with embedded underscores (<code>1_000</code>),\nor in exponential format (<code>1e3</code>).", "</p>", "<p>The current implementation provides somewhat realistic", "position-dependent star densities and", "distributions of magnitudes and colours", "based on positionally averaged values from", "<a href='https://www.cosmos.esa.int/web/gaia/early-data-release-3'>Gaia EDR3</a>.", "The source positions do not correspond to actual stars.", "The columns and the statistics on which the output is based", "may change in future releases.", "</p>"});
    }

    public String getExampleSpecification() {
        return "6";
    }

    public StarTable createTable(String argtxt) throws IOException {
        long nrow;
        try {
            nrow = argtxt.length() == 0 ? 10000L : Tables.parseCount((String)argtxt);
        }
        catch (NumberFormatException e) {
            throw new TableFormatException("Not numeric: " + argtxt, (Throwable)e);
        }
        StarTable table = SkySimScheme.createBasicTable(this.getSimData(), nrow);
        try {
            return SkySimScheme.filterTable(table);
        }
        catch (IOException | ArgException e) {
            logger_.log(Level.WARNING, "SkySim filter failed: " + e, e);
            return table;
        }
    }

    private synchronized SkySimData getSimData() throws IOException {
        if (this.simData_ == null) {
            this.simData_ = this.readSimData();
        }
        return this.simData_;
    }

    SkySimData readSimData() throws IOException {
        StarTableFactory tfact = new StarTableFactory(true);
        tfact.setStoragePolicy(StoragePolicy.PREFER_MEMORY);
        URL url = this.getClass().getResource("skysimdata.fits");
        StarTable table = tfact.makeStarTable((DataSource)new URLDataSource(url));
        assert (table.isRandom());
        HealpixTableInfo hpxInfo = HealpixTableInfo.fromParams((List)table.getParameters());
        return SkySimData.readData(table, hpxInfo, "count", "_stdev");
    }

    static StarTable createBasicTable(SkySimData simData, long nrow) throws IOException {
        SkySimTable<Float> table = new SkySimTable<Float>(nrow, simData, Float.class, d -> Float.valueOf((float)d));
        table.setName("SimulatedSky-" + nrow);
        DescribedValue[] params = new DescribedValue[]{new DescribedValue((ValueInfo)new DefaultValueInfo("Description", String.class, null), (Object)"Simulated star catalogue, based on Gaia EDR3"), new DescribedValue((ValueInfo)new DefaultValueInfo("HealpixLevel", Integer.class, "Healpix level of aggregated statistics"), (Object)simData.getHealpixInfo().getLevel())};
        table.getParameters().addAll(Arrays.asList(params));
        return table;
    }

    static StarTable filterTable(StarTable table) throws ArgException, IOException {
        for (int icol = 0; icol < table.getColumnCount(); ++icol) {
            int istat;
            ColumnInfo cinfo = table.getColumnInfo(icol);
            String ucd = cinfo.getUCD();
            int n = istat = ucd == null ? -1 : ucd.indexOf(";stat");
            if (istat < 0) continue;
            cinfo.setUCD(ucd.substring(0, istat));
        }
        table = SkySimScheme.filter(table, new AddSkyCoordsFilter(), "galactic", "icrs", "l", "b", "ra", "dec");
        table = SkySimScheme.filter(table, new ReplaceColumnFilter(), "ra", "(float)ra");
        table = SkySimScheme.filter(table, new ReplaceColumnFilter(), "dec", "(float)dec");
        table = SkySimScheme.filter(table, new ColumnMetadataFilter(), "-desc", "G magnitude", "gmag");
        table = SkySimScheme.filter(table, new ColumnMetadataFilter(), "-desc", "R magnitude", "rmag");
        table = SkySimScheme.filter(table, new ColumnMetadataFilter(), "-desc", "B - R colour", "b_r");
        table = SkySimScheme.filter(table, new KeepColumnFilter(), "ra dec l b gmag rmag b_r");
        return table;
    }

    private static StarTable filter(StarTable table, BasicFilter filter, String ... args) throws ArgException, IOException {
        StarTable out;
        Iterator<String> argIt = new ArrayList<String>(Arrays.asList(args)).iterator();
        try {
            out = filter.createStep(argIt).wrap(table);
        }
        catch (IOException | ArgException e) {
            logger_.warning("SkySim filter failed: " + filter.getName() + Arrays.toString(args));
            return table;
        }
        if (argIt.hasNext()) {
            throw new ArgException("Unused args from " + Arrays.toString(args));
        }
        return out;
    }

    private static class SkySimTable<F extends Number>
    extends AbstractStarTable {
        private final long nrow_;
        private final SkySimData simData_;
        private final DoubleFunction<F> toCell_;
        private final SkySimData.Col[] cols_;
        private final int ncol_;
        private final ColumnInfo[] cinfos_;

        SkySimTable(long nrow, SkySimData simData, Class<F> fclazz, DoubleFunction<F> toCell) {
            this.nrow_ = nrow;
            this.simData_ = simData;
            this.toCell_ = toCell;
            ArrayList<SkySimData.Col> colList = new ArrayList<SkySimData.Col>();
            colList.add(simData.createCoordColumn(false));
            colList.add(simData.createCoordColumn(true));
            colList.addAll(Arrays.asList(simData.createQuantityColumns()));
            this.cols_ = colList.toArray(new SkySimData.Col[0]);
            this.ncol_ = this.cols_.length;
            this.cinfos_ = new ColumnInfo[this.ncol_];
            for (int icol = 0; icol < this.ncol_; ++icol) {
                ColumnInfo cinfo = new ColumnInfo((ValueInfo)this.cols_[icol].getInfo());
                Class clazz = cinfo.getContentClass();
                if (Float.class.equals((Object)clazz) || Double.class.equals((Object)clazz)) {
                    cinfo.setContentClass(fclazz);
                }
                this.cinfos_[icol] = cinfo;
            }
        }

        public boolean isRandom() {
            return true;
        }

        public long getRowCount() {
            return this.nrow_;
        }

        public int getColumnCount() {
            return this.cols_.length;
        }

        public ColumnInfo getColumnInfo(int icol) {
            return this.cinfos_[icol];
        }

        public RowAccess getRowAccess() throws IOException {
            return new RowAccess(){
                long rowSeed_;
                int simdataIrow_ = -1;

                public void setRowIndex(long irow) throws IOException {
                    this.rowSeed_ = this.getRowSeed(irow);
                    this.simdataIrow_ = simData_.getRandomRowIndex(this.rowSeed_);
                }

                public F getCell(int icol) throws IOException {
                    long cellSeed = this.getCellSeed(this.rowSeed_, icol);
                    double dval = cols_[icol].getValue(this.simdataIrow_, cellSeed);
                    return (Number)toCell_.apply(dval);
                }

                public Object[] getRow() throws IOException {
                    Object[] row = new Object[ncol_];
                    for (int icol = 0; icol < ncol_; ++icol) {
                        row[icol] = this.getCell(icol);
                    }
                    return row;
                }

                public void close() throws IOException {
                }
            };
        }

        public RowSequence getRowSequence() throws IOException {
            return AccessRowSequence.createInstance((StarTable)this);
        }

        public F getCell(long irow, int icol) throws IOException {
            long rowSeed = this.getRowSeed(irow);
            long seed = this.getCellSeed(rowSeed, icol);
            int simdataIrow = this.simData_.getRandomRowIndex(rowSeed);
            double dval = this.cols_[icol].getValue(simdataIrow, seed);
            return (F)((Number)this.toCell_.apply(dval));
        }

        public Object[] getRow(long irow) throws IOException {
            long rowSeed = this.getRowSeed(irow);
            int simdataIrow = this.simData_.getRandomRowIndex(rowSeed);
            Object[] row = new Object[this.ncol_];
            for (int icol = 0; icol < this.ncol_; ++icol) {
                long seed = this.getCellSeed(rowSeed, icol);
                double dval = this.cols_[icol].getValue(simdataIrow, seed);
                row[icol] = this.toCell_.apply(dval);
            }
            return row;
        }

        private long getRowSeed(long irow) {
            return (this.nrow_ * 1000L + irow) * -9234789L;
        }

        private long getCellSeed(long rowSeed, int icol) {
            return (rowSeed + (long)icol) * 21192442L;
        }
    }
}

