/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.server;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.graphics2d.svg.SVGGraphics2D;
import org.jfree.graphics2d.svg.SVGUnits;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.plot.GraphicExporter;
import uk.ac.starlink.ttools.plot.Picture;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.CoordSequence;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decoration;
import uk.ac.starlink.ttools.plot2.IndicatedRow;
import uk.ac.starlink.ttools.plot2.NavAction;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotScene;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.PointCloud;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.SubCloud;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.DiskCache;
import uk.ac.starlink.ttools.plot2.data.TupleRunner;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurface;
import uk.ac.starlink.ttools.plot2.task.HighlightIcon;
import uk.ac.starlink.ttools.server.PlotService;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.util.SplitCollector;

public class PlotSession<P, A> {
    private final String plotTxt_;
    private final PlotScene<P, A> scene_;
    private final Navigator<A> navigator_;
    private final GraphicExporter exporter_;
    private final DataStore dataStore_;
    private final String imgSuffix_;
    private final DiskCache imgCache_;
    private final A[] initialAspects_;
    private final Dimension initialSize_;
    private List<HighlightPosition> highlights_;
    private DragContext dragged_;
    private Dimension size_;
    public static final String JS_FILE = "plot2Lib.js";
    public static final String IMGSRC_KEY = "imgSrc";
    public static final String TRANSIENTSVG_KEY = "transientSvg";
    public static final String STATICSVG_KEY = "staticSvg";
    public static final String DATAPOS_KEY = "dataPos";
    public static final String TXTPOS_KEY = "txtPos";
    public static final String MESSAGE_KEY = "message";
    public static final String BOUNDS_KEY = "bounds";
    public static final String FORMAT_KEY = "format";
    public static final PlotService HTML_SERVICE = PlotSession.createHtmlService("html");
    public static final PlotService STATE_SERVICE;
    public static final PlotService IMGSRC_SERVICE;
    public static final PlotService POSITION_SERVICE;
    public static final PlotService COUNT_SERVICE;
    public static final PlotService ROW_SERVICE;
    public static final PlotService[] SERVICES;
    private static String JS_TEXT;
    private static final boolean IS_COUNT_PARALLEL = false;
    private static final GraphicExporter[] EXPORTERS;
    private static final Logger logger_;

    public PlotSession(String plotTxt, PlotScene<P, A> scene, Navigator<A> navigator, GraphicExporter exporter, DataStore dataStore, Dimension size, DiskCache imgCache) {
        this.plotTxt_ = plotTxt;
        this.scene_ = scene;
        this.navigator_ = navigator;
        this.exporter_ = exporter;
        this.dataStore_ = dataStore;
        this.size_ = size;
        this.imgCache_ = imgCache;
        String[] suffixes = exporter.getFileSuffixes();
        this.imgSuffix_ = suffixes.length > 0 ? suffixes[0] : "";
        this.initialSize_ = new Dimension(size);
        this.initialAspects_ = (Object[])this.scene_.getAspects().clone();
        this.highlights_ = new ArrayList<HighlightPosition>();
    }

    private void writeImageData(OutputStream out, GraphicExporter exporter) throws IOException {
        final int width = this.size_.width;
        final int height = this.size_.height;
        Picture picture = new Picture(){

            @Override
            public int getPictureWidth() {
                return width;
            }

            @Override
            public int getPictureHeight() {
                return height;
            }

            @Override
            public void paintPicture(Graphics2D g2) {
                PlotSession.this.scene_.paintScene(g2, PlotSession.this.getExternalBounds(), PlotSession.this.dataStore_);
            }
        };
        BufferedOutputStream bout = new BufferedOutputStream(out);
        exporter.exportGraphic(picture, bout);
        bout.flush();
    }

    private ImageWriter getImageWriter(HttpServletRequest request, final GraphicExporter exporter) throws IOException {
        UpdateResult result;
        if (this.isInitialRequest(request)) {
            result = UpdateResult.CHANGED;
            this.scene_.setAspects(this.initialAspects_);
            final File imgFile = this.getInitialCachedImageFile();
            if (imgFile != null) {
                return new ImageWriter(){

                    @Override
                    public long getByteCount() {
                        return imgFile.length();
                    }

                    @Override
                    public boolean isChanged() {
                        return true;
                    }

                    @Override
                    public Decoration getDecoration() {
                        return null;
                    }

                    @Override
                    public void writeImage(OutputStream out) throws IOException {
                        FileInputStream in = new FileInputStream(imgFile);
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                        ((InputStream)in).close();
                    }
                };
            }
        } else {
            result = this.updateAspect(request);
        }
        return new ImageWriter(){

            @Override
            public long getByteCount() {
                return -1L;
            }

            @Override
            public boolean isChanged() {
                return result.isImageChanged_;
            }

            @Override
            public Decoration getDecoration() {
                return result.decoration_;
            }

            @Override
            public void writeImage(OutputStream out) throws IOException {
                PlotSession.this.writeImageData(out, exporter);
            }
        };
    }

    private UpdateResult updateAspect(HttpServletRequest request) {
        NavAction<A> navAction;
        int iz;
        this.ensureSurfaces();
        Map<String, String> paramMap = PlotSession.getSingleParameterMap(request);
        String cmdName = paramMap.get("navigate");
        Point pos = PlotSession.parseXY(paramMap.get("pos"));
        int ibutton = PlotSession.parseInteger(paramMap.get("ibutton"), 0);
        int wheelrot = PlotSession.parseInteger(paramMap.get("wheelrot"), 0);
        Surface[] surfs = this.scene_.getSurfaces();
        Object[] aspects = (Object[])this.scene_.getAspects().clone();
        if ("resize".equals(cmdName)) {
            Point sizePt = PlotSession.parseXY(paramMap.get("size"));
            Dimension size = new Dimension(sizePt.x, sizePt.y);
            if (!size.equals(this.size_)) {
                this.size_ = size;
                this.scene_.clearPlot();
                return UpdateResult.CHANGED;
            }
            return UpdateResult.UNCHANGED;
        }
        if (pos == null) {
            return UpdateResult.UNCHANGED;
        }
        if ("click".equals(cmdName)) {
            iz = this.scene_.getGang().getNavigationZoneIndex(pos);
            if (iz >= 0) {
                PlotLayer[] layers = this.scene_.getLayers(iz);
                Supplier<CoordSequence> dposSupplier = new PointCloud(SubCloud.createSubClouds(layers, true)).createDataPosSupplier(this.dataStore_);
                navAction = this.navigator_.click(surfs[iz], pos, ibutton, dposSupplier);
            } else {
                navAction = null;
            }
        } else if ("drag".equals(cmdName)) {
            Point origin;
            DragContext dragged = this.dragged_;
            if (dragged == null) {
                origin = PlotSession.parseXY(paramMap.get("origin"));
                int isurf = this.scene_.getGang().getNavigationZoneIndex(origin);
                dragged = new DragContext(origin);
                if (isurf >= 0) {
                    dragged.isurf_ = isurf;
                    dragged.surface_ = surfs[isurf];
                }
                this.dragged_ = dragged;
            }
            origin = dragged.start_;
            iz = this.dragged_.isurf_;
            Surface surf = dragged.surface_;
            boolean isEnd = paramMap.containsKey("end");
            if (isEnd) {
                this.dragged_ = null;
            }
            navAction = surf != null ? (isEnd ? this.navigator_.endDrag(surf, pos, ibutton, origin) : this.navigator_.drag(surf, pos, ibutton, origin)) : null;
        } else if ("wheel".equals(cmdName) && wheelrot != 0) {
            iz = this.scene_.getGang().getNavigationZoneIndex(pos);
            navAction = iz >= 0 ? this.navigator_.wheel(surfs[iz], pos, wheelrot) : null;
        } else {
            return UpdateResult.UNCHANGED;
        }
        if (navAction == null) {
            return UpdateResult.UNCHANGED;
        }
        Object aspect = navAction.getAspect();
        Decoration dec = navAction.getDecoration();
        if (aspect == null) {
            return new UpdateResult(false, dec);
        }
        aspects[iz] = aspect;
        Object[] newAspects = this.scene_.getGanger().adjustAspects(aspects, iz);
        return new UpdateResult(this.scene_.setAspects(newAspects), dec);
    }

    private void ensureSurfaces() {
        if (this.scene_.getSurfaces()[0] == null) {
            this.scene_.prepareScene(this.getExternalBounds(), this.dataStore_);
        }
    }

    private boolean isInitialRequest(HttpServletRequest request) {
        Map<String, String> paramMap = PlotSession.getSingleParameterMap(request);
        String cmdName = paramMap.get("navigate");
        return "reset".equals(cmdName) && this.initialSize_.equals(this.size_);
    }

    private File getInitialCachedImageFile() throws IOException {
        if (this.imgCache_ == null) {
            return null;
        }
        this.imgCache_.ready();
        File file = new File(this.imgCache_.getDir(), "I-" + DiskCache.hashText(this.plotTxt_) + this.imgSuffix_);
        if (file.exists()) {
            this.imgCache_.touch(file);
        } else {
            File workFile = DiskCache.toWorkFilename(file);
            try {
                FileOutputStream out = new FileOutputStream(workFile);
                this.writeImageData(out, this.exporter_);
                ((OutputStream)out).close();
                workFile.renameTo(file);
                this.imgCache_.fileAdded(file);
                this.imgCache_.log("Wrote cached image file to " + file);
                this.imgCache_.tidy();
            }
            catch (IOException e) {
                String msg = "Failed write to cached file " + workFile + " (" + e + ")";
                logger_.log(Level.WARNING, msg, e);
                return null;
            }
        }
        return file.exists() && file.canRead() ? file : null;
    }

    private Rectangle getExternalBounds() {
        return new Rectangle(this.size_);
    }

    private String decorationSvg(List<Decoration> decs) {
        SVGGraphics2D g2 = new SVGGraphics2D(this.size_.width, this.size_.height, SVGUnits.PX);
        for (Decoration dec : decs) {
            dec.paintDecoration((Graphics)g2);
        }
        return g2.getSVGElement();
    }

    private void prepareImageResponse(HttpServletResponse response, GraphicExporter exporter) {
        response.setContentType(exporter.getMimeType());
        String encoding = exporter.getContentEncoding();
        if (encoding != null) {
            response.setHeader("Content-Encoding", encoding);
        }
        response.setStatus(200);
    }

    public static void init() throws IOException {
        JS_TEXT = PlotSession.readText(JS_FILE);
    }

    private static String getNavigationXmlDoc() {
        String posSpec = "&amp;pos=x,y";
        String originSpec = "&amp;origin=x0,y0";
        String toposSpec = "&amp;pos=x1,y1";
        String ibuttSpec = "&amp;ibutton=1|2|3";
        String wheelSpec = "&amp;wheelrot=nstep";
        return String.join((CharSequence)"\n", "<ul>", "<li><code>navigate=reset</code>:", "    reset the plot to initial state</li>", "<li><code>navigate=resize&amp;size=width,height</code>:", "    resize the plot to <code>width</code> x <code>height</code>", "    pixels</li>", "<li><code>navigate=click" + posSpec + ibuttSpec + "</code>:", "    emulate TOPCAT click on plot at graphics position", "    <code>x</code>,<code>y</code></li>", "<li><code>navigate=drag" + originSpec + toposSpec + ibuttSpec + "</code>:", "    emulate TOPCAT continuing drag from start graphics position", "    <code>x0</code>,<code>y0</code> to", "    <code>x1</code>,<code>y1</code></li>", "<li><code>navigate=drag" + originSpec + toposSpec + ibuttSpec + "&amp;end=true</code>:", "    emulate TOPCAT end-drag from start graphics position", "    <code>x0</code>,<code>y0</code> to", "    <code>x1</code>,<code>y1</code></li>", "<li><code>navigate=wheel" + posSpec + wheelSpec + "</code>:", "    emulate TOPCAT mouse wheel at graphics position", "    <code>x</code>,<code>y</code></li>", "<li><code>navigate=none</code>:", "    no change to last position</li>", "</ul>", "");
    }

    private static Map<String, String> getSingleParameterMap(HttpServletRequest request) {
        Map amap = request.getParameterMap();
        LinkedHashMap<String, String> smap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : amap.entrySet()) {
            String txt;
            String[] array = (String[])entry.getValue();
            if (array == null || array.length != 1 || (txt = array[0]) == null || txt.trim().length() <= 0) continue;
            smap.put((String)entry.getKey(), txt);
        }
        return smap;
    }

    private static Point parseXY(String txt) {
        int ipos;
        int n = ipos = txt == null ? -1 : txt.indexOf(44);
        if (ipos < 0) {
            return null;
        }
        try {
            int px = (int)Double.parseDouble(txt.substring(0, ipos));
            int py = (int)Double.parseDouble(txt.substring(ipos + 1));
            return new Point(px, py);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static int parseInteger(String txt, int dflt) {
        if (txt != null) {
            try {
                return Integer.parseInt(txt);
            }
            catch (NumberFormatException e) {
                return dflt;
            }
        }
        return dflt;
    }

    private static GraphicExporter parseFormatName(String fmtName) {
        for (GraphicExporter exp : EXPORTERS) {
            if (!exp.getName().equalsIgnoreCase(fmtName)) continue;
            return exp;
        }
        return null;
    }

    private static Map<String, Object> getJsonRowData(StarTable table, long irow) throws IOException {
        Object[] row = PlotSession.getRow(table, irow);
        if (row == null) {
            return null;
        }
        int nc = row.length;
        LinkedHashMap<String, Object> rowData = new LinkedHashMap<String, Object>();
        for (int ic = 0; ic < nc; ++ic) {
            String key = table.getColumnInfo(ic).getName();
            Object value = row[ic];
            if (value instanceof Number) {
                double dval = ((Number)value).doubleValue();
                if (dval != dval) {
                    value = null;
                } else if (Double.isInfinite(dval)) {
                    value = value.toString();
                }
            }
            rowData.put(key, value);
        }
        return rowData;
    }

    private static double[][] getDataBounds(Surface surf) {
        if (surf instanceof PlaneSurface) {
            PlaneSurface psurf = (PlaneSurface)surf;
            double[][] limits = psurf.getDataLimits();
            double[][] rlimits = new double[2][];
            for (int id = 0; id < 2; ++id) {
                Axis axis = psurf.getAxes()[id];
                String smin = PlaneSurface.formatPosition(axis, limits[id][0]);
                String smax = PlaneSurface.formatPosition(axis, limits[id][1]);
                rlimits[id] = new double[]{Double.parseDouble(smin), Double.parseDouble(smax)};
            }
            return rlimits;
        }
        if (surf instanceof CubeSurface) {
            CubeSurface csurf = (CubeSurface)surf;
            Rectangle gbox = csurf.getPlotBounds();
            int npix = Math.max(gbox.width, gbox.height);
            Scale[] scales = csurf.getScales();
            double[][] rlimits = new double[3][];
            for (int id = 0; id < 3; ++id) {
                double[] lims = csurf.getDataLimits(id);
                String[] slims = PlotUtil.formatAxisRangeLimits(lims[0], lims[1], scales[id], npix);
                rlimits[id] = new double[]{Double.parseDouble(slims[0]), Double.parseDouble(slims[1])};
            }
            return rlimits;
        }
        if (surf instanceof PlanarSurface) {
            return ((PlanarSurface)surf).getDataLimits();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] getRow(StarTable table, long irow) throws IOException {
        if (table.isRandom()) {
            return table.getRow(irow);
        }
        try (RowSequence rseq = table.getRowSequence();){
            for (long ir = 0L; ir < irow; ++ir) {
                if (rseq.next()) continue;
                Object[] objectArray = null;
                return objectArray;
            }
            Object[] objectArray = rseq.getRow();
            return objectArray;
        }
    }

    private static String readText(String resourceName) throws IOException {
        int chr;
        InputStream in = PlotSession.class.getResourceAsStream(resourceName);
        if (in == null) {
            throw new FileNotFoundException("No resource " + resourceName);
        }
        InputStreamReader rdr = new InputStreamReader(new BufferedInputStream(in));
        StringBuffer fbuf = new StringBuffer();
        while ((chr = ((Reader)rdr).read()) >= 0) {
            fbuf.append((char)chr);
        }
        ((Reader)rdr).close();
        return fbuf.toString();
    }

    private static void writeAscii(OutputStream out, CharSequence asciiTxt) throws IOException {
        int leng = asciiTxt.length();
        for (int i = 0; i < leng; ++i) {
            out.write(asciiTxt.charAt(i));
        }
    }

    private static void writeJsonQuotedString(OutputStream out, String txt) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        JSONObject.quote((String)txt, (Writer)writer);
        writer.flush();
    }

    private static void writeBase64(OutputStream out, ImageWriter imwriter) throws IOException {
        OutputStream b64out = Base64.getEncoder().wrap(new FilterOutputStream(out){

            @Override
            public void close() throws IOException {
            }
        });
        imwriter.writeImage(b64out);
        b64out.close();
    }

    private static PlotService createHtmlService(String name) {
        return new AbstractPlotService(name){

            @Override
            public boolean canCreateSession() {
                return true;
            }

            @Override
            public String getXmlDescription() {
                return String.join((CharSequence)"\n", "<p>Returns a new standalone HTML page containing", "the interactive plot specified by the supplied", "plot specification.", "Note this does not require a session ID to be supplied,", "and it has no parameters.", "This action is easy to use, but not very flexible.", "</p>", "");
            }

            @Override
            public void sessionRespond(PlotSession<?, ?> session, HttpServletRequest request, HttpServletResponse response) throws IOException {
                String servletUrl = request.getContextPath() + request.getServletPath();
                String plotTxt = ((PlotSession)session).plotTxt_;
                String html = String.join((CharSequence)"\n", "<html>", "<head>", "<meta charset='UTF-8'>", "<title>STILTS Plot</title>", "</head>", "<body>", "<script>", JS_TEXT, "onload = function() {", "   var servlet_url = '" + servletUrl + "';", "   var plot_txt = '" + plotTxt + "';", "   var options = {};", "   options[plot2.RATE] = true;", "   options[plot2.RESET] = true;", "   options[plot2.HELP] = true;", "   options[plot2.DOWNLOAD] = true;", "   options[plot2.MSG] = false;", "   var plt = plot2.createPlotNode(servlet_url, plot_txt, options);", "   var parent = document.getElementsByTagName('div')[0];", "   parent.appendChild(plt);", "}", "</script>", "<div></div>", "</body>", "</html>", "");
                response.setContentType("text/html");
                response.setStatus(200);
                ServletOutputStream out = response.getOutputStream();
                out.println(html);
            }
        };
    }

    private static PlotService createImageService(String name) {
        return new AbstractPlotService(name){

            @Override
            public String getXmlDescription() {
                return String.join((CharSequence)"\n", "<p>Returns image data suitable for reference by an", "<code>IMG/@src</code> attribute value", "for the current state of the session.", "The session state may be updated by supplying", "navigation parameters as follows:", PlotSession.getNavigationXmlDoc(), "</p>", "<p>The response MIME type can be influenced by", "the <code>ofmt</code> parameter in the", "<code>&lt;plot-spec&gt;</code>", "<em>or</em> the <code>format</code> parameter in the", "<code>&lt;arg-list&gt;</code>.", "In case of disagreement, the latter takes precedence.", "The available options are", Arrays.stream(EXPORTERS).map(s -> "\"<code>" + s + "</code>\"").collect(Collectors.joining(", ")) + ".", "</p>", "");
            }

            @Override
            public void sessionRespond(PlotSession<?, ?> session, HttpServletRequest request, HttpServletResponse response) throws IOException {
                Map paramMap = PlotSession.getSingleParameterMap(request);
                String fmtName = (String)paramMap.get(PlotSession.FORMAT_KEY);
                GraphicExporter exporter = null;
                if (fmtName != null && fmtName.trim().length() > 0) {
                    exporter = PlotSession.parseFormatName(fmtName);
                }
                if (exporter == null) {
                    exporter = ((PlotSession)session).exporter_;
                }
                ImageWriter imwriter = ((PlotSession)session).getImageWriter(request, exporter);
                ((PlotSession)session).prepareImageResponse(response, exporter);
                long size = imwriter.getByteCount();
                if (size > 0L && size < Integer.MAX_VALUE) {
                    response.setContentLength((int)size);
                }
                imwriter.writeImage((OutputStream)response.getOutputStream());
            }
        };
    }

    private static PlotService createStructureService(String name) {
        return new AbstractPlotService(name){

            @Override
            public String getXmlDescription() {
                return String.join((CharSequence)"\n", "<p>Returns a JSON structure giving the image and/or", "image annotations for the current state of the session.", "The session state may be updated by supplying", "navigation parameters, as follows:", PlotSession.getNavigationXmlDoc(), "</p>", "<p>The members of the returned structure are:", "<dl>", "<dt><code>imgSrc</code>", "    (present if plot has changed since last request):", "    </dt>", "<dd>Contains a <code>data:</code> URL suitable for use", "    as the content of an <code>IMG/@src</code> attribute", "    to display the current state of the plot", "    </dd>", "<dt><code>staticSvg</code>", "    (present if there are static decorations):</dt>", "<dd>SVG content, suitable as the content of", "    an <code>SVG</code> node, giving decorations", "    to superimpose over the plot image.", "    </dd>", "<dt><code>transientSvg</code>", "    (present if there are transient decorations):</dt>", "<dd>SVG content, suitable as the content of", "    an <code>SVG</code> node, giving decorations", "    to superimpose over the plot image", "    representing a navigation action.", "    Such decorations should only be displayed", "    for a short time (e.g. 0.5 second).", "    </dd>", "<dt><code>bounds</code>", "    (present for planar and cubic plots):</dt>", "<dd>A 2- or 3-element array of (lower,upper) data bound", "    pairs giving the extent of the current plot.", "    </dd>", "</dl>", "</p>", "");
            }

            @Override
            public void sessionRespond(PlotSession<?, ?> session, HttpServletRequest request, HttpServletResponse response) throws IOException {
                Surface[] surfaces;
                double[][] dbounds;
                Decoration navdec;
                ImageWriter imwriter = ((PlotSession)session).getImageWriter(request, ((PlotSession)session).exporter_);
                response.setContentType("application/json");
                response.setStatus(200);
                int nMember = 0;
                ServletOutputStream out = response.getOutputStream();
                out.write(123);
                if (imwriter.isChanged()) {
                    if (nMember++ > 0) {
                        out.write(44);
                    }
                    PlotSession.writeAscii((OutputStream)out, new StringBuffer().append('\"').append(PlotSession.IMGSRC_KEY).append('\"').append(": ").append('\"').append("data:").append(((PlotSession)session).exporter_.getMimeType()).append(";base64").append(','));
                    PlotSession.writeBase64((OutputStream)out, imwriter);
                    out.write(34);
                }
                if ((navdec = imwriter.getDecoration()) != null) {
                    if (nMember++ > 0) {
                        out.write(44);
                    }
                    PlotSession.writeAscii((OutputStream)out, "\"transientSvg\": ");
                    List<Decoration> decs = Collections.singletonList(navdec);
                    PlotSession.writeJsonQuotedString((OutputStream)out, ((PlotSession)session).decorationSvg(decs));
                }
                if (((PlotSession)session).highlights_.size() > 0) {
                    ArrayList<Decoration> hidecs = new ArrayList<Decoration>();
                    Surface[] surfaces2 = ((PlotSession)session).scene_.getSurfaces();
                    Point2D.Double gp = new Point2D.Double();
                    for (HighlightPosition hpos : ((PlotSession)session).highlights_) {
                        Surface surface = surfaces2[hpos.iz_];
                        if (!surface.dataToGraphics(hpos.dpos_, true, gp)) continue;
                        hidecs.add(HighlightIcon.INSTANCE.createDecoration(gp));
                    }
                    if (hidecs.size() > 0) {
                        if (nMember++ > 0) {
                            out.write(44);
                        }
                        PlotSession.writeAscii((OutputStream)out, "\"staticSvg\": ");
                        PlotSession.writeJsonQuotedString((OutputStream)out, ((PlotSession)session).decorationSvg(hidecs));
                    }
                }
                double[][] dArray = dbounds = (surfaces = ((PlotSession)session).scene_.getSurfaces()).length == 1 ? PlotSession.getDataBounds(surfaces[0]) : (double[][])null;
                if (dbounds != null) {
                    if (nMember++ > 0) {
                        out.write(44);
                    }
                    PlotSession.writeAscii((OutputStream)out, "\"bounds\": ");
                    PlotSession.writeAscii((OutputStream)out, new JSONArray((Object)dbounds).toString());
                }
                out.write(125);
            }
        };
    }

    private static PlotService createPlotPositionService(String name) {
        return new AbstractPlotService(name){

            @Override
            public String getXmlDescription() {
                return String.join((CharSequence)"\n", "<p>Provides a service to convert a position in plot", "graphics coordinates to data coordinates.", "The request must have a <code>pos</code> argument giving", "the graphics position in the form <code>x,y</code>", "(e.g. \"<code>pos=203,144</code>\"),", "and the response will be a JSON structure", "with the following members:", "<dl>", "<dt><code>dataPos</code>:</dt>", "<dd>On success, contains data coordinates", "    as a numeric array.</dd>", "<dt><code>txtPos</code>:</dt>", "<dd>On success, contains data coordinates", "    as a formatted string.</dd>", "<dt><code>message</code>:</dt>", "<dd>Textual indication of conversion status.", "    It will be \"<code>ok</code>\" on success,", "    but may have some other value, such as", "    \"<code>out of plot bounds</code>\", on failure.", "    </dd>", "</dl>", "</p>", "");
            }

            @Override
            public void sessionRespond(PlotSession<?, ?> session, HttpServletRequest request, HttpServletResponse response) throws IOException {
                String msg;
                Map paramMap = PlotSession.getSingleParameterMap(request);
                Point gpos = PlotSession.parseXY((String)paramMap.get("pos"));
                JSONObject json = new JSONObject();
                PlotScene scene = ((PlotSession)session).scene_;
                Surface[] surfs = scene.getSurfaces();
                if (gpos != null && surfs[0] != null) {
                    int iz = scene.getGang().getNavigationZoneIndex(gpos);
                    if (iz >= 0) {
                        Surface surf = surfs[iz];
                        if (surf.getPlotBounds().contains(gpos)) {
                            Supplier<CoordSequence> cseqSupplier = null;
                            double[] dpos = surf.graphicsToData(gpos, cseqSupplier);
                            if (dpos != null) {
                                msg = "ok";
                                String txtPos = surf.formatPosition(dpos);
                                json.put(PlotSession.DATAPOS_KEY, (Object)dpos);
                                json.put(PlotSession.TXTPOS_KEY, (Object)txtPos);
                            } else {
                                msg = "out of data range";
                            }
                        } else {
                            msg = "out of plot bounds";
                        }
                    } else {
                        msg = "outside of plots";
                    }
                } else {
                    msg = "plot not initialised";
                }
                if (msg != null) {
                    json.put(PlotSession.MESSAGE_KEY, (Object)msg);
                }
                response.setStatus(200);
                response.setContentType("application/json");
                response.getOutputStream().println(json.toString());
            }
        };
    }

    private static PlotService createCountService(String name) {
        return new AbstractPlotService(name){

            @Override
            public String getXmlDescription() {
                return String.join((CharSequence)"\n", "<p>Returns the number of points currently visible", "in this plot.", "Note that determining this value does take some", "computation (it's not free).", "The output is a plain text decimal value;", "it can also be interpreted as JSON.", "</p>", "");
            }

            @Override
            public void sessionRespond(PlotSession<?, ?> session, HttpServletRequest request, HttpServletResponse response) throws IOException {
                ((PlotSession)session).ensureSurfaces();
                PlotScene scene = ((PlotSession)session).scene_;
                DataStore dataStore = ((PlotSession)session).dataStore_;
                long count = 0L;
                int nz = scene.getGang().getZoneCount();
                TupleRunner tupleRunner = TupleRunner.SEQUENTIAL;
                for (int iz = 0; iz < nz; ++iz) {
                    SubCloud[] clouds;
                    PlotLayer[] layers = scene.getLayers(iz);
                    Surface surface = scene.getSurfaces()[iz];
                    for (SubCloud cloud : clouds = SubCloud.createSubClouds(layers, true)) {
                        DataSpec dataSpec = cloud.getDataSpec();
                        long[] acc = tupleRunner.collect(new PointCounter(cloud, surface), () -> dataStore.getTupleSequence(dataSpec));
                        count += acc[0];
                    }
                }
                response.setStatus(200);
                response.setContentType("text/plain");
                response.getOutputStream().println(Long.toString(count));
            }
        };
    }

    private static PlotService createRowService(String name) {
        return new AbstractPlotService(name){

            @Override
            public String getXmlDescription() {
                return String.join((CharSequence)"\n", "<p>Services a request for row information,", "at or near a submitted graphics position on the plot.", "The request must have a <code>pos</code> argument giving", "the graphics position in the form <code>x,y</code>", "(e.g. \"<code>pos=203,144</code>\"),", "</p>", "<p>The output is a JSON array of objects;", "there is one array element for each table represented,", "and each such element is a", "column-name-&gt;column-value map for the row indicated.", "If the submitted point is not near any plotted points,", "the result will therefore be an empty array.", "</p>", "");
            }

            @Override
            public void sessionRespond(PlotSession<?, ?> session, HttpServletRequest request, HttpServletResponse response) throws IOException {
                Map paramMap = PlotSession.getSingleParameterMap(request);
                Point pos = PlotSession.parseXY((String)paramMap.get("pos"));
                boolean isHighlight = paramMap.containsKey("highlight");
                ((PlotSession)session).ensureSurfaces();
                PlotScene scene = ((PlotSession)session).scene_;
                LinkedHashSet<TableRow> rowSet = new LinkedHashSet<TableRow>();
                ArrayList<HighlightPosition> hposList = new ArrayList<HighlightPosition>();
                int iz = scene.getZoneIndex(pos);
                if (iz >= 0) {
                    Surface surface = scene.getSurfaces()[iz];
                    PlotLayer[] layers = scene.getLayers(iz);
                    int nl = layers.length;
                    if (surface != null && nl > 0 && surface.getPlotBounds().contains(pos)) {
                        IndicatedRow[] closestRows = scene.findClosestRows(surface, layers, pos, ((PlotSession)session).dataStore_);
                        for (int il = 0; il < nl; ++il) {
                            IndicatedRow indRow = closestRows[il];
                            if (indRow == null) continue;
                            long lrow = indRow.getIndex();
                            StarTable table = layers[il].getDataSpec().getSourceTable();
                            boolean isNewItem = rowSet.add(new TableRow(table, lrow));
                            if (!isNewItem) continue;
                            double[] dpos = indRow.getDataPos();
                            HighlightPosition hpos = new HighlightPosition(iz, dpos);
                            hposList.add(hpos);
                        }
                    }
                }
                JSONArray jsonArray = new JSONArray();
                for (TableRow trow : rowSet) {
                    Map rowData = PlotSession.getJsonRowData(trow.table_, trow.irow_);
                    if (rowData == null || rowData.size() <= 0) continue;
                    jsonArray.put(rowData);
                }
                response.setStatus(200);
                response.setContentType("application/json");
                response.getOutputStream().println(jsonArray.toString());
                if (isHighlight) {
                    ((PlotSession)session).highlights_ = hposList;
                }
            }
        };
    }

    static {
        SERVICES = new PlotService[]{HTML_SERVICE, STATE_SERVICE = PlotSession.createStructureService("state"), IMGSRC_SERVICE = PlotSession.createImageService("imgsrc"), POSITION_SERVICE = PlotSession.createPlotPositionService("position"), COUNT_SERVICE = PlotSession.createCountService("count"), ROW_SERVICE = PlotSession.createRowService("row")};
        EXPORTERS = GraphicExporter.getKnownExporters(PlotUtil.LATEX_PDF_EXPORTER);
        logger_ = Logger.getLogger("uk.ac.starlink.ttools.server");
    }

    private static abstract class AbstractPlotService
    implements PlotService {
        private final String name_;

        AbstractPlotService(String name) {
            this.name_ = name;
        }

        @Override
        public boolean canCreateSession() {
            return false;
        }

        @Override
        public String getServiceName() {
            return this.name_;
        }
    }

    private static class DragContext {
        final Point start_;
        int isurf_;
        Surface surface_;

        DragContext(Point start) {
            this.start_ = start;
        }
    }

    private static class PointCounter
    implements SplitCollector<TupleSequence, long[]> {
        final SubCloud cloud_;
        final Surface surface_;

        PointCounter(SubCloud cloud, Surface surface) {
            this.cloud_ = cloud;
            this.surface_ = surface;
        }

        public long[] createAccumulator() {
            return new long[1];
        }

        public void accumulate(TupleSequence tseq, long[] acc) {
            DataGeom geom = this.cloud_.getDataGeom();
            int iPosCoord = this.cloud_.getPosCoordIndex();
            double[] dpos = new double[geom.getDataDimCount()];
            Point2D.Double gp = new Point2D.Double();
            long count = 0L;
            while (tseq.next()) {
                if (!geom.readDataPos(tseq, iPosCoord, dpos) || !this.surface_.dataToGraphics(dpos, true, gp)) continue;
                ++count;
            }
            acc[0] = acc[0] + count;
        }

        public long[] combine(long[] acc1, long[] acc2) {
            return new long[]{acc1[0] + acc2[0]};
        }
    }

    private static class HighlightPosition {
        final int iz_;
        final double[] dpos_;

        HighlightPosition(int iz, double[] dpos) {
            this.iz_ = iz;
            this.dpos_ = (double[])dpos.clone();
        }

        public String toString() {
            return this.iz_ + ": " + Arrays.toString(this.dpos_);
        }
    }

    private static class TableRow {
        final StarTable table_;
        final long irow_;

        TableRow(StarTable table, long irow) {
            this.table_ = table;
            this.irow_ = irow;
        }

        public int hashCode() {
            return this.table_.hashCode() + (int)(23L * this.irow_);
        }

        public boolean equals(Object o) {
            if (o instanceof TableRow) {
                TableRow other = (TableRow)o;
                return this.table_.equals(other.table_) && this.irow_ == other.irow_;
            }
            return false;
        }

        public String toString() {
            return this.irow_ + ": " + this.table_;
        }
    }

    private static interface ImageWriter {
        public long getByteCount();

        public boolean isChanged();

        public Decoration getDecoration();

        public void writeImage(OutputStream var1) throws IOException;
    }

    private static class UpdateResult {
        final boolean isImageChanged_;
        final Decoration decoration_;
        static final UpdateResult CHANGED = new UpdateResult(true, null);
        static final UpdateResult UNCHANGED = new UpdateResult(false, null);

        UpdateResult(boolean isImageChanged, Decoration decoration) {
            this.isImageChanged_ = isImageChanged;
            this.decoration_ = decoration;
        }
    }
}

