/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.server;

import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SoftCache<K, V>
extends AbstractMap<K, V> {
    private final Map<K, SoftReference<V>> map_ = new ConcurrentHashMap<K, SoftReference<V>>();
    private final Set<Map.Entry<K, V>> entrySet_ = new AbstractSet<Map.Entry<K, V>>(){

        @Override
        public int size() {
            return SoftCache.this.map_.size();
        }

        @Override
        public void clear() {
            SoftCache.this.map_.clear();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            final Iterator baseIt = SoftCache.this.map_.entrySet().iterator();
            return new Iterator<Map.Entry<K, V>>(){

                @Override
                public boolean hasNext() {
                    return baseIt.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    final Map.Entry baseEntry = (Map.Entry)baseIt.next();
                    return new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return baseEntry.getKey();
                        }

                        @Override
                        public V getValue() {
                            return ((SoftReference)baseEntry.getValue()).get();
                        }

                        @Override
                        public V setValue(V value) {
                            SoftReference ref = baseEntry.setValue(new SoftReference(value));
                            return ref == null ? null : (Object)ref.get();
                        }
                    };
                }

                @Override
                public void remove() {
                    baseIt.remove();
                }
            };
        }
    };

    public void purge() {
        Iterator<Map.Entry<K, SoftReference<V>>> it = this.map_.entrySet().iterator();
        while (it.hasNext()) {
            if (it.next().getValue().get() != null) continue;
            it.remove();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet_;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map_.containsKey(key);
    }

    @Override
    public V get(Object key) {
        SoftReference<V> ref = this.map_.get(key);
        if (ref != null) {
            V value = ref.get();
            if (value == null) {
                this.map_.remove(key);
            }
            return value;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        SoftReference<V> ref = this.map_.put(key, new SoftReference<V>(value));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V remove(Object key) {
        SoftReference<V> ref = this.map_.remove(key);
        return ref == null ? null : (V)ref.get();
    }
}

