/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.InvokeUtils;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.server.ServletEnvironment;
import uk.ac.starlink.ttools.server.StiltsContext;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;

public class TaskServlet
extends HttpServlet {
    private ObjectFactory<Task> taskFactory_;
    private StarTableFactory tableFactory_;
    private StarTableOutput tableOutput_;
    private JDBCAuthenticator jdbcAuth_;
    private Collection<String> taskNameSet_;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.taskFactory_ = Stilts.getTaskFactory();
        this.tableOutput_ = new StarTableOutput();
        this.jdbcAuth_ = null;
        ServletContext context = config.getServletContext();
        StiltsContext sContext = new StiltsContext(context);
        String taskList = context.getInitParameter("stiltsTasks");
        this.taskNameSet_ = Arrays.asList(TaskServlet.getTaskNames(this.taskFactory_, taskList));
        this.tableFactory_ = sContext.getTableFactory();
    }

    public void destroy() {
        this.tableFactory_ = null;
        super.destroy();
    }

    public String getServletInfo() {
        return "STILTS Servlet " + Stilts.getVersion() + "; See http://www.starlink.ac.uk/stilts/";
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.process(request, response);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            this.replyError(response, 400, e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.process(request, response);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            this.replyError(response, 400, e);
        }
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setHeader("STILTS-Version", Stilts.getVersion());
        ServletEnvironment env = new ServletEnvironment((ServletRequest)request, (ServletResponse)response, this.tableFactory_, this.tableOutput_, this.jdbcAuth_);
        String subpath = request.getPathInfo();
        String taskName = subpath.replaceAll("^/*", "");
        if (this.taskNameSet_.contains(taskName)) {
            Task task;
            assert (this.taskFactory_.isRegistered(taskName));
            try {
                task = (Task)this.taskFactory_.createObject(taskName);
            }
            catch (LoadException e) {
                this.replyError(response, 500, e);
                return;
            }
            if (env.isHelp()) {
                response.setStatus(200);
                response.setContentType("text/html");
                ServletOutputStream out = response.getOutputStream();
                out.println("<html>");
                out.println("<head><title>STILTS " + taskName + "</title></head>");
                out.println("<body>");
                this.writeTaskHelp(request.getServletPath(), out, taskName, task);
                out.println("</body>");
                out.println("</html>");
                out.flush();
            } else {
                Executable exec;
                try {
                    exec = task.createExecutable((Environment)env);
                }
                catch (TaskException e) {
                    this.replyError(response, 400, e);
                    return;
                }
                catch (Throwable e) {
                    e.printStackTrace(System.err);
                    this.replyError(response, 500, e);
                    return;
                }
                try {
                    exec.execute();
                }
                catch (TaskException e) {
                    if (!response.isCommitted()) {
                        this.replyError(response, 400, e);
                    }
                    throw new ServletException("Error during task execution", (Throwable)e);
                }
            }
        } else {
            response.setContentType("text/html");
            ServletOutputStream out = response.getOutputStream();
            if (env.isHelp()) {
                response.setStatus(200);
                out.println("<html>");
                out.println("<head><title>STILTS</title></head>");
                out.println("<body>");
                out.println("<h2>STILTS</h2>");
                out.println("<p>This is STILTS, the STIL Tool Set.<br />");
                out.println("Running in server mode.</p>");
                out.println("<p><b>STILTS version:</b> " + Stilts.getVersion() + "<br />");
                out.println("<b>STIL version:</b> " + IOUtils.getResourceContents(StarTable.class, (String)"stil.version", null) + "<br />");
                out.println("<b>JVM:</b> " + InvokeUtils.getJavaVM());
                out.println("</p>");
                out.println("<p><b>Author:</b> <a href='http://www.star.bris.ac.uk/~mbt/'>Mark Taylor</a><br />");
                out.println("<b>WWW:</b> <a href='http://www.starlink.ac.uk/stilts/'>http://www.starlink.ac.uk/stilts/</a>");
                out.println("</p>");
                this.writeStiltsHelp(request.getServletPath(), out);
                out.println("</body>");
                out.println("</html>");
            } else {
                response.setStatus(400);
                out.println("<html>");
                out.println("<head><title>No such task: " + taskName + "</title></head>");
                out.println("<body>");
                out.println("<h2>No such task: " + taskName + "</h2>");
                this.writeStiltsHelp(request.getServletPath(), out);
                out.println("</body>");
                out.println("</html>");
            }
            out.flush();
            out.close();
        }
    }

    private void replyError(HttpServletResponse response, int code, Throwable error) throws IOException, ServletException {
        if (response.isCommitted()) {
            throw new ServletException("Error after response commit", error);
        }
        response.setStatus(code);
        response.setContentType("text/plain");
        PrintStream pout = new PrintStream((OutputStream)response.getOutputStream());
        error.printStackTrace(pout);
        pout.flush();
        pout.close();
    }

    private void writeStiltsHelp(String baseUrl, ServletOutputStream out) throws IOException {
        out.println("<p>Known tasks:</p>");
        out.println("<ul>");
        String[] taskNames = this.taskNameSet_.toArray(new String[0]);
        for (int i = 0; i < taskNames.length; ++i) {
            String taskName = taskNames[i];
            out.print("<li>");
            out.print("<a href='" + baseUrl + "/" + taskName + "'>" + taskName + "</a>");
            out.print("</li>");
            out.println();
        }
        out.println("</ul>");
    }

    private void writeTaskHelp(String baseUrl, ServletOutputStream out, String taskName, Task task) throws IOException {
        Parameter param;
        int i;
        out.println("<h2>STILTS task <code>" + taskName + "</code></h2>");
        out.println("<h3>Purpose</h3>");
        out.println(task.getPurpose());
        out.println("<h3>Usage</h3>");
        out.println("<p><code>");
        out.println(baseUrl + "/" + taskName);
        out.println("<blockquote>");
        Parameter[] params = task.getParameters();
        for (i = 0; i < params.length; ++i) {
            param = params[i];
            out.print(" <font color='green'>" + (i > 0 ? "&amp;" : "?") + "</font> ");
            out.print("<a href='#" + param.getName() + "'>" + TaskServlet.escape(param.getName()) + "</a>=<font color='brown'>" + TaskServlet.escape(param.getUsage()) + "</font>");
            out.println("<br />");
        }
        out.println("</blockquote>");
        out.println("</code></p>");
        out.println("<h3>Parameters</h3>");
        out.println("<dl>");
        Arrays.sort(params, Parameter.BY_NAME);
        for (i = 0; i < params.length; ++i) {
            param = params[i];
            out.println("<dt><b><a name='" + param.getName() + "'>" + TaskServlet.escape(param.getName() + " = " + param.getUsage()) + "</a></b></dt>");
            out.println("<dd>" + param.getDescription());
            out.println("</dd>");
        }
        out.println("</dl>");
    }

    public static String[] getTaskNames(ObjectFactory<Task> taskFactory, String taskList) {
        HashSet<String> knownTasks = new HashSet<String>(Arrays.asList(taskFactory.getNickNames()));
        if (taskList == null || taskList.trim().length() == 0) {
            return knownTasks.toArray(new String[0]);
        }
        String[] taskNames = taskList.split("\\s+");
        ArrayList<String> okList = new ArrayList<String>();
        for (int i = 0; i < taskNames.length; ++i) {
            String task = taskNames[i];
            if (!knownTasks.contains(task)) {
                throw new IllegalArgumentException("Unknown task " + task);
            }
            okList.add(task);
        }
        return okList.toArray(new String[0]);
    }

    private static String escape(String text) {
        return text.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

