/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.ttools.taplint.CapabilityHolder;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.vo.AdqlVersion;
import uk.ac.starlink.vo.Ivoid;
import uk.ac.starlink.vo.OutputFormat;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapLanguage;
import uk.ac.starlink.vo.TapLanguageFeature;
import uk.ac.starlink.vo.TapService;
import uk.ac.starlink.vo.TapVersion;
import uk.ac.starlink.vo.UserAgentUtil;

public class CapabilityStage
implements Stage {
    private final CapabilityHolder capHolder_;
    private static final Pattern UDF_FORM_REGEX = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)\\s*\\((.*)\\)\\s*->\\s*(.*)");
    private static final String TOKEN_REGEX = "[^()<>@,;:\\\"/\\[\\]\\?=\\s]+";
    private static final Pattern OUT_MIME_REGEX = Pattern.compile("(text|image|audio|video|application|x-[^()<>@,;:\\\"/\\[\\]\\?=\\s]+)/[^()<>@,;:\\\"/\\[\\]\\?=\\s]+\\s*(;.*)?", 2);
    private static final Set<String> NON_VO_SERVERSOFT = new HashSet<String>(Arrays.asList("apache", "nginx", "twistedweb", "php", "openssl", "mod_jk"));

    public CapabilityStage(CapabilityHolder capHolder) {
        this.capHolder_ = capHolder;
    }

    @Override
    public String getDescription() {
        return "Check TAP and TAPRegExt content of capabilities document";
    }

    @Override
    public void run(Reporter reporter, TapService tapService) {
        CapabilityStage.checkServerHeader(reporter, this.capHolder_.getServerHeader());
        TapCapability tcap = this.capHolder_.getCapability();
        if (tcap == null) {
            reporter.report(FixedCode.F_CAP0, "No TAPRegExt capability");
        } else {
            new TapRegExtRunner(reporter, tcap).run();
        }
        Cap[] caps = CapabilityStage.readCaps(reporter, this.capHolder_.getElement());
        if (caps == null) {
            reporter.report(FixedCode.F_CAP0, "No capabilities");
        } else {
            new CapDocRunner(reporter, tapService, caps).run();
        }
    }

    private static void checkServerHeader(Reporter reporter, String serverHdr) {
        String[] tokens;
        if (serverHdr == null || serverHdr.trim().length() == 0) {
            reporter.report(FixedCode.W_SVR0, "No HTTP Server header");
        }
        String qHdr = "\"Server: " + serverHdr + "\"";
        try {
            tokens = UserAgentUtil.parseProducts((String)serverHdr);
        }
        catch (RuntimeException e) {
            reporter.report(FixedCode.E_SVRB, "Bad product list syntax " + qHdr);
            return;
        }
        reporter.report(FixedCode.I_SVRI, "HTTP server header " + qHdr);
        List possVoProducts = Arrays.stream(tokens).filter(CapabilityStage::isPossibleVoProduct).collect(Collectors.toList());
        if (possVoProducts.size() == 0) {
            String msg = new StringBuffer().append("No apparent VO service software identification ").append("in HTTP header ").append(qHdr).append(" - see SoftID Note").toString();
            reporter.report(FixedCode.W_SVRV, msg);
        }
    }

    private static boolean isPossibleVoProduct(String word) {
        if (word == null || word.length() == 0) {
            return false;
        }
        if (word.charAt(0) == '(') {
            return false;
        }
        String componentName = word.replaceAll("/.*", "").toLowerCase();
        for (String nonvoName : NON_VO_SERVERSOFT) {
            if (componentName.indexOf(nonvoName.toLowerCase()) < 0) continue;
            return false;
        }
        return true;
    }

    private static Cap[] readCaps(Reporter reporter, Element capsEl) {
        if (capsEl == null) {
            return null;
        }
        ArrayList<Cap> caps = new ArrayList<Cap>();
        for (Element capEl : DOMUtils.getChildElementsByName((Node)capsEl, (String)"capability")) {
            Cap cap = new Cap(CapabilityStage.getAtt(capEl, "standardID"));
            caps.add(cap);
            for (Element intfEl : DOMUtils.getChildElementsByName((Node)capEl, (String)"interface")) {
                Intf intf = new Intf(CapabilityStage.getAtt(intfEl, "xsi:type"), CapabilityStage.getAtt(intfEl, "role"), CapabilityStage.getAtt(intfEl, "version"));
                cap.intfs_.add(intf);
                for (Element el : DOMUtils.getChildElementsByName((Node)intfEl, null)) {
                    String tagName = el.getTagName();
                    if ("securityMethod".equals(tagName)) {
                        SecMeth sm = new SecMeth(CapabilityStage.getAtt(el, "standardID"));
                        intf.secMeths_.add(sm);
                        continue;
                    }
                    if (!"accessURL".equals(tagName)) continue;
                    intf.accessUrl_ = DOMUtils.getTextContent((Element)el).trim();
                }
            }
        }
        return caps.toArray(new Cap[0]);
    }

    private static String getAtt(Element el, String attName) {
        return el.hasAttribute(attName) ? el.getAttribute(attName) : null;
    }

    private static class SecMeth {
        final Ivoid standardId_;

        SecMeth(String standardId) {
            this.standardId_ = standardId == null ? null : new Ivoid(standardId);
        }
    }

    private static class Intf {
        final String xsiType_;
        final String role_;
        final String version_;
        String accessUrl_;
        final List<SecMeth> secMeths_;

        Intf(String xsiType, String role, String version) {
            this.xsiType_ = xsiType;
            this.role_ = role;
            this.version_ = version;
            this.secMeths_ = new ArrayList<SecMeth>();
        }
    }

    private static class Cap {
        final Ivoid standardId_;
        final List<Intf> intfs_;

        Cap(String standardId) {
            this.standardId_ = standardId == null ? null : new Ivoid(standardId);
            this.intfs_ = new ArrayList<Intf>();
        }
    }

    private static class CapDocRunner
    implements Runnable {
        private final Reporter reporter_;
        private final TapService tapService_;
        private final Cap[] caps_;
        private static final Ivoid TAPCAP_STDID = new Ivoid("ivo://ivoa.net/std/TAP");
        private static final String VOSI_URI = "ivo://ivoa.net/std/VOSI";
        private static final Collection<Ivoid> SSO_SMIDS = new HashSet<Ivoid>(Arrays.asList(new Ivoid("ivo://ivoa.net/sso#BasicAA"), new Ivoid("ivo://ivoa.net/sso#tls-with-password"), new Ivoid("ivo://ivoa.net/sso#tls-with-certificate"), new Ivoid("ivo://ivoa.net/sso#cookie"), new Ivoid("ivo://ivoa.net/sso#OAuth"), new Ivoid("ivo://ivoa.net/sso#saml2.0"), new Ivoid("ivo://ivoa.net/sso#OpenID")));

        CapDocRunner(Reporter reporter, TapService tapService, Cap[] caps) {
            this.reporter_ = reporter;
            this.tapService_ = tapService;
            this.caps_ = caps;
        }

        @Override
        public void run() {
            Cap tapCap = this.getTapCap();
            this.checkSecurityMethods();
            if (tapCap != null) {
                this.checkVosiAccessUrl(tapCap, "#capabilities", "/capabilities");
                this.checkVosiAccessUrl(tapCap, "#tables(-.*)?", "/tables");
            }
        }

        private Cap getTapCap() {
            Intf tapintf;
            String msg;
            String msg2;
            ArrayList<Cap> tapcaps = new ArrayList<Cap>();
            for (Cap cap : this.caps_) {
                if (!TAPCAP_STDID.equalsIvoid(cap.standardId_)) continue;
                tapcaps.add(cap);
            }
            if (tapcaps.size() == 0) {
                msg2 = new StringBuffer().append("No capability element with ").append("standardID='" + TAPCAP_STDID + "'").toString();
                this.reporter_.report(FixedCode.E_CPT1, msg2);
                return null;
            }
            if (tapcaps.size() > 1) {
                msg2 = new StringBuffer().append("Multiple capability elements with ").append("standardID='" + TAPCAP_STDID + "'").toString();
                this.reporter_.report(FixedCode.E_CPT1, msg2);
            }
            Cap tapcap = (Cap)tapcaps.get(0);
            ArrayList<Intf> stdIntfs = new ArrayList<Intf>();
            for (Intf intf : tapcap.intfs_) {
                if (!"std".equals(intf.role_)) continue;
                stdIntfs.add(intf);
            }
            if (stdIntfs.size() == 0) {
                msg = new StringBuffer().append("No TAP interface element with ").append("role=\"std\"").toString();
                this.reporter_.report(FixedCode.E_CPIF, msg);
            } else if (stdIntfs.size() > 1) {
                msg = new StringBuffer().append("Multiple TAP interface elements with ").append("role=\"std\"").toString();
                this.reporter_.report(FixedCode.W_CPI2, msg);
            }
            Intf intf = tapintf = stdIntfs.size() > 0 ? (Intf)stdIntfs.get(0) : null;
            if (tapintf != null) {
                String msg3;
                String intfVers = tapintf.version_;
                TapVersion tapVers = this.tapService_.getTapVersion();
                if (tapVers.is11() && !"1.1".equals(intfVers)) {
                    msg3 = new StringBuffer().append("TAP interface does not declare ").append("version 1.1").append(" (<interface role=\"std\"").append(" version=\"" + intfVers + "\">").append(" for " + tapVers + ")").toString();
                    this.reporter_.report(FixedCode.E_CPTV, msg3);
                } else if (!tapVers.is11() && intfVers != null && !intfVers.equals("1.0")) {
                    msg3 = new StringBuffer().append("TAP interface version declaration").append(" mismatch").append(" (<interface role=\"std\"").append(" version=\"" + intfVers + "\">").append(" for " + tapVers + ")").toString();
                    this.reporter_.report(FixedCode.E_CPTV, msg3);
                }
                String tapUrl = this.tapService_.getIdentity();
                String intfUrl = tapintf.accessUrl_;
                if (tapUrl != null && !tapUrl.equals(intfUrl)) {
                    String msg4 = new StringBuffer().append("TAP role='std' interface accessURL ").append("differs from TAP service URL ").append("(" + intfUrl + " != " + tapUrl + ")").toString();
                    this.reporter_.report(FixedCode.W_CPUR, msg4);
                }
            }
            return tapcap;
        }

        private void checkSecurityMethods() {
            for (Cap cap : this.caps_) {
                for (Intf intf : cap.intfs_) {
                    SecMeth[] sms = intf.secMeths_.toArray(new SecMeth[0]);
                    if (!(sms.length != 1 || sms[0].standardId_ != null && sms[0].standardId_.isValid())) {
                        String msg = new StringBuffer().append("Interface has single anonymous ").append("security method - ").append("zero security methods is preferred").toString();
                        this.reporter_.report(FixedCode.W_CPAN, msg);
                    }
                    ArrayList<Ivoid> idlist = new ArrayList<Ivoid>();
                    for (SecMeth sm : sms) {
                        Ivoid stdid = sm.standardId_;
                        idlist.add(stdid);
                        if (stdid == null || SSO_SMIDS.contains(stdid)) continue;
                        String msg = new StringBuffer().append("Unknown SecurityMethod standardID ").append("\"" + stdid + "\" ").append("(not defined in SSO 2.0)").toString();
                        this.reporter_.report(FixedCode.W_CPSM, msg);
                    }
                    if (idlist.size() <= new HashSet(idlist).size()) continue;
                    String msg = new StringBuffer().append("Duplicate security methods present ").append("in capabilities interface: ").append(idlist).toString();
                    this.reporter_.report(FixedCode.W_CPS2, msg);
                }
            }
        }

        private void checkVosiAccessUrl(Cap tapCap, String stdLocalRegex, String subpath) {
            String tapUrl = CapDocRunner.getStdAccessUrl(tapCap);
            for (Cap cap : this.caps_) {
                String vosiUrl;
                Ivoid capid = cap.standardId_;
                if (capid == null || !capid.matchesRegistryPart(VOSI_URI) || capid.getLocalPart() == null || !capid.getLocalPart().matches(stdLocalRegex) || (vosiUrl = CapDocRunner.getStdAccessUrl(cap)) == null || vosiUrl.equals(tapUrl + subpath)) continue;
                String msg = new StringBuffer().append("AccessURL for ").append(cap.standardId_).append(" is not at fixed location").append(" (").append("\"" + vosiUrl + "\"").append(" != ").append("\"" + tapUrl + subpath).toString();
                this.reporter_.report(FixedCode.W_CPUL, msg);
            }
        }

        private static String getStdAccessUrl(Cap cap) {
            for (Intf intf : cap.intfs_) {
                if (!"std".equals(intf.role_)) continue;
                return intf.accessUrl_;
            }
            return null;
        }
    }

    private static class TapRegExtRunner
    implements Runnable {
        private final Reporter reporter_;
        private final TapCapability tcap_;

        TapRegExtRunner(Reporter reporter, TapCapability tcap) {
            this.reporter_ = reporter;
            this.tcap_ = tcap;
        }

        @Override
        public void run() {
            this.checkLanguages();
            this.checkUploadMethods();
            this.checkOutputFormats();
        }

        private void checkLanguages() {
            TapLanguage[] languages = this.tcap_.getLanguages();
            if (languages.length == 0) {
                this.reporter_.report(FixedCode.E_NOQL, "No query languages declared");
                return;
            }
            boolean hasAdql = false;
            boolean hasAdql2 = false;
            TreeSet<AdqlVersion> adqlVersions = new TreeSet<AdqlVersion>();
            for (int il = 0; il < languages.length; ++il) {
                TapLanguage lang = languages[il];
                String langName = lang.getName();
                if ("ADQL".equals(langName)) {
                    hasAdql = true;
                    int nvers = lang.getVersions().length;
                    assert (nvers == lang.getVersionIds().length);
                    for (int iv = 0; iv < nvers; ++iv) {
                        String msg;
                        String vname = lang.getVersions()[iv];
                        Ivoid vid = lang.getVersionIds()[iv];
                        if (vname == null || vname.trim().length() == 0) {
                            String msg2 = new StringBuffer().append("Language ").append(langName).append(" has empty version string").toString();
                            this.reporter_.report(FixedCode.W_LVAN, msg2);
                        }
                        AdqlVersion nameVers = AdqlVersion.byNumber((String)vname);
                        AdqlVersion idVers = AdqlVersion.byIvoid((Ivoid)vid);
                        if (nameVers != null) {
                            adqlVersions.add(nameVers);
                        }
                        if (idVers != null) {
                            adqlVersions.add(idVers);
                        }
                        if (nameVers != null && (vid == null || vid.getRegistryPart() == null)) {
                            msg = new StringBuffer().append("Language ").append(langName).append(" has version ").append(vname).append(" without ivo-id=\"").append(nameVers.getIvoid()).append("\"").toString();
                            this.reporter_.report(FixedCode.W_A2MN, msg);
                            continue;
                        }
                        if (nameVers != null && idVers == null) {
                            msg = new StringBuffer().append("Language ").append(langName).append(" has version ").append(vname).append(" with non-standard ivo-id=\"").append(vid).append("\"").append(" != \"").append(nameVers.getIvoid()).append("\"").toString();
                            this.reporter_.report(FixedCode.W_A2MX, msg);
                            continue;
                        }
                        if (nameVers == null || idVers == null || nameVers.equals((Object)idVers)) continue;
                        msg = new StringBuffer().append("Language Version with ivo-id=\"").append(vid).append("\" is ").append(langName).append("-").append(vname).append(" not ").append("ADQL " + idVers).toString();
                        this.reporter_.report(FixedCode.E_A2XI, msg);
                    }
                }
                if (adqlVersions.size() <= 0) continue;
                hasAdql2 = true;
                AdqlVersion highestVersion = (AdqlVersion)adqlVersions.last();
                this.checkAdqlFeatures(lang, highestVersion);
            }
            if (!hasAdql) {
                this.reporter_.report(FixedCode.E_ADQX, "ADQL not declared as a query language");
            } else if (!hasAdql2) {
                this.reporter_.report(FixedCode.W_AD2X, "ADQL-2.0 not declared as a query language");
            }
        }

        private void checkAdqlFeatures(TapLanguage language, AdqlVersion version) {
            String langName = language.getName();
            String[] versions = language.getVersions();
            if (versions.length == 1) {
                langName = langName + "-" + versions[0];
            }
            HashSet<Ivoid> versionFeatures = new HashSet<Ivoid>(Arrays.asList(version.getFeatureUris()));
            Map featuresMap = language.getFeaturesMap();
            for (Ivoid ftype : featuresMap.keySet()) {
                String msg;
                TapLanguageFeature[] features = (TapLanguageFeature[])featuresMap.get(ftype);
                if (TapCapability.UDF_FEATURE_TYPE.equalsIvoid(ftype)) {
                    this.checkUdfs(langName, features);
                    continue;
                }
                if (TapCapability.ADQLGEO_FEATURE_TYPE.equalsIvoid(ftype)) {
                    this.checkAdqlGeoms(langName, features);
                    continue;
                }
                if (ftype.matchesRegistryPart("ivo://ivoa.net/std/TAPRegExt")) {
                    if (versionFeatures.contains(ftype)) continue;
                    msg = new StringBuffer().append("Unknown standard feature key \"").append(ftype).append("\" for language ").append(langName).toString();
                    this.reporter_.report(FixedCode.E_KEYX, msg);
                    continue;
                }
                msg = new StringBuffer().append("Custom feature type \"").append(ftype).append("\" for language ").append(langName).toString();
                this.reporter_.report(FixedCode.I_CULF, msg);
            }
        }

        private void checkUdfs(String langName, TapLanguageFeature[] features) {
            for (int ifeat = 0; ifeat < features.length; ++ifeat) {
                String form = features[ifeat].getForm();
                if (form != null && UDF_FORM_REGEX.matcher(form.trim()).matches()) continue;
                String msg = new StringBuffer().append("Declared ").append(langName).append(" UDF ").append(" has wrong form \"").append(form).append("\"").append(" not \"").append("f(a T[, ...]) -> T)").append("\"").toString();
                this.reporter_.report(FixedCode.E_UDFE, msg);
            }
        }

        private void checkAdqlGeoms(String langName, TapLanguageFeature[] features) {
            HashSet<String> geomSet = new HashSet<String>(Arrays.asList("AREA", "BOX", "CENTROID", "CIRCLE", "CONTAINS", "COORD1", "COORD2", "COORDSYS", "DISTANCE", "INTERSECTS", "POINT", "POLYGON", "REGION"));
            for (int ifeat = 0; ifeat < features.length; ++ifeat) {
                String form = features[ifeat].getForm();
                if (geomSet.contains(form)) continue;
                String msg = new StringBuffer().append("Declared ").append(langName).append(" geometry function \"").append(form).append("\" unknown").toString();
                this.reporter_.report(FixedCode.E_GEOX, msg);
            }
        }

        private void checkUploadMethods() {
            String msg;
            Ivoid[] upMethods = this.tcap_.getUploadMethods();
            String uploadLocalPrefix = "#upload-";
            List<String> mandatoryUploadList = Arrays.asList("#upload-inline", "#upload-http");
            ArrayList<String> stdUploadList = new ArrayList<String>(mandatoryUploadList);
            stdUploadList.addAll(Arrays.asList("#upload-https", "#upload-ftp"));
            for (int iu = 0; iu < upMethods.length; ++iu) {
                Ivoid upMethod = upMethods[iu];
                String localPart = upMethod.getLocalPart();
                if (upMethod.matchesRegistryPart("ivo://ivoa.net/std/TAPRegExt")) {
                    if (stdUploadList.contains(localPart)) continue;
                    msg = new StringBuffer().append("Unknown upload method \"").append(upMethod).append("\" in TAPRegExt namespace").append(" (known values are ").append(stdUploadList).append(")").toString();
                    this.reporter_.report(FixedCode.E_UPBD, msg);
                    continue;
                }
                msg = new StringBuffer().append("Custom upload method \"").append(upMethod).append("\"").toString();
                this.reporter_.report(FixedCode.W_UPCS, msg);
            }
            if (upMethods.length > 0) {
                for (String mpart : mandatoryUploadList) {
                    Ivoid mandId = TapCapability.createTapRegExtIvoid((String)mpart);
                    if (Arrays.asList(upMethods).contains(mandId)) continue;
                    msg = "Mandatory upload method " + mandId + " not declared" + ", though uploads are " + "apparently supported";
                    this.reporter_.report(FixedCode.E_MUPM, msg);
                }
            }
        }

        private void checkOutputFormats() {
            OutputFormat[] outFormats = this.tcap_.getOutputFormats();
            if (outFormats.length == 0) {
                this.reporter_.report(FixedCode.E_NOOF, "No output formats defined");
                return;
            }
            List<String> outKeyList = Arrays.asList("#output-votable-td", "#output-votable-binary", "#output-votable-binary2");
            String stdPrefix = "ivo://ivoa.net/std/TAPRegExt";
            for (int iof = 0; iof < outFormats.length; ++iof) {
                Ivoid ivoid;
                String ofName;
                OutputFormat of = outFormats[iof];
                String[] aliases = of.getAliases();
                String mime = of.getMime();
                String string = ofName = aliases.length > 0 ? aliases[0] : mime;
                if (mime == null || !OUT_MIME_REGEX.matcher(mime.trim()).matches()) {
                    String msg = new StringBuffer().append("Illegal MIME type \"").append(mime).append("\" for output format ").append(ofName).toString();
                    this.reporter_.report(FixedCode.E_BMIM, msg);
                }
                if ((ivoid = of.getIvoid()) == null || !ivoid.matchesRegistryPart(stdPrefix) || outKeyList.contains(ivoid.getLocalPart())) continue;
                String msg = new StringBuffer().append("Unknown output format key ").append("in standard namespace \"").append(ivoid).append("\" for output format ").append(ofName).append(" (known values are ").append(outKeyList).append(")").toString();
                this.reporter_.report(FixedCode.E_XOFK, msg);
            }
        }
    }
}

