/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.taplint.AdqlValidatorKit;
import uk.ac.starlink.ttools.taplint.CapabilityHolder;
import uk.ac.starlink.ttools.taplint.ContentTypeOptions;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.HoldReporter;
import uk.ac.starlink.ttools.taplint.MetadataHolder;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.ReporterErrorHandler;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.ttools.taplint.TapRunner;
import uk.ac.starlink.ttools.votlint.VocabChecker;
import uk.ac.starlink.util.ContentType;
import uk.ac.starlink.vo.AdqlValidator;
import uk.ac.starlink.vo.Ivoid;
import uk.ac.starlink.vo.StdCapabilityInterface;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapService;

public class ExampleStage
implements Stage {
    private final TapRunner tapRunner_;
    private final CapabilityHolder capHolder_;
    private final MetadataHolder metaHolder_;
    private static final Ivoid EXAMPLES_STDID = new Ivoid("ivo://ivoa.net/std/DALI#examples");
    private static final int QUERY_MAXREC = 10;
    private static final Pattern XMLNAME_REGEX = ExampleStage.createXmlNameRegex();
    private static final Set<String> BODY_PLAINTEXT_PROPS = ExampleStage.createStringSet("name", "capability", "continuation", "query", "table");
    private static final Set<String> GP_PLAINTEXT_PROPS = ExampleStage.createStringSet("key", "value");
    private static final ContentTypeOptions CTYPE_XHTML = new ContentTypeOptions(new ContentType[]{new ContentType("text", "html"), new ContentType("application", "xhtml+xml")});
    private static final Ivoid DALI10_VOCAB = new Ivoid("ivo://ivoa.net/std/DALI#examples");
    private static final Ivoid TAPNOTE_VOCAB = new Ivoid("ivo://ivoa.net/std/DALI-examples");
    private static final Ivoid PRAGMATIC_VOCAB = new Ivoid("ivo://ivoa.net/std/DALI-examples#");
    private static final Ivoid DALI11_VOCAB = new Ivoid("http://www.ivoa.net/rdf/examples#");
    private static final Ivoid[] EXAMPLES_VOCABS = new Ivoid[]{DALI10_VOCAB, TAPNOTE_VOCAB, PRAGMATIC_VOCAB, DALI11_VOCAB};
    private static final VocabChecker PROPERTY_CHECKER = VocabChecker.EXAMPLES;

    public ExampleStage(TapRunner tapRunner, CapabilityHolder capHolder, MetadataHolder metaHolder) {
        this.tapRunner_ = tapRunner;
        this.capHolder_ = capHolder;
        this.metaHolder_ = metaHolder;
    }

    @Override
    public String getDescription() {
        return "Check content of examples document";
    }

    @Override
    public void run(Reporter reporter, TapService tapService) {
        boolean hasExamples;
        URL exUrl = tapService.getExamplesEndpoint();
        ExampleRunner runner = new ExampleRunner(reporter, tapService, this.tapRunner_, this.capHolder_, this.metaHolder_);
        try {
            runner.checkExamplesDocument(exUrl);
            hasExamples = true;
        }
        catch (FileNotFoundException e) {
            reporter.report(FixedCode.F_EXNO, "No examples document at " + exUrl);
            hasExamples = false;
        }
        StdCapabilityInterface[] intfs = this.capHolder_.getInterfaces();
        if (intfs != null) {
            boolean declaresExamples = false;
            for (StdCapabilityInterface intf : intfs) {
                if (!EXAMPLES_STDID.equalsIvoid(new Ivoid(intf.getStandardId()))) continue;
                declaresExamples = true;
            }
            if (hasExamples && !declaresExamples) {
                reporter.report(FixedCode.E_EXDH, "Examples endpoint present but undeclared");
            } else if (declaresExamples && !hasExamples) {
                reporter.report(FixedCode.E_EXDH, "Examples endpoint declared but absent");
            } else assert (hasExamples == declaresExamples);
        }
        if (hasExamples) {
            runner.reportSummary();
        }
    }

    private static String getAttribute(Element el, String attName) {
        return el.hasAttribute(attName) ? el.getAttribute(attName) : null;
    }

    private static String getMarkupContent(Element el) {
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            StringWriter sw = new StringWriter();
            trans.transform(new DOMSource(el), new StreamResult(sw));
            String content = sw.toString();
            return content.replaceFirst("^<\\?[Xx][Mm][Ll].*?\\?>", "");
        }
        catch (TransformerException e) {
            return el.getTextContent();
        }
    }

    private static Set<String> createStringSet(String ... items) {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(items)));
    }

    private static Pattern createXmlNameRegex() {
        String startCharPat = "_\\p{L}";
        String laterCharPat = startCharPat + "0-9\\-\\.";
        return Pattern.compile("[" + startCharPat + "][" + laterCharPat + "]*");
    }

    private static Document readXml(Reporter reporter, URL url, ContentTypeOptions reqType) throws SAXException, IOException {
        DocumentBuilder db;
        URLConnection conn = AuthManager.getInstance().connect(url);
        InputStream in = conn.getInputStream();
        if (reqType != null) {
            reqType.checkType(reporter, conn.getContentType(), url);
        }
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            reporter.report(FixedCode.F_UNEX, "Trouble setting up XML parse", e);
            return null;
        }
        db.setErrorHandler(new ReporterErrorHandler(reporter));
        db.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                if (publicId != null && publicId.indexOf("DTD") > 0 || systemId != null && systemId.indexOf("w3.org") > 0) {
                    return new InputSource(new StringReader(""));
                }
                return new InputSource(systemId);
            }
        });
        return db.parse(in);
    }

    private static Element[] xpathElements(Reporter reporter, Element contextEl, String findPath) {
        NodeList nl;
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            nl = (NodeList)xpath.evaluate(findPath, contextEl, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            reporter.report(FixedCode.F_UNEX, "Bad XPath expression: " + findPath, e);
            return new Element[0];
        }
        int nn = nl.getLength();
        ArrayList<Element> elList = new ArrayList<Element>(nn);
        for (int i = 0; i < nn; ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            elList.add((Element)node);
        }
        return elList.toArray(new Element[0]);
    }

    private static List<MetaPair> readGenericParams(Reporter reporter, Element el) {
        ArrayList<MetaPair> gparamList = new ArrayList<MetaPair>();
        String gparamPath = ".//*[@property='generic-parameter']";
        for (Element gparamEl : ExampleStage.xpathElements(reporter, el, gparamPath)) {
            String msg;
            String typeof = ExampleStage.getAttribute(gparamEl, "typeof");
            if (!"keyval".equals(typeof)) {
                reporter.report(FixedCode.E_GPER, "@property='generic-parameter' without @typeof='keyval'");
            }
            ArrayList<MetaPair> gpMetas = new ArrayList<MetaPair>();
            for (Node child = gparamEl.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof Element)) continue;
                gpMetas.addAll(ExampleStage.readTextProperties(reporter, GP_PLAINTEXT_PROPS, (Element)child));
            }
            String gpKey = null;
            String gpValue = null;
            for (MetaPair mp : gpMetas) {
                if ("key".equals(mp.key_)) {
                    if (gpKey != null) {
                        reporter.report(FixedCode.E_GPER, "Multiple @property='key' elements for generic parameter: " + gpKey + ", " + mp.value_);
                    } else {
                        gpKey = mp.value_;
                    }
                }
                if (!"value".equals(mp.key_)) continue;
                if (gpValue != null) {
                    reporter.report(FixedCode.E_GPER, "Multiple @property='value' elements for generic parameter: " + gpValue + ", " + mp.value_);
                    continue;
                }
                gpValue = mp.value_;
            }
            if (gpKey != null && gpValue != null) {
                gparamList.add(new MetaPair(gpKey, gpValue));
                continue;
            }
            if (gpKey == null && gpValue == null) {
                msg = new StringBuffer().append("@property='generic-parameter' element without ").append("descendents @property='key' ").append("and @property='value': ").append(ExampleStage.getMarkupContent(gparamEl)).toString();
                reporter.report(FixedCode.E_GPER, msg);
                continue;
            }
            msg = new StringBuffer().append("@property='generic-parameter' element without ").append("descendents @property='key' ").append("or @property='value': ").append(gpMetas).toString();
            reporter.report(FixedCode.E_GPER, msg);
        }
        return gparamList;
    }

    private static List<MetaPair> readTextProperties(Reporter reporter, Set<String> propNames, Element el) {
        ArrayList<MetaPair> list = new ArrayList<MetaPair>();
        String propName = ExampleStage.getAttribute(el, "property");
        if (!"generic-parameter".equals(propName)) {
            if (propNames.contains(propName)) {
                String content = ExampleStage.getRdfaPropertyTextValue(reporter, el);
                list.add(new MetaPair(propName, content));
            }
            for (Node child = el.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof Element)) continue;
                list.addAll(ExampleStage.readTextProperties(reporter, propNames, (Element)child));
            }
        }
        return list;
    }

    private static String getRdfaPropertyTextValue(Reporter reporter, Element el) {
        String property = el.getAttribute("property");
        String hrefAtt = ExampleStage.getAttribute(el, "href");
        String srcAtt = ExampleStage.getAttribute(el, "src");
        String contentAtt = ExampleStage.getAttribute(el, "content");
        if (contentAtt != null) {
            String msg = new StringBuffer().append("@content with @property attribute ").append("forbidden in RDFa Lite: ").append("<").append(el.getTagName()).append(" property=\"").append(property).append("\"").append(" content=\"").append(contentAtt).append("\"").append(">").toString();
            reporter.report(FixedCode.E_RALC, msg);
        }
        if (hrefAtt != null) {
            return hrefAtt;
        }
        if (srcAtt != null) {
            return srcAtt;
        }
        boolean plainText = true;
        StringBuffer sbuf = new StringBuffer();
        for (Node child = el.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof Text) {
                sbuf.append(((Text)child).getData());
                continue;
            }
            plainText = false;
        }
        if (!plainText) {
            reporter.report(FixedCode.E_PTXT, "Non-plain text content of element with property=\"" + property + "\": " + ExampleStage.getMarkupContent(el));
        }
        return sbuf.toString();
    }

    private static class MetaPair {
        final String key_;
        final String value_;

        MetaPair(String key, String value) {
            this.key_ = key;
            this.value_ = value;
        }

        public String toString() {
            return this.key_ + "=" + this.value_;
        }
    }

    private static class TestCount {
        final String name_;
        private int nTry_;
        private int nSucceed_;

        TestCount(String name) {
            this.name_ = name;
        }

        void addResult(Boolean result) {
            if (result != null) {
                ++this.nTry_;
                if (result.booleanValue()) {
                    ++this.nSucceed_;
                }
            }
        }

        public String toString() {
            return new StringBuffer().append(this.name_).append(" success/attempt: ").append(this.nSucceed_).append("/").append(this.nTry_).toString();
        }
    }

    private static interface ExampleStatus {
        public Boolean getSyntaxValid();

        public Boolean getSymbolValid();

        public Boolean getExecuted();
    }

    private static interface Example {
        public String getQuery();

        public String getLang();
    }

    private static class ExampleRunner {
        private final Reporter reporter_;
        private final TapService tapService_;
        private final TapRunner tapRunner_;
        private final CapabilityHolder capHolder_;
        private final MetadataHolder metaHolder_;
        private final TestCount syntaxValidCount_;
        private final TestCount symbolValidCount_;
        private final TestCount executedCount_;
        private final Set<String> exampleDocUrls_;
        private int docCount_;
        private int exampleCount_;
        private AdqlValidatorKit vkit_;

        ExampleRunner(Reporter reporter, TapService tapService, TapRunner tapRunner, CapabilityHolder capHolder, MetadataHolder metaHolder) {
            this.reporter_ = reporter;
            this.tapService_ = tapService;
            this.tapRunner_ = tapRunner;
            this.capHolder_ = capHolder;
            this.metaHolder_ = metaHolder;
            this.exampleDocUrls_ = new HashSet<String>();
            this.syntaxValidCount_ = new TestCount("Syntax validity");
            this.symbolValidCount_ = new TestCount("Symbol validity");
            this.executedCount_ = new TestCount("Execution");
        }

        public void checkExamplesDocument(URL exUrl) throws FileNotFoundException {
            Document doc = null;
            this.reporter_.report(FixedCode.I_EURL, "Reading examples document from " + exUrl);
            try {
                doc = ExampleStage.readXml(this.reporter_, exUrl, CTYPE_XHTML);
            }
            catch (SAXException e) {
                this.reporter_.report(FixedCode.E_EXPA, "Examples document not well-formed X(HT)ML at " + exUrl, e);
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                this.reporter_.report(FixedCode.E_EXIO, "Error reading examples document at " + exUrl, e);
            }
            if (doc == null) {
                return;
            }
            Element examplesEl = this.getExamplesElement(doc);
            if (examplesEl == null) {
                return;
            }
            ++this.docCount_;
            assert (DALI11_VOCAB.toString().equals(PROPERTY_CHECKER.getVocabularyUrl() + "#"));
            if (new Ivoid(PROPERTY_CHECKER.getVocabularyUri() + "#").equalsIvoid(new Ivoid(ExampleStage.getAttribute(examplesEl, "vocab")))) {
                Element[] propEls;
                for (final Element propEl : propEls = ExampleStage.xpathElements(this.reporter_, examplesEl, "//@property/..")) {
                    assert (propEl.hasAttribute("property"));
                    if (!propEl.hasAttribute("property")) continue;
                    final String prop = propEl.getAttribute("property");
                    PROPERTY_CHECKER.checkTerm(prop, new VocabChecker.TermReporter(){

                        @Override
                        public void termFound() {
                        }

                        @Override
                        public void termPreliminary(String msg) {
                            this.message(FixedCode.W_EXVP, "Preliminary", msg);
                        }

                        @Override
                        public void termDeprecated(String msg) {
                            this.message(FixedCode.W_EXVP, "Deprecated", msg);
                        }

                        @Override
                        public void termUnknown(String msg) {
                            this.message(FixedCode.E_EXVP, "Unknown", msg);
                        }

                        private void message(FixedCode code, String type, String msg) {
                            reporter_.report(code, new StringBuffer().append(type).append(" RDFa property attribute \"").append(prop).append("\" in element ").append(propEl.getTagName()).append(": ").append(msg).toString());
                        }
                    });
                }
            }
            this.getAdqlValidatorKit();
            URL[] continuationUrls = this.getContinuationUrls(examplesEl, exUrl);
            Element[] exEls = ExampleStage.xpathElements(this.reporter_, examplesEl, ".//*[@typeof='example']");
            if (exEls.length == 0 && continuationUrls.length == 0) {
                this.reporter_.report(FixedCode.W_EX00, "No examples found in examples document " + exUrl);
            }
            int iex = 0;
            for (Element exEl : exEls) {
                Example ex;
                if ((ex = this.createExample(exEl, iex++)) == null) continue;
                ExampleStatus status = this.validateExample(ex);
                ++this.exampleCount_;
                this.syntaxValidCount_.addResult(status.getSyntaxValid());
                this.symbolValidCount_.addResult(status.getSymbolValid());
                this.executedCount_.addResult(status.getExecuted());
            }
            for (URL contUrl : continuationUrls) {
                try {
                    this.checkExamplesDocument(contUrl);
                }
                catch (FileNotFoundException e) {
                    this.reporter_.report(FixedCode.E_CTNO, "Continuation document \"" + contUrl + "\" not found", e);
                }
            }
        }

        public void reportSummary() {
            String countSummary = new StringBuffer().append("Found ").append(this.exampleCount_).append(this.exampleCount_ == 1 ? " example" : " examples").append(" in ").append(this.docCount_).append(this.docCount_ == 1 ? " document" : " documents").toString();
            this.reporter_.report(FixedCode.S_XNUM, countSummary);
            String testSummary = new StringBuffer().append(this.syntaxValidCount_).append(", ").append(this.symbolValidCount_).append(", ").append(this.executedCount_).toString();
            this.reporter_.report(FixedCode.S_XVAL, testSummary);
        }

        private Element getExamplesElement(Document doc) {
            String infoMsg;
            Element examplesEl;
            Element docEl = doc.getDocumentElement();
            Element[] vocabEls = ExampleStage.xpathElements(this.reporter_, docEl, "//@vocab/..");
            int nvocab = vocabEls.length;
            if (nvocab == 1) {
                Element examplesEl2 = vocabEls[0];
                Ivoid vatt = new Ivoid(ExampleStage.getAttribute(examplesEl2, "vocab"));
                String msgIntro = "Examples document vocab attribute \"" + vatt + "\"";
                String workWithTopcat = "work with some old TOPCAT versions (v4.3-4.4 required \"" + PRAGMATIC_VOCAB + "\", later versions don't care)";
                if (DALI10_VOCAB.equalsIvoid(vatt) || DALI11_VOCAB.equalsIvoid(vatt)) {
                    String daliVersion = DALI11_VOCAB.equalsIvoid(vatt) ? "1.1" : "1.0";
                    String msg = new StringBuffer().append(msgIntro).append(" is correct according to DALI ").append(daliVersion).append(", but won't ").append(workWithTopcat).toString();
                    this.reporter_.report(FixedCode.I_EXVT, msg);
                } else {
                    StringBuffer sbuf = new StringBuffer().append(msgIntro).append(" wrong, should be \"").append(DALI11_VOCAB).append("\" (DALI 1.1)");
                    if (TAPNOTE_VOCAB.equalsIvoid(vatt) || PRAGMATIC_VOCAB.equalsIvoid(vatt)) {
                        sbuf.append(" - it used to be required to ").append(workWithTopcat);
                    }
                    this.reporter_.report(FixedCode.E_EXVC, sbuf.toString());
                }
                return examplesEl2;
            }
            if (nvocab == 0) {
                this.reporter_.report(FixedCode.E_NOVO, "No vocab attributes in examples document - will examine whole doc");
                return docEl;
            }
            assert (nvocab > 1);
            ArrayList<String> vocabs = new ArrayList<String>();
            for (Element vel : vocabEls) {
                vocabs.add(ExampleStage.getAttribute(vel, "vocab"));
            }
            String errMsg = "Multiple vocab attributes in examples document" + vocabs;
            int exIx = -1;
            for (int iv = 0; iv < vocabEls.length; ++iv) {
                if (!Arrays.asList(EXAMPLES_VOCABS).contains(new Ivoid(ExampleStage.getAttribute(vocabEls[iv], "vocab")))) continue;
                exIx = iv;
            }
            if (exIx >= 0) {
                examplesEl = vocabEls[exIx];
                infoMsg = "will use " + ExampleStage.getAttribute(examplesEl, "vocab");
            } else {
                infoMsg = "will examine whole doc";
                examplesEl = docEl;
            }
            this.reporter_.report(FixedCode.E_TOVO, errMsg + " - " + infoMsg);
            return examplesEl;
        }

        private URL[] getContinuationUrls(Element el, URL contextUrl) {
            Element[] contEls;
            ArrayList<URL> urls = new ArrayList<URL>();
            for (Element contEl : contEls = ExampleStage.xpathElements(this.reporter_, el, ".//*[@property='continuation']")) {
                URL url;
                String hrefAtt;
                String resourceAtt = ExampleStage.getAttribute(contEl, "resource");
                if (resourceAtt != null) {
                    String msg = new StringBuffer().append("Attribute resource=\"").append(resourceAtt).append("\" for property=\"continuation\" element").append(" should be absent").append(" (see DALI1.1 Erratum #1,").append(" not empty as DALI1.1 sec 2.3.4").append(" original text)").toString();
                    this.reporter_.report(FixedCode.E_EXCR, msg);
                }
                if ((hrefAtt = ExampleStage.getAttribute(contEl, "href")) != null && hrefAtt.trim().length() > 0) {
                    try {
                        url = contextUrl.toURI().resolve(hrefAtt).toURL();
                    }
                    catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                        url = null;
                    }
                } else {
                    url = null;
                }
                if (url == null) {
                    String msg = new StringBuffer().append(hrefAtt == null || hrefAtt.length() == 0 ? "Missing @href attribute" : "@href attribute \"" + hrefAtt + "\" not a URL").append(" for property=\"continuation\" element").toString();
                    this.reporter_.report(FixedCode.E_EXCH, msg);
                    continue;
                }
                if (this.exampleDocUrls_.add(url.toString())) {
                    urls.add(url);
                    continue;
                }
                this.reporter_.report(FixedCode.W_MLTR, "Multiple references (loop?) to continuation document : " + url);
            }
            return urls.toArray(new URL[0]);
        }

        private Example createExample(Element exEl, int iseq) {
            AdqlValidatorKit vkit = this.getAdqlValidatorKit();
            HoldReporter stashReporter = new HoldReporter();
            String idAtt = ExampleStage.getAttribute(exEl, "id");
            String resourceAtt = ExampleStage.getAttribute(exEl, "resource");
            List gparamList = ExampleStage.readGenericParams(stashReporter, exEl);
            String gpLang = null;
            String gpQuery = null;
            int ngpLang = 0;
            int ngpQuery = 0;
            for (MetaPair gparam : gparamList) {
                String gpkey = gparam.key_;
                String gpvalue = gparam.value_;
                if ("LANG".equalsIgnoreCase(gpkey)) {
                    ++ngpLang;
                    gpLang = gpvalue;
                }
                if (!"QUERY".equalsIgnoreCase(gpkey)) continue;
                ++ngpQuery;
                gpQuery = gpvalue;
            }
            List tpropList = ExampleStage.readTextProperties(stashReporter, BODY_PLAINTEXT_PROPS, exEl);
            int ntpName = 0;
            int ntpQuery = 0;
            String tpQuery = null;
            String tpName = null;
            ArrayList<String> tpTables = new ArrayList<String>();
            for (MetaPair tprop : tpropList) {
                String tpkey = tprop.key_;
                String tpvalue = tprop.value_;
                if ("name".equals(tpkey)) {
                    ++ntpName;
                    tpName = tpvalue;
                }
                if ("query".equals(tpkey)) {
                    ++ntpQuery;
                    tpQuery = tpvalue;
                }
                if (!"table".equals(tpkey)) continue;
                tpTables.add(tpvalue);
            }
            final String exQuery = tpQuery != null ? tpQuery : gpQuery;
            final String exLang = gpLang;
            final String exLabel = idAtt != null ? idAtt : (tpName != null ? "\"" + tpName + "\"" : "#" + (iseq + 1));
            this.reporter_.report(FixedCode.I_EXMP, "Examining example #" + (iseq + 1) + ": " + exLabel);
            stashReporter.dumpReports(this.reporter_);
            stashReporter = null;
            if (ntpName != 1) {
                this.reporter_.report(FixedCode.E_XPRM, "Example " + exLabel + " has no unique @property='name' (" + ntpName + " present)");
            }
            if (ntpQuery > 1) {
                this.reporter_.report(FixedCode.E_XPRM, "Example " + exLabel + " has no unique @property='query' (" + ntpQuery + " present)");
            }
            if (idAtt == null) {
                this.reporter_.report(FixedCode.E_XID0, "Missing id attribute on example " + exLabel);
            } else if (!XMLNAME_REGEX.matcher(idAtt).matches()) {
                this.reporter_.report(FixedCode.W_NMID, "Example @id=\"" + idAtt + "\" is not an XML Name - probably illegal for element " + exEl.getTagName());
            }
            if (resourceAtt == null) {
                this.reporter_.report(FixedCode.E_XRS0, "Missing resource attribute on example " + exLabel);
            } else if (idAtt != null && !resourceAtt.equals("#" + idAtt)) {
                this.reporter_.report(FixedCode.E_XRS1, "Resource/id attribute mismatch on example: \"" + resourceAtt + "\" != \"#" + idAtt + '\"');
            }
            if (ngpLang > 1) {
                this.reporter_.report(FixedCode.E_XPRM, "Multiple LANG generic-parameters in example " + exLabel);
            }
            if (ngpQuery > 1) {
                this.reporter_.report(FixedCode.E_XPRM, "Multiple QUERY generic-parameters in example " + exLabel);
            }
            for (String tname : tpTables) {
                if (vkit.hasTable(tname)) continue;
                this.reporter_.report(FixedCode.E_UKTB, "Unknown table \"" + tname + "\" referenced with property=\"table\" in example " + exLabel);
            }
            if (exQuery != null) {
                return new Example(){

                    @Override
                    public String getQuery() {
                        return exQuery;
                    }

                    @Override
                    public String getLang() {
                        return exLang;
                    }

                    public String toString() {
                        return exLabel;
                    }
                };
            }
            this.reporter_.report(FixedCode.E_XPRM, "Example " + exLabel + " has no query text, cannot test");
            return null;
        }

        private ExampleStatus validateExample(Example ex) {
            Boolean executed;
            Boolean symbolValid;
            boolean hasUploads;
            boolean syntaxOk;
            AdqlValidatorKit vkit = this.getAdqlValidatorKit();
            String query = ex.getQuery();
            AdqlValidator syntaxValidator = vkit.getSyntaxValidator();
            try {
                syntaxValidator.validate(query);
                syntaxOk = true;
            }
            catch (Throwable e) {
                String errmsg = e.getMessage().replaceAll("\n", " ");
                this.reporter_.report(FixedCode.W_EXVL, "Validation syntax error for example " + ex + ": " + errmsg);
                syntaxOk = false;
            }
            final Boolean syntaxValid = syntaxOk;
            boolean bl = hasUploads = query.toUpperCase().indexOf("TAP_UPLOAD") >= 0;
            if (syntaxOk && !hasUploads) {
                boolean symbolOk;
                AdqlValidator symbolValidator = vkit.getValidator(ex.getLang());
                try {
                    symbolValidator.validate(query);
                    symbolOk = true;
                }
                catch (Throwable e) {
                    String errmsg = e.getMessage().replaceAll("\n", " ");
                    this.reporter_.report(FixedCode.W_EXVL, "Validation symbol error for example " + ex + ": " + errmsg);
                    symbolOk = false;
                }
                symbolValid = symbolOk;
            } else {
                symbolValid = null;
            }
            if (!hasUploads && this.tapRunner_ != null && this.tapService_ != null) {
                StarTable table;
                LinkedHashMap<String, String> extraParams = new LinkedHashMap<String, String>();
                extraParams.put("MAXREC", Integer.toString(10));
                TapQuery tq = new TapQuery(this.tapService_, query, extraParams);
                try {
                    table = this.tapRunner_.attemptGetResultTable(this.reporter_, tq);
                }
                catch (IOException e) {
                    this.reporter_.report(FixedCode.W_QERR, "Example query execution failed", e);
                    table = null;
                }
                catch (SAXException e) {
                    this.reporter_.report(FixedCode.E_QERX, "TAP query result parse failed", e);
                    table = null;
                }
                executed = table != null;
            } else {
                executed = null;
            }
            return new ExampleStatus(){

                @Override
                public Boolean getSyntaxValid() {
                    return syntaxValid;
                }

                @Override
                public Boolean getSymbolValid() {
                    return symbolValid;
                }

                @Override
                public Boolean getExecuted() {
                    return executed;
                }
            };
        }

        private AdqlValidatorKit getAdqlValidatorKit() {
            if (this.vkit_ == null) {
                this.vkit_ = AdqlValidatorKit.createInstance(this.reporter_, this.metaHolder_.getTableMetadata(), this.capHolder_.getCapability());
            }
            return this.vkit_;
        }
    }
}

