/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.IOException;
import java.util.ArrayList;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.Reporter;

public abstract class TableData {
    private final StarTable table_;

    TableData(StarTable table) {
        this.table_ = table;
    }

    public abstract int getRowCount();

    public abstract Object getCell(int var1, int var2);

    public Object[] getColumn(int icol) {
        int nrow = this.getRowCount();
        Object[] col = new Object[nrow];
        for (int ir = 0; ir < nrow; ++ir) {
            col[ir] = this.getCell(ir, icol);
        }
        return col;
    }

    public StarTable getTable() {
        return this.table_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableData createTableData(Reporter reporter, StarTable table) {
        if (table == null) {
            return null;
        }
        final ArrayList<Object[]> rowList = new ArrayList<Object[]>();
        try (RowSequence rseq = table.getRowSequence();){
            while (rseq.next()) {
                rowList.add(rseq.getRow());
            }
        }
        catch (IOException e) {
            reporter.report(FixedCode.F_TIOF, "Error reading result table", e);
            return null;
        }
        return new TableData(table){

            @Override
            public int getRowCount() {
                return rowList.size();
            }

            @Override
            public Object getCell(int irow, int icol) {
                return ((Object[])rowList.get(irow))[icol];
            }
        };
    }
}

