/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import uk.ac.starlink.ttools.taplint.AdhocCode;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.MetadataHolder;
import uk.ac.starlink.ttools.taplint.ReportType;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.util.CountMap;
import uk.ac.starlink.vo.AdqlSyntax;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.ForeignMeta;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapService;

public abstract class TableMetadataStage
implements Stage,
MetadataHolder {
    private final String srcDescription_;
    private final String[] knownColFlags_;
    private final boolean reportOtherFlags_;
    private MetadataHolder metaHolder_;
    private Predicate<TableMeta> tableFilter_;
    private static final AdqlSyntax syntax_ = AdqlSyntax.getInstance();
    private static final String[] KNOWN_COL_FLAGS = new String[]{"indexed", "primary", "nullable"};

    public TableMetadataStage(String srcDescription, String[] knownColFlags, boolean reportOtherFlags) {
        this.srcDescription_ = srcDescription;
        this.knownColFlags_ = knownColFlags;
        this.reportOtherFlags_ = reportOtherFlags;
    }

    @Override
    public String getDescription() {
        return "Check content of tables metadata from " + this.srcDescription_;
    }

    public String getSourceDescription() {
        return this.srcDescription_;
    }

    @Override
    public SchemaMeta[] getTableMetadata() {
        return this.metaHolder_ == null ? null : this.metaHolder_.getTableMetadata();
    }

    @Override
    public boolean hasDetail() {
        return this.metaHolder_ != null && this.metaHolder_.hasDetail();
    }

    public void setTableFilter(Predicate<TableMeta> tableFilter) {
        this.tableFilter_ = tableFilter;
    }

    protected abstract MetadataHolder readTableMetadata(Reporter var1, TapService var2);

    @Override
    public void run(Reporter reporter, TapService tapService) {
        MetadataHolder meta = this.filterMetadata(reporter, this.readTableMetadata(reporter, tapService));
        this.checkSchemas(reporter, meta == null ? null : meta.getTableMetadata());
        this.metaHolder_ = meta;
    }

    private MetadataHolder filterMetadata(Reporter reporter, MetadataHolder inMeta) {
        if (inMeta == null || this.tableFilter_ == null) {
            return inMeta;
        }
        ArrayList<SchemaMeta> schemaList = new ArrayList<SchemaMeta>();
        int nTableIn = 0;
        int nTableOut = 0;
        for (SchemaMeta schema : inMeta.getTableMetadata()) {
            nTableIn += schema.getTables().length;
            TableMeta[] tables = Arrays.stream(schema.getTables()).filter(this.tableFilter_).collect(Collectors.toList()).toArray(new TableMeta[0]);
            nTableOut += tables.length;
            if (tables.length <= 0) continue;
            schema.setTables(tables);
            schemaList.add(schema);
        }
        final SchemaMeta[] schemas = schemaList.toArray(new SchemaMeta[0]);
        final boolean hasDetail = inMeta.hasDetail();
        String msg = new StringBuffer().append("Filter applied: ").append(nTableOut).append("/").append(nTableIn).append(" tables in ").append(schemas.length).append("/").append(inMeta.getTableMetadata().length).append(" schemas").toString();
        reporter.report(FixedCode.S_FILT, msg);
        return new MetadataHolder(){

            @Override
            public SchemaMeta[] getTableMetadata() {
                return schemas;
            }

            @Override
            public boolean hasDetail() {
                return hasDetail;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private void checkSchemas(Reporter reporter, SchemaMeta[] smetas) {
        void var11_16;
        if (smetas == null) {
            reporter.report(FixedCode.F_GONE, "Table metadata absent");
            return;
        }
        int nSchema = smetas.length;
        Map<String, SchemaMeta> schemaMap = this.createNameMap(reporter, "schema", 'S', smetas);
        for (String string : schemaMap.keySet()) {
            if (string == null) continue;
            this.checkSchemaName(reporter, string);
        }
        ArrayList<TableMeta> tmList = new ArrayList<TableMeta>();
        for (SchemaMeta smeta : smetas) {
            tmList.addAll(Arrays.asList(smeta.getTables()));
        }
        TableMeta[] tableMetaArray = tmList.toArray(new TableMeta[0]);
        int nTable = tableMetaArray.length;
        int nCol = 0;
        Map<String, TableMeta> tableMap = this.createNameMap(reporter, "table", 'T', tableMetaArray);
        for (String string : tableMap.keySet()) {
            if (string == null) continue;
            this.checkTableName(reporter, string);
        }
        HashMap colsMap = new HashMap();
        for (String tname : tableMap.keySet()) {
            TableMeta tmeta = tableMap.get(tname);
            ColumnMeta[] cols = tmeta.getColumns();
            nCol += cols.length;
            Map cmap = this.createNameMap(reporter, "column", 'C', cols);
            for (String cname : cmap.keySet()) {
                if (cname == null) continue;
                this.checkColumnName(reporter, cname, tmeta);
            }
            colsMap.put(tname, cmap);
        }
        boolean bl = false;
        int nIndex = 0;
        CountMap flagMap = new CountMap();
        for (String tname : tableMap.keySet()) {
            TableMeta tmeta = tableMap.get(tname);
            Map cmap = (Map)colsMap.get(tname);
            for (String cname : cmap.keySet()) {
                ColumnMeta col = (ColumnMeta)cmap.get(cname);
                if (col.isIndexed()) {
                    ++nIndex;
                }
                String[] flags = col.getFlags();
                for (int ig = 0; ig < flags.length; ++ig) {
                    flagMap.addItem((Object)flags[ig]);
                }
            }
            ForeignMeta[] fkeys = tmeta.getForeignKeys();
            var11_16 += fkeys.length;
            for (int ik = 0; ik < fkeys.length; ++ik) {
                ForeignMeta fkey = fkeys[ik];
                String targetTableName = fkey.getTargetTable();
                TableMeta targetTable = tableMap.get(targetTableName);
                if (targetTable == null) {
                    String msg = new StringBuffer().append("Non-existent target table ").append(fkey.getTargetTable()).append(" for foreign key in table ").append(tmeta).toString();
                    reporter.report(FixedCode.E_FKNT, msg);
                    continue;
                }
                Map targetCmap = (Map)colsMap.get(targetTableName);
                ForeignMeta.Link[] links = fkey.getLinks();
                for (int il = 0; il < links.length; ++il) {
                    ForeignMeta.Link link = links[il];
                    ColumnMeta fromCol = (ColumnMeta)cmap.get(link.getFrom());
                    ColumnMeta toCol = (ColumnMeta)targetCmap.get(link.getTarget());
                    if (fromCol == null || toCol == null) {
                        StringBuilder mbuf = new StringBuilder().append("Broken link ").append(link).append(" in foreign key ").append(tname).append(fkey);
                        if (fromCol == null) {
                            mbuf.append(" (no column ").append(tname).append('.').append(link.getFrom()).append(')');
                        }
                        if (toCol == null) {
                            mbuf.append(" (no column ").append(targetTableName).append('.').append(link.getTarget()).append(')');
                        }
                        reporter.report(FixedCode.E_FKLK, mbuf.toString());
                        continue;
                    }
                    String fromType = fromCol.getDataType();
                    String toType = toCol.getDataType();
                    if (fromType != null && fromType.equals(toType)) continue;
                    String msg = new StringBuffer().append("Type mismatch for link ").append(link).append(" in foreign key ").append(fkey).append("; ").append(fromType).append(" vs. ").append(toType).toString();
                    reporter.report(FixedCode.W_FTYP, msg);
                }
            }
        }
        HashSet otherFlagList = new HashSet(flagMap.keySet());
        otherFlagList.removeAll(Arrays.asList(this.knownColFlags_));
        String[] otherFlags = otherFlagList.toArray(new String[0]);
        reporter.report(FixedCode.S_SUMM, "Schemas: " + nSchema + ", Tables: " + nTable + ", Columns: " + nCol + ", Foreign Keys: " + (int)var11_16);
        reporter.report(FixedCode.S_FLGS, "Standard column flags: " + this.summariseCounts((CountMap<String>)flagMap, this.knownColFlags_));
        if (this.reportOtherFlags_) {
            reporter.report(FixedCode.S_FLGO, "Other column flags: " + this.summariseCounts((CountMap<String>)flagMap, otherFlags));
        }
    }

    private void checkSchemaName(Reporter reporter, String sname) {
    }

    private void checkTableName(Reporter reporter, String tname) {
        if (!syntax_.isAdqlTableName(tname)) {
            reporter.report(FixedCode.E_TNTN, "Bad ADQL table name '" + tname + "'");
        }
        if (syntax_.isReserved(tname)) {
            reporter.report(FixedCode.E_TRSV, "Table name is ADQL reserved word '" + tname + "'");
        }
    }

    private void checkColumnName(Reporter reporter, String cname, TableMeta tmeta) {
        String detailTxt = " '" + cname + "' in table " + tmeta.getName() + " - should delimit like '" + syntax_.quote(cname) + "'";
        if (!syntax_.isAdqlColumnName(cname)) {
            reporter.report(FixedCode.E_CNID, "Column name is not ADQL identifier" + detailTxt);
        }
        if (syntax_.isReserved(cname)) {
            reporter.report(FixedCode.E_CRSV, "Column name is ADQL reserved word" + detailTxt);
        }
    }

    private String summariseCounts(CountMap<String> countMap, String[] keys) {
        if (keys.length == 0) {
            return "none";
        }
        StringBuffer sbuf = new StringBuffer();
        for (int ik = 0; ik < keys.length; ++ik) {
            String key = keys[ik];
            if (ik > 0) {
                sbuf.append(", ");
            }
            sbuf.append(key).append(": ").append(countMap.getCount((Object)key));
        }
        return sbuf.toString();
    }

    private <V> Map<String, V> createNameMap(Reporter reporter, String dName, char dChr, V[] values) {
        LinkedHashMap<String, V> map = new LinkedHashMap<String, V>();
        for (int iv = 0; iv < values.length; ++iv) {
            V value = values[iv];
            String name = value.toString();
            if (name == null || name.trim().length() == 0) {
                reporter.report(new AdhocCode(ReportType.ERROR, "" + dChr + "BLA"), "Blank name for " + dName + " #" + iv);
            }
            if (!map.containsKey(name)) {
                map.put(name, value);
                continue;
            }
            reporter.report(new AdhocCode(ReportType.WARNING, "" + dChr + "DUP"), "Duplicate " + dName + " \"" + name + "\"");
        }
        return map;
    }
}

