/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.net.URL;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.ttools.taplint.XsdValidation;
import uk.ac.starlink.vo.TapService;

public abstract class XsdStage
implements Stage {
    private final String topElName_;
    private final String topElNamespaceUri_;
    private final boolean isMandatory_;
    private final String description_;
    private XsdValidation.Result result_;

    protected XsdStage(String topElNamespaceUri, String topElName, boolean isMandatory, String resourceDescription) {
        this.topElName_ = topElName;
        this.topElNamespaceUri_ = topElNamespaceUri;
        this.isMandatory_ = isMandatory;
        this.description_ = "Validate " + resourceDescription + " against XML schema";
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public abstract URL getDocumentUrl(TapService var1);

    @Override
    public void run(Reporter reporter, TapService tapService) {
        URL docUrl = this.getDocumentUrl(tapService);
        reporter.report(FixedCode.I_VURL, "Validating " + docUrl + " as " + this.topElName_ + " (" + this.topElNamespaceUri_ + ")");
        boolean includeSummary = true;
        this.result_ = XsdValidation.validateDoc(reporter, docUrl, this.topElName_, this.topElNamespaceUri_, includeSummary);
        if (this.result_ == XsdValidation.Result.NOT_FOUND) {
            if (this.isMandatory_) {
                reporter.report(FixedCode.E_GONM, "Mandatory resource " + docUrl + " not present");
            } else {
                reporter.report(FixedCode.W_GONO, "Optional resource " + docUrl + " not present");
            }
        }
    }

    public XsdValidation.Result getResult() {
        return this.result_;
    }
}

