/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.Supplier;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.filter.StatsFilter;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.task.Aggregator;
import uk.ac.starlink.util.ByteList;
import uk.ac.starlink.util.DoubleList;
import uk.ac.starlink.util.FloatList;
import uk.ac.starlink.util.IntList;
import uk.ac.starlink.util.Loader;
import uk.ac.starlink.util.LongList;
import uk.ac.starlink.util.ShortList;

public class Aggregators {
    public static final Aggregator COUNT = new CountAggregator("count", false);
    public static final Aggregator NGOOD = new CountGoodAggregator("ngood", false);
    public static final Aggregator SUM = new CombinerAggregator("sum", Combiner.SUM);
    public static final Aggregator MEAN = new CombinerAggregator("mean", Combiner.MEAN);
    public static final Aggregator MEDIAN = new CombinerAggregator("median", Combiner.MEDIAN);
    public static final Aggregator SAMPLE_STDEV = new CombinerAggregator("stdev", Combiner.SAMPLE_STDEV);
    public static final Aggregator POP_STDEV = new CombinerAggregator("stdev-pop", Combiner.POP_STDEV);
    public static final Aggregator MAX = new ExtremumAggregator("max", true);
    public static final Aggregator MIN = new ExtremumAggregator("min", false);
    public static final Aggregator ARRAY_NOBLANKS = new ArrayAggregator("array", false);
    public static final Aggregator ARRAY_WITHBLANKS = new ArrayAggregator("array-withblanks", true);
    public static final Aggregator COUNT_LONG = new CountAggregator("count-long", true);
    public static final Aggregator NGOOD_LONG = new CountGoodAggregator("ngood-long", true);
    private static final Aggregator[] INSTANCES = new Aggregator[]{COUNT, NGOOD, SUM, MEAN, MEDIAN, SAMPLE_STDEV, POP_STDEV, MAX, MIN, ARRAY_NOBLANKS, ARRAY_WITHBLANKS, COUNT_LONG, NGOOD_LONG};

    private Aggregators() {
    }

    public static Aggregator[] getAggregators() {
        return (Aggregator[])INSTANCES.clone();
    }

    public static Aggregator getAggregator(String aggTxt) {
        if (aggTxt == null) {
            return null;
        }
        for (Aggregator agg : INSTANCES) {
            if (!aggTxt.equalsIgnoreCase(agg.getName())) continue;
            return agg;
        }
        double quant = StatsFilter.parseQuantileSpecifier(aggTxt);
        if (!Double.isNaN(quant)) {
            Combiner qcombiner = Combiner.createQuantileCombiner(aggTxt, null, quant);
            return new CombinerAggregator(aggTxt, qcombiner);
        }
        Aggregator reflectAgg = (Aggregator)Loader.getClassInstance((String)aggTxt, Aggregator.class);
        if (reflectAgg != null) {
            return reflectAgg;
        }
        return null;
    }

    public static String getOptionsDescription() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<ul>\n");
        for (Aggregator agg : INSTANCES) {
            sbuf.append("<li>").append("<code>").append(agg.getName()).append("</code>: ").append(agg.getDescription()).append("</li>\n");
        }
        sbuf.append("<li><code>Q.nnn</code>: ").append("quantile nnn (e.g. Q.05 is the fifth percentile)").append("</li>\n");
        sbuf.append("</ul>\n");
        return sbuf.toString();
    }

    private static class BooleanList {
        private final BitSet bitset_ = new BitSet();
        private int nbit_;

        BooleanList() {
        }

        public void add(boolean bit) {
            if (bit) {
                this.bitset_.set(this.nbit_);
            }
            ++this.nbit_;
        }

        public boolean[] toBooleanArray() {
            boolean[] bits = new boolean[this.nbit_];
            int ipos = this.bitset_.nextSetBit(0);
            while (ipos >= 0) {
                bits[ipos] = true;
                ipos = this.bitset_.nextSetBit(ipos + 1);
            }
            return bits;
        }

        public void addAll(BooleanList otherList) {
            for (int i = 0; i < otherList.nbit_; ++i) {
                this.add(otherList.bitset_.get(i));
            }
        }
    }

    private static class ArrayAggregator
    extends AbstractAggregator {
        final boolean includeBlanks_;

        ArrayAggregator(String name, boolean includeBlanks) {
            super(name, includeBlanks ? "collects all values into an array; blank values are represented as zero for integers" : "collects all non-blank values into an array");
            this.includeBlanks_ = includeBlanks;
        }

        @Override
        public Aggregator.Aggregation createAggregation(ValueInfo info) {
            Class clazz = info.getContentClass();
            if (clazz == Byte.class) {
                return new ArrayAggregation<byte[]>(byte[].class, info, () -> new ArrayAccumulator<byte[], ByteList>(new ByteList()){

                    @Override
                    public void submit(Object datum) {
                        if (datum instanceof Number) {
                            ((ByteList)this.list_).add(((Number)datum).byteValue());
                        } else if (includeBlanks_) {
                            ((ByteList)this.list_).add((byte)0);
                        }
                    }

                    @Override
                    public byte[] getResult() {
                        return ((ByteList)this.list_).toByteArray();
                    }

                    @Override
                    public void addList(ByteList otherList) {
                        ((ByteList)this.list_).addAll(otherList);
                    }
                });
            }
            if (clazz == Short.class) {
                return new ArrayAggregation<short[]>(short[].class, info, () -> new ArrayAccumulator<short[], ShortList>(new ShortList()){

                    @Override
                    public void submit(Object datum) {
                        if (datum instanceof Number) {
                            ((ShortList)this.list_).add(((Number)datum).shortValue());
                        } else if (includeBlanks_) {
                            ((ShortList)this.list_).add((short)0);
                        }
                    }

                    @Override
                    public short[] getResult() {
                        return ((ShortList)this.list_).toShortArray();
                    }

                    @Override
                    public void addList(ShortList otherList) {
                        ((ShortList)this.list_).addAll(otherList);
                    }
                });
            }
            if (clazz == Integer.class) {
                return new ArrayAggregation<int[]>(int[].class, info, () -> new ArrayAccumulator<int[], IntList>(new IntList()){

                    @Override
                    public void submit(Object datum) {
                        if (datum instanceof Number) {
                            ((IntList)this.list_).add(((Number)datum).intValue());
                        } else if (includeBlanks_) {
                            ((IntList)this.list_).add(0);
                        }
                    }

                    @Override
                    public int[] getResult() {
                        return ((IntList)this.list_).toIntArray();
                    }

                    @Override
                    public void addList(IntList otherList) {
                        ((IntList)this.list_).addAll(otherList);
                    }
                });
            }
            if (clazz == Long.class) {
                return new ArrayAggregation<long[]>(long[].class, info, () -> new ArrayAccumulator<long[], LongList>(new LongList()){

                    @Override
                    public void submit(Object datum) {
                        if (datum instanceof Number) {
                            ((LongList)this.list_).add(((Number)datum).longValue());
                        } else if (includeBlanks_) {
                            ((LongList)this.list_).add(0L);
                        }
                    }

                    @Override
                    public long[] getResult() {
                        return ((LongList)this.list_).toLongArray();
                    }

                    @Override
                    public void addList(LongList otherList) {
                        ((LongList)this.list_).addAll(otherList);
                    }
                });
            }
            if (clazz == Float.class) {
                return new ArrayAggregation<float[]>(float[].class, info, () -> new ArrayAccumulator<float[], FloatList>(new FloatList()){

                    @Override
                    public void submit(Object datum) {
                        if (datum instanceof Number) {
                            float fval = ((Number)datum).floatValue();
                            if (includeBlanks_ || !Float.isNaN(fval)) {
                                ((FloatList)this.list_).add(fval);
                            }
                        } else if (includeBlanks_) {
                            ((FloatList)this.list_).add(Float.NaN);
                        }
                    }

                    @Override
                    public float[] getResult() {
                        return ((FloatList)this.list_).toFloatArray();
                    }

                    @Override
                    public void addList(FloatList otherList) {
                        ((FloatList)this.list_).addAll(otherList);
                    }
                });
            }
            if (clazz == Double.class) {
                return new ArrayAggregation<double[]>(double[].class, info, () -> new ArrayAccumulator<double[], DoubleList>(new DoubleList()){

                    @Override
                    public void submit(Object datum) {
                        if (datum instanceof Number) {
                            double dval = ((Number)datum).doubleValue();
                            if (includeBlanks_ || !Double.isNaN(dval)) {
                                ((DoubleList)this.list_).add(dval);
                            }
                        } else if (includeBlanks_) {
                            ((DoubleList)this.list_).add(Double.NaN);
                        }
                    }

                    @Override
                    public double[] getResult() {
                        return ((DoubleList)this.list_).toDoubleArray();
                    }

                    @Override
                    public void addList(DoubleList otherList) {
                        ((DoubleList)this.list_).addAll(otherList);
                    }
                });
            }
            if (clazz == Boolean.class) {
                return new ArrayAggregation<boolean[]>(boolean[].class, info, () -> new ArrayAccumulator<boolean[], BooleanList>(new BooleanList()){

                    @Override
                    public void submit(Object datum) {
                        if (datum instanceof Boolean) {
                            ((BooleanList)this.list_).add((Boolean)datum);
                        } else if (includeBlanks_) {
                            ((BooleanList)this.list_).add(false);
                        }
                    }

                    @Override
                    public boolean[] getResult() {
                        return ((BooleanList)this.list_).toBooleanArray();
                    }

                    @Override
                    public void addList(BooleanList otherList) {
                        ((BooleanList)this.list_).addAll(otherList);
                    }
                });
            }
            if (clazz == String.class) {
                return ArrayAggregator.createObjectArrayAggregation(String.class, info, this.includeBlanks_);
            }
            if (clazz.getComponentType() != null) {
                return null;
            }
            return ArrayAggregator.createObjectArrayAggregation(clazz, info, this.includeBlanks_);
        }

        private static <E> ArrayAggregation<E[]> createObjectArrayAggregation(Class<E> elClazz, ValueInfo inInfo, boolean includeBlanks) {
            if (!elClazz.isAssignableFrom(inInfo.getContentClass())) {
                throw new IllegalArgumentException();
            }
            Class<?> arrayClazz = Array.newInstance(elClazz, 0).getClass();
            return new ArrayAggregation<E[]>(arrayClazz, inInfo, () -> new ObjectArrayAccumulator(elClazz, includeBlanks));
        }

        private static class ObjectArrayAccumulator<E>
        extends ArrayAccumulator<E[], List<E>> {
            final Class<E> elClazz_;
            final boolean includeBlanks_;

            ObjectArrayAccumulator(Class<E> elClazz, boolean includeBlanks) {
                super(new ArrayList());
                this.elClazz_ = elClazz;
                this.includeBlanks_ = includeBlanks;
            }

            @Override
            public void submit(Object datum) {
                if (this.elClazz_.isInstance(datum)) {
                    E edatum = this.elClazz_.cast(datum);
                    if (this.includeBlanks_ || !Tables.isBlank((Object)datum)) {
                        ((List)this.list_).add(edatum);
                    }
                } else if (this.includeBlanks_) {
                    ((List)this.list_).add(null);
                }
            }

            @Override
            public E[] getResult() {
                Object[] array0 = (Object[])Array.newInstance(this.elClazz_, 0);
                return ((List)this.list_).toArray(array0);
            }

            @Override
            public void addList(List<E> otherList) {
                ((List)this.list_).addAll(otherList);
            }
        }

        private static abstract class ArrayAccumulator<A, L>
        implements Aggregator.Accumulator {
            final L list_;

            ArrayAccumulator(L list) {
                this.list_ = list;
            }

            public abstract A getResult();

            @Override
            public void add(Aggregator.Accumulator other) {
                L otherList = ((ArrayAccumulator)other).list_;
                this.addList(otherList);
            }

            abstract void addList(L var1);
        }

        private static class ArrayAggregation<A>
        implements Aggregator.Aggregation {
            final ValueInfo outInfo_;
            final Supplier<ArrayAccumulator<A, ?>> accSupplier_;

            ArrayAggregation(Class<A> arrayClazz, ValueInfo inInfo, Supplier<ArrayAccumulator<A, ?>> accSupplier) {
                String inName = inInfo.getName();
                String descrip = "Collection of all values for " + inName;
                this.outInfo_ = new DefaultValueInfo(inName, arrayClazz, descrip);
                this.accSupplier_ = accSupplier;
            }

            @Override
            public ValueInfo getResultInfo() {
                return this.outInfo_;
            }

            @Override
            public Aggregator.Accumulator createAccumulator() {
                return this.accSupplier_.get();
            }
        }
    }

    private static class CombinerAggregator
    extends AbstractAggregator {
        final Combiner combiner_;

        CombinerAggregator(String name, Combiner combiner) {
            super(name, combiner.getDescription());
            this.combiner_ = combiner;
        }

        @Override
        public Aggregator.Aggregation createAggregation(ValueInfo info) {
            return Number.class.isAssignableFrom(info.getContentClass()) ? new DefaultAggregation(this.combiner_.createCombinedInfo(info, null), () -> new CombinerAccumulator(this.combiner_.createContainer())) : null;
        }

        private static class CombinerAccumulator
        implements Aggregator.Accumulator {
            final Combiner.Container container_;

            CombinerAccumulator(Combiner.Container container) {
                this.container_ = container;
            }

            @Override
            public void submit(Object datum) {
                double dval;
                if (datum instanceof Number && !Double.isNaN(dval = ((Number)datum).doubleValue())) {
                    this.container_.submit(dval);
                }
            }

            @Override
            public Object getResult() {
                return this.container_.getCombinedValue();
            }

            @Override
            public void add(Aggregator.Accumulator other) {
                this.container_.add(((CombinerAccumulator)other).container_);
            }
        }
    }

    private static class ExtremumAggregator
    extends AbstractAggregator {
        final boolean isMax_;

        ExtremumAggregator(String name, boolean isMax) {
            super(name, "records the " + (isMax ? "max" : "min") + "imum value");
            this.isMax_ = isMax;
        }

        @Override
        public Aggregator.Aggregation createAggregation(ValueInfo inInfo) {
            Class clazz = inInfo.getContentClass();
            if (Comparable.class.isAssignableFrom(clazz)) {
                String inName = inInfo.getName();
                String outName = (this.isMax_ ? "max_" : "min_") + inName;
                String outDescrip = (this.isMax_ ? "Maximum" : "Minimum") + " value for " + inName;
                return new DefaultAggregation((ValueInfo)new DefaultValueInfo(outName, clazz, outDescrip), () -> this.createExtremumAccumulator(clazz));
            }
            return null;
        }

        private Aggregator.Accumulator createExtremumAccumulator(Class<?> comparableClazz) {
            if (!Comparable.class.isAssignableFrom(comparableClazz)) {
                throw new IllegalArgumentException();
            }
            Class<?> clazz = comparableClazz;
            ExtremumAccumulator acc = new ExtremumAccumulator(this.isMax_, clazz);
            return acc;
        }

        private static class ExtremumAccumulator<T extends Comparable<T>>
        implements Aggregator.Accumulator {
            final boolean isMax_;
            final Class<T> clazz_;
            T extremum_;

            ExtremumAccumulator(boolean isMax, Class<T> clazz) {
                this.isMax_ = isMax;
                this.clazz_ = clazz;
            }

            @Override
            public void submit(Object datum) {
                if (this.clazz_.isInstance(datum) && !Tables.isBlank((Object)datum)) {
                    Comparable tvalue = (Comparable)this.clazz_.cast(datum);
                    if (this.extremum_ == null) {
                        this.extremum_ = tvalue;
                    } else {
                        int comparison = tvalue.compareTo(this.extremum_);
                        if (this.isMax_ ? comparison > 0 : comparison < 0) {
                            this.extremum_ = tvalue;
                        }
                    }
                }
            }

            public T getResult() {
                return this.extremum_;
            }

            @Override
            public void add(Aggregator.Accumulator other) {
                this.submit(((ExtremumAccumulator)other).extremum_);
            }
        }
    }

    private static class CountGoodAggregator
    extends AbstractAggregator {
        private final boolean isLong_;

        CountGoodAggregator(String name, boolean isLong) {
            super(name, "counts the number of non-blank items" + (isLong ? ", works for >2 billion" : ""));
            this.isLong_ = isLong;
        }

        @Override
        public Aggregator.Aggregation createAggregation(ValueInfo inInfo) {
            final Class clazz = inInfo.getContentClass();
            String inName = inInfo.getName();
            Supplier<Aggregator.Accumulator> accSupplier = () -> new CountAccumulator(this.isLong_){

                @Override
                public void submit(Object datum) {
                    if (clazz.isInstance(datum) && !Tables.isBlank((Object)datum)) {
                        this.increment();
                    }
                }
            };
            DefaultValueInfo outInfo = new DefaultValueInfo("ngood_" + inName, accSupplier.get().getResult().getClass(), "Number of non-blank entries in " + inName);
            return new DefaultAggregation((ValueInfo)outInfo, accSupplier);
        }
    }

    private static class CountAggregator
    extends AbstractAggregator
    implements Aggregator.Aggregation {
        private final boolean isLong_;

        CountAggregator(String name, boolean isLong) {
            super(name, "counts the number of rows" + (isLong ? ", works for >2 billion" : ""));
            this.isLong_ = isLong;
        }

        @Override
        public Aggregator.Aggregation createAggregation(ValueInfo info) {
            return this;
        }

        @Override
        public ValueInfo getResultInfo() {
            return new DefaultValueInfo("count", this.createAccumulator().getResult().getClass(), "number of rows in group");
        }

        @Override
        public Aggregator.Accumulator createAccumulator() {
            return new CountAccumulator(this.isLong_){

                @Override
                public void submit(Object datum) {
                    this.increment();
                }
            };
        }
    }

    private static abstract class CountAccumulator
    implements Aggregator.Accumulator {
        private final boolean isLong_;
        private long count_;

        CountAccumulator(boolean isLong) {
            this.isLong_ = isLong;
        }

        public void increment() {
            ++this.count_;
        }

        @Override
        public Object getResult() {
            if (this.isLong_) {
                return this.count_;
            }
            int icount = (int)this.count_;
            return (long)icount == this.count_ ? icount : -1;
        }

        @Override
        public void add(Aggregator.Accumulator other) {
            this.count_ += ((CountAccumulator)other).count_;
        }
    }

    private static class DefaultAggregation
    implements Aggregator.Aggregation {
        final ValueInfo outInfo_;
        final Supplier<Aggregator.Accumulator> accSupplier_;

        DefaultAggregation(ValueInfo outInfo, Supplier<Aggregator.Accumulator> accSupplier) {
            this.outInfo_ = outInfo;
            this.accSupplier_ = accSupplier;
        }

        @Override
        public ValueInfo getResultInfo() {
            return this.outInfo_;
        }

        @Override
        public Aggregator.Accumulator createAccumulator() {
            return this.accSupplier_.get();
        }
    }

    private static abstract class AbstractAggregator
    implements Aggregator {
        final String name_;
        final String description_;

        AbstractAggregator(String name, String description) {
            this.name_ = name;
            this.description_ = description;
        }

        @Override
        public String getName() {
            return this.name_;
        }

        @Override
        public String getDescription() {
            return this.description_;
        }
    }
}

