/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.JoinStarTable;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.RowSubsetStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;
import uk.ac.starlink.ttools.jel.JELRowReader;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.SequentialJELRowReader;
import uk.ac.starlink.ttools.task.AbstractInputTableParameter;
import uk.ac.starlink.ttools.task.ChoiceMode;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.InputFormatParameter;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.JoinFixActionParameter;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.ttools.task.SingleMapperTask;
import uk.ac.starlink.ttools.task.TableProducer;
import uk.ac.starlink.util.IOFunction;

public class ArrayJoin
extends SingleMapperTask {
    private final ExpressionInputTableParameter atableParam_;
    private final BooleanParameter keepallParam_;
    private final InputFormatParameter afmtParam_;
    private final FilterParameter acmdParam_ = new FilterParameter("acmd");
    private final BooleanParameter astreamParam_;
    private final StringParameter aparamsParam_;
    private final BooleanParameter cacheParam_;
    private final JoinFixActionParameter fixcolsParam_;
    private final StringParameter asuffixParam_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public ArrayJoin() {
        super("Adds table-per-row data as array-valued columns", new ChoiceMode(), true, true);
        this.atableParam_ = new ExpressionInputTableParameter("atable");
        this.atableParam_.setTableDescription("array tables");
        this.atableParam_.setPrompt("Per-row location of tables with array data");
        this.atableParam_.setUsage("<loc-expr>");
        this.atableParam_.setDescription(new String[]{"<p>Gives the location of the table whose rows will be turned into", "an array-valued column.", "This will generally be an <ref id='jel'>expression</ref>", "giving a URL or filename that is different", "for each row of the input table.", "If table loading fails for the given location,", "for instance becase the file is not found or an HTTP 404", "response is received,", "the array cells in the corresponding row will be blank.", "</p>", "<p>The first non-blank table loaded defines the array columns", "to be added.", "If subsequent tables have a different structure", "(do not contain similar columns in a similar sequence)", "an error may result.", "If the external array tables are not all homogenous in this way,", "the <code>" + this.acmdParam_.getName() + "</code> parameter", "can be used to filter them so that they are.", "</p>"});
        this.afmtParam_ = this.atableParam_.getFormatParameter();
        this.astreamParam_ = this.atableParam_.getStreamParameter();
        this.acmdParam_.setTableDescription("array tables", this.atableParam_, true);
        this.aparamsParam_ = new StringParameter("aparams");
        this.aparamsParam_.setPrompt("Parameters from external tables to include");
        this.aparamsParam_.setUsage("<name-list>");
        this.aparamsParam_.setNullPermitted(true);
        this.aparamsParam_.setDescription(new String[]{"<p>Lists the table parameters (per-table metadata)", "that will be read from loaded tables", "and turned into scalar-valued columns in the output.", "By default parameters are discarded,", "but you can include them in the output by naming them", "using this parameter.", "</p>", "<p>Parameters are supplied as a space- or comma-separated list.", "Matching against table names is case-insensitive,", "and the asterisk character \"<code>*</code>\" may be used", "as a wildcard to match any sequence of characters.", "The list is interpreted relative to the first external table", "which is loaded.", "Supplying the value \"<code>*</code>\" therefore will include", "a column for each parameter in the first loaded table.", "</p>"});
        this.keepallParam_ = new BooleanParameter("keepall");
        this.keepallParam_.setPrompt("Retain rows without array table?");
        this.keepallParam_.setBooleanDefault(true);
        this.keepallParam_.setDescription(new String[]{"<p>This parameter determines what happens when the", "<code>" + this.atableParam_.getName() + "</code> parameter", "does not name a table that can be loaded.", "If this parameter is false,", "the input table row is output with blank values in the columns", "supplied by the array tables,", "so that the output table has the same number of rows as the", "input table.", "If it is true, only rows with successfully loaded tables", "are included in the output.", "</p>"});
        this.cacheParam_ = new BooleanParameter("cache");
        this.cacheParam_.setPrompt("Cache array values?");
        this.cacheParam_.setBooleanDefault(true);
        this.cacheParam_.setDescription(new String[]{"<p>Determines whether the array data will be cached", "the first time an array table is read (true)", "or re-read from the array table every time", "the row is accessed (false).", "Since the row construction may be an expensive step,", "especially if the tables are downloaded,", "it usually makes sense to set this true (the default).", "When true it also enables the metadata to be adjusted", "to report constant array length where applicable,", "which cannot be done before all the rows have been scanned,", "and which may enable more efficient file output.", "However, if you want to stream the data you can set it false.", "</p>"});
        this.fixcolsParam_ = new JoinFixActionParameter("fixcols");
        this.asuffixParam_ = this.fixcolsParam_.createSuffixParameter("suffixarray", "the array tables", "_a");
    }

    @Override
    public Parameter<?>[] getParameters() {
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(Arrays.asList(super.getParameters()));
        params.addAll(Arrays.asList(new Parameter[]{this.atableParam_, this.afmtParam_, this.astreamParam_, this.acmdParam_, this.keepallParam_, this.aparamsParam_, this.cacheParam_, this.fixcolsParam_, this.asuffixParam_}));
        return params.toArray(new Parameter[0]);
    }

    @Override
    public TableProducer createProducer(Environment env) throws TaskException {
        final TableProducer inProd = this.createInputProducer(env);
        final String atableExpr = this.atableParam_.stringValue(env);
        String fmt = this.afmtParam_.stringValue(env);
        boolean stream = this.astreamParam_.booleanValue(env);
        ProcessingStep[] asteps = this.acmdParam_.stepsValue(env);
        final boolean keepAll = this.keepallParam_.booleanValue(env);
        final String aparamsTxt = this.aparamsParam_.stringValue(env);
        StarTableFactory tfact = LineTableEnvironment.getTableFactory(env);
        boolean allowMissing = true;
        final boolean isCached = this.cacheParam_.booleanValue(env);
        final IOFunction atableReader = loc -> {
            StarTable atable;
            logger_.info("Loading table: " + loc);
            try {
                atable = this.atableParam_.makeTable((String)loc, fmt, stream, tfact);
            }
            catch (IOException e) {
                if (allowMissing) {
                    logger_.log(Level.INFO, "Table load failed for " + loc, e);
                    return null;
                }
                throw e;
            }
            catch (TaskException e) {
                throw new IOException(e.getMessage(), e);
            }
            InputTableSpec spec = InputTableSpec.createSpec(loc, asteps, atable);
            try {
                return spec.getWrappedTable();
            }
            catch (TaskException e) {
                throw new IOException("Trouble filtering array table " + loc, e);
            }
        };
        final JoinFixAction inFixact = JoinFixAction.NO_ACTION;
        final JoinFixAction aFixact = this.fixcolsParam_.getJoinFixAction(env, this.asuffixParam_);
        return new TableProducer(){

            @Override
            public StarTable getTable() throws IOException, TaskException {
                StarTable inTable1;
                ArrayDataTable arrayTable;
                Function<Library, CompiledExpression> alocCompiler;
                StarTable inTable = inProd.getTable();
                try {
                    alocCompiler = JELUtils.compiler(inTable, atableExpr, String.class);
                }
                catch (CompilationException e) {
                    throw new ParameterValueException((Parameter)ArrayJoin.this.atableParam_, "Bad table location", (Throwable)e);
                }
                ArrayDataTable seqArrayTable = ArrayJoin.createSequentialArrayTable(inTable, alocCompiler, (IOFunction<String, StarTable>)atableReader, keepAll, aparamsTxt);
                ArrayDataTable arrayDataTable = arrayTable = isCached ? ArrayJoin.cacheArrayTable(seqArrayTable) : seqArrayTable;
                if (keepAll) {
                    inTable1 = inTable;
                } else {
                    if (seqArrayTable.rowMask_ == null) {
                        assert (!isCached);
                        try (RowSequence rseq = seqArrayTable.getRowSequence();){
                            while (rseq.next()) {
                                rseq.getRow();
                            }
                        }
                    }
                    BitSet rowMask = seqArrayTable.rowMask_;
                    assert (rowMask != null);
                    inTable1 = new RowSubsetStarTable(inTable, rowMask);
                }
                StarTable[] tables = new StarTable[]{inTable1, arrayTable};
                JoinFixAction[] fixacts = new JoinFixAction[]{inFixact, aFixact};
                return new JoinStarTable(tables, fixacts);
            }
        };
    }

    private static boolean isNameMatch(String pattern, String token) {
        boolean isCaseSensitive = false;
        if (token != null && token.trim().length() > 0) {
            for (String patItem : pattern.split("[\\s,]+", 0)) {
                if (isCaseSensitive ? token.equals(patItem) : token.equalsIgnoreCase(patItem)) {
                    return true;
                }
                Pattern regex = ColumnIdentifier.globToRegex(patItem, isCaseSensitive);
                if (regex == null || !regex.matcher(token).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private static ArrayDataTable createSequentialArrayTable(StarTable inTable, Function<Library, CompiledExpression> alocCompiler, IOFunction<String, StarTable> atableLoader, boolean keepAll, String paramsTxt) throws IOException, TaskException {
        SequentialJELRowReader inRdr0 = new SequentialJELRowReader(inTable);
        Library lib = JELUtils.getLibrary(inRdr0);
        CompiledExpression alocCompex = alocCompiler.apply(lib);
        int[] rowIndex = new int[]{-1};
        StarTable atable0 = ArrayJoin.readFirstArrayTable(inTable, alocCompiler, atableLoader, rowIndex);
        if (atable0 == null) {
            throw new TaskException("No array tables");
        }
        int irow0 = rowIndex[0];
        int nacol = atable0.getColumnCount();
        ArrayList acolList = new ArrayList(nacol);
        for (int ic = 0; ic < nacol; ++ic) {
            ColumnInfo cinfo = atable0.getColumnInfo(ic);
            ArrayColumn<?> acol = ArrayJoin.createArrayColumn(cinfo, ic);
            if (acol != null) {
                acolList.add(acol);
                continue;
            }
            logger_.warning("Array storage not supported for column " + cinfo + " - ignoring");
        }
        ArrayColumn[] acols = acolList.toArray(new ArrayColumn[0]);
        ArrayList<ValueInfo> pinfoList = new ArrayList<ValueInfo>();
        if (paramsTxt != null && paramsTxt.trim().length() > 0) {
            for (DescribedValue dval : atable0.getParameters()) {
                ValueInfo pinfo = dval.getInfo();
                if (!ArrayJoin.isNameMatch(paramsTxt, pinfo.getName())) continue;
                pinfoList.add(pinfo);
            }
        }
        ValueInfo[] pinfos = pinfoList.toArray(new ValueInfo[0]);
        if (acols.length == 0 && pinfos.length == 0) {
            throw new ExecutionException("No suitable columns/parameters in template array table");
        }
        return new ArrayDataTable(inTable, acols, pinfos, alocCompiler, atableLoader, keepAll, irow0);
    }

    private static StarTable cacheArrayTable(ArrayDataTable seqTable) throws IOException {
        RowStore rowStore = StoragePolicy.getDefaultPolicy().makeRowStore();
        rowStore.acceptMetadata((StarTable)seqTable);
        try (RowSequence rseq = seqTable.getRowSequence();){
            while (rseq.next()) {
                rowStore.acceptRow(rseq.getRow());
            }
        }
        rowStore.endRows();
        int nc = seqTable.getColumnCount();
        final ColumnInfo[] cinfos = new ColumnInfo[nc];
        for (int ic = 0; ic < nc; ++ic) {
            cinfos[ic] = seqTable.getEnhancedColumnInfo(ic);
        }
        return new WrapperStarTable(rowStore.getStarTable()){

            public ColumnInfo getColumnInfo(int ic) {
                return cinfos[ic];
            }
        };
    }

    private static StarTable readFirstArrayTable(StarTable inTable, Function<Library, CompiledExpression> alocCompiler, IOFunction<String, StarTable> atableLoader, int[] rowIndex) throws IOException, TaskException {
        try (SequentialJELRowReader inRdr = new SequentialJELRowReader(inTable);){
            Library lib = JELUtils.getLibrary(inRdr);
            CompiledExpression alocCompex = alocCompiler.apply(lib);
            while (inRdr.next()) {
                StarTable atable;
                String aloc = ArrayJoin.evaluateLocation(alocCompex, inRdr);
                if (aloc == null || (atable = (StarTable)atableLoader.apply((Object)aloc)) == null) continue;
                StarTable starTable = atable;
                return starTable;
            }
            StarTable starTable = null;
            return starTable;
        }
    }

    private static String evaluateLocation(CompiledExpression locCompex, JELRowReader rowReader) throws IOException {
        try {
            return (String)rowReader.evaluate(locCompex);
        }
        catch (Throwable e) {
            throw new IOException("Error evaluating table location", e);
        }
    }

    private static Object[] readArrayData(ArrayColumn<?>[] acols, ValueInfo[] pinfos, StarTable atable, long irow) throws IOException {
        int na = acols.length;
        int np = pinfos.length;
        int nrow = Tables.checkedLongToInt((long)atable.getRowCount());
        if (nrow < 0) {
            atable = Tables.randomTable((StarTable)atable);
            nrow = Tables.checkedLongToInt((long)atable.getRowCount());
        }
        assert (nrow >= 0);
        Object[] pdata = new Object[np];
        for (int ip = 0; ip < np; ++ip) {
            Object value;
            ValueInfo pinfo = pinfos[ip];
            DescribedValue dval = atable.getParameterByName(pinfo.getName());
            Object object = value = dval == null ? null : dval.getValue();
            if (!pinfo.getContentClass().isInstance(value)) continue;
            pdata[ip] = value;
        }
        Object[] adata = new Object[na];
        for (int ia = 0; ia < na; ++ia) {
            ArrayColumn<?> acol = acols[ia];
            ColumnInfo gotInfo = atable.getColumnInfo(acol.icol_);
            ColumnInfo templateInfo = acol.scalarInfo_;
            if (!gotInfo.getContentClass().equals(templateInfo.getContentClass()) || !gotInfo.getName().equals(templateInfo.getName())) {
                throw new IOException("Table data mismatch at input row " + irow + "; " + gotInfo + " does not match " + templateInfo);
            }
            adata[ia] = acol.createArray(nrow);
        }
        try (RowSequence rseq = atable.getRowSequence();){
            for (int ir = 0; ir < nrow; ++ir) {
                rseq.next();
                Object[] row = rseq.getRow();
                for (int ia = 0; ia < na; ++ia) {
                    ArrayColumn<?> acol = acols[ia];
                    int ic = acol.icol_;
                    acol.setValueUnchecked(row[ic], ir, adata[ia]);
                }
            }
        }
        if (np > 0) {
            Object[] data = new Object[na + np];
            System.arraycopy(adata, 0, data, 0, na);
            System.arraycopy(pdata, 0, data, na, np);
            return data;
        }
        return adata;
    }

    private static ArrayColumn<?> createArrayColumn(ColumnInfo sInfo, int icol) {
        Class clazz = sInfo.getContentClass();
        if (clazz.equals(Boolean.class)) {
            return new ArrayColumn<boolean[]>(boolean[].class, icol, sInfo){

                @Override
                boolean[] createArray(int n) {
                    return new boolean[n];
                }

                @Override
                void setValue(Object value, int ir, boolean[] array) {
                    if (value instanceof Boolean) {
                        array[ir] = (Boolean)value;
                    }
                }
            };
        }
        if (clazz.equals(Byte.class)) {
            return new ArrayColumn<byte[]>(byte[].class, icol, sInfo){

                @Override
                byte[] createArray(int n) {
                    return new byte[n];
                }

                @Override
                void setValue(Object value, int ir, byte[] array) {
                    array[ir] = ((Number)value).byteValue();
                }
            };
        }
        if (clazz.equals(Short.class)) {
            return new ArrayColumn<short[]>(short[].class, icol, sInfo){

                @Override
                short[] createArray(int n) {
                    return new short[n];
                }

                @Override
                void setValue(Object value, int ir, short[] array) {
                    if (value instanceof Number) {
                        array[ir] = ((Number)value).shortValue();
                    }
                }
            };
        }
        if (clazz.equals(Integer.class)) {
            return new ArrayColumn<int[]>(int[].class, icol, sInfo){

                @Override
                int[] createArray(int n) {
                    return new int[n];
                }

                @Override
                void setValue(Object value, int ir, int[] array) {
                    if (value instanceof Number) {
                        array[ir] = ((Number)value).intValue();
                    }
                }
            };
        }
        if (clazz.equals(Long.class)) {
            return new ArrayColumn<long[]>(long[].class, icol, sInfo){

                @Override
                long[] createArray(int n) {
                    return new long[n];
                }

                @Override
                void setValue(Object value, int ir, long[] array) {
                    if (value instanceof Number) {
                        array[ir] = ((Number)value).longValue();
                    }
                }
            };
        }
        if (clazz.equals(Float.class)) {
            return new ArrayColumn<float[]>(float[].class, icol, sInfo){

                @Override
                float[] createArray(int n) {
                    return new float[n];
                }

                @Override
                void setValue(Object value, int ir, float[] array) {
                    array[ir] = value instanceof Number ? ((Number)value).floatValue() : Float.NaN;
                }
            };
        }
        if (clazz.equals(Double.class)) {
            return new ArrayColumn<double[]>(double[].class, icol, sInfo){

                @Override
                double[] createArray(int n) {
                    return new double[n];
                }

                @Override
                void setValue(Object value, int ir, double[] array) {
                    array[ir] = value instanceof Number ? ((Number)value).doubleValue() : Double.NaN;
                }
            };
        }
        if (clazz.equals(String.class)) {
            return new ArrayColumn<String[]>(String[].class, icol, sInfo){

                @Override
                String[] createArray(int n) {
                    return new String[n];
                }

                @Override
                void setValue(Object value, int ir, String[] array) {
                    if (value instanceof String) {
                        array[ir] = (String)value;
                    }
                }
            };
        }
        return null;
    }

    private static class ExpressionInputTableParameter
    extends AbstractInputTableParameter<String> {
        ExpressionInputTableParameter(String name) {
            super(name, String.class);
        }

        public String stringToObject(Environment env, String sval) {
            return sval;
        }
    }

    private static class ArrayDataTable
    extends AbstractStarTable {
        final StarTable base_;
        final ArrayColumn<?>[] arrayCols_;
        final ValueInfo[] paramInfos_;
        final Function<Library, CompiledExpression> alocCompiler_;
        final IOFunction<String, StarTable> atableLoader_;
        final boolean keepAll_;
        final int irow0_;
        final int nacol_;
        final int npcol_;
        final int ncol_;
        final Object[] emptyRow_;
        final ColumnInfo[] colInfos_;
        static final int UNKNOWN_DIM = -1;
        static final int VARIABLE_DIM = -2;
        int[] arrayDims_;
        BitSet rowMask_;

        ArrayDataTable(StarTable base, ArrayColumn<?>[] arrayCols, ValueInfo[] paramInfos, Function<Library, CompiledExpression> alocCompiler, IOFunction<String, StarTable> atableLoader, boolean keepAll, int irow0) {
            this.base_ = base;
            this.arrayCols_ = arrayCols;
            this.paramInfos_ = paramInfos;
            this.alocCompiler_ = alocCompiler;
            this.atableLoader_ = atableLoader;
            this.keepAll_ = keepAll;
            this.irow0_ = irow0;
            this.nacol_ = arrayCols.length;
            this.npcol_ = paramInfos.length;
            this.ncol_ = this.nacol_ + this.npcol_;
            this.colInfos_ = new ColumnInfo[this.ncol_];
            for (int ia = 0; ia < this.nacol_; ++ia) {
                this.colInfos_[ia] = this.arrayCols_[ia].arrayInfo_;
            }
            for (int ip = 0; ip < this.npcol_; ++ip) {
                this.colInfos_[this.nacol_ + ip] = new ColumnInfo(paramInfos[ip]);
            }
            this.emptyRow_ = new Object[this.ncol_];
        }

        public boolean isEmptyRow(Object[] row) {
            return row == this.emptyRow_;
        }

        public boolean isRandom() {
            return false;
        }

        public int getColumnCount() {
            return this.ncol_;
        }

        public ColumnInfo getColumnInfo(int icol) {
            return this.colInfos_[icol];
        }

        public long getRowCount() {
            return this.keepAll_ ? this.base_.getRowCount() : -1L;
        }

        public RowSequence getRowSequence() throws IOException {
            final SequentialJELRowReader inRdr = new SequentialJELRowReader(this.base_);
            Library lib = JELUtils.getLibrary(inRdr);
            final CompiledExpression alocCompex = this.alocCompiler_.apply(lib);
            final int[] adims = new int[this.nacol_];
            Arrays.fill(adims, -1);
            final BitSet rowMask = new BitSet();
            return new RowSequence(){
                Object[] adata_;
                int irow_ = -1;
                boolean finished_;
                boolean tryAll_ = true;

                public boolean next() throws IOException {
                    if (this.irow_ >= 0) {
                        this.tryAll_ = this.tryAll_ && this.adata_ != null;
                    }
                    this.adata_ = null;
                    if (keepAll_) {
                        if (inRdr.next()) {
                            ++this.irow_;
                            return true;
                        }
                        this.finished_ = true;
                        return false;
                    }
                    while (inRdr.next()) {
                        ++this.irow_;
                        this.adata_ = null;
                        if (this.isEmptyRow(this.getArrayData())) continue;
                        return true;
                    }
                    this.finished_ = true;
                    return false;
                }

                public Object[] getRow() throws IOException {
                    return this.getArrayData();
                }

                public Object getCell(int icol) throws IOException {
                    return this.getArrayData()[icol];
                }

                public void close() throws IOException {
                    this.adata_ = null;
                    inRdr.close();
                    if (this.finished_ && this.tryAll_) {
                        arrayDims_ = (int[])adims.clone();
                        rowMask_ = rowMask;
                    }
                }

                Object[] getArrayData() throws IOException {
                    if (this.adata_ == null) {
                        Object[] adata;
                        String aloc = ArrayJoin.evaluateLocation(alocCompex, inRdr);
                        if (aloc != null && this.irow_ >= irow0_ - 1) {
                            try (StarTable aTable = (StarTable)atableLoader_.apply((Object)aloc);){
                                adata = aTable == null ? emptyRow_ : ArrayJoin.readArrayData(arrayCols_, paramInfos_, aTable, this.irow_);
                            }
                            if (adata != emptyRow_) {
                                for (int ia = 0; ia < nacol_; ++ia) {
                                    int n;
                                    Object array = adata[ia];
                                    if (array == null || (n = Array.getLength(array)) <= 0) continue;
                                    if (adims[ia] == -1) {
                                        adims[ia] = n;
                                    } else if (adims[ia] > 0 && n != adims[ia]) {
                                        adims[ia] = -2;
                                    }
                                    assert (adims[ia] == -2 || adims[ia] == n);
                                }
                            }
                        } else {
                            adata = emptyRow_;
                        }
                        this.adata_ = adata;
                        rowMask.set(this.irow_, this.adata_ != emptyRow_);
                    }
                    return this.adata_;
                }
            };
        }

        ColumnInfo getEnhancedColumnInfo(int icol) {
            int iacol = icol;
            if (iacol < this.nacol_) {
                int adim;
                ColumnInfo info = new ColumnInfo((ValueInfo)this.arrayCols_[iacol].arrayInfo_);
                int n = adim = this.arrayDims_ == null ? -1 : this.arrayDims_[iacol];
                if (adim > 0) {
                    info.setShape(new int[]{adim});
                }
                return info;
            }
            return this.colInfos_[icol];
        }

        public String getName() {
            return this.base_.getName();
        }

        public List<DescribedValue> getParameters() {
            return this.base_.getParameters();
        }

        public DescribedValue getParameterByName(String parname) {
            return this.base_.getParameterByName(parname);
        }

        public List<ValueInfo> getColumnAuxDataInfos() {
            return this.base_.getColumnAuxDataInfos();
        }

        public RowSplittable getRowSplittable() throws IOException {
            return Tables.getDefaultRowSplittable((StarTable)this);
        }
    }

    private static abstract class ArrayColumn<A> {
        final Class<A> aClazz_;
        final int icol_;
        final ColumnInfo scalarInfo_;
        final ColumnInfo arrayInfo_;

        ArrayColumn(Class<A> aClazz, int icol, ColumnInfo scalarInfo) {
            this.aClazz_ = aClazz;
            this.icol_ = icol;
            this.scalarInfo_ = scalarInfo;
            this.arrayInfo_ = new ColumnInfo((ValueInfo)scalarInfo);
            this.arrayInfo_.setContentClass(aClazz);
        }

        abstract A createArray(int var1);

        abstract void setValue(Object var1, int var2, A var3);

        final void setValueUnchecked(Object value, int ir, Object array) {
            this.setValue(value, ir, this.aClazz_.cast(array));
        }
    }
}

