/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.DoubleParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.URLParameter;
import uk.ac.starlink.ttools.cone.BlockUploader;
import uk.ac.starlink.ttools.cone.CdsUploadMatcher;
import uk.ac.starlink.ttools.cone.Coverage;
import uk.ac.starlink.ttools.cone.CoverageQuerySequenceFactory;
import uk.ac.starlink.ttools.cone.HealpixSortedQuerySequenceFactory;
import uk.ac.starlink.ttools.cone.JELQuerySequenceFactory;
import uk.ac.starlink.ttools.cone.QuerySequenceFactory;
import uk.ac.starlink.ttools.cone.ServiceFindMode;
import uk.ac.starlink.ttools.cone.UrlMocCoverage;
import uk.ac.starlink.ttools.task.ChoiceMode;
import uk.ac.starlink.ttools.task.ContentCodingParameter;
import uk.ac.starlink.ttools.task.JoinFixActionParameter;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.ttools.task.SingleMapperTask;
import uk.ac.starlink.ttools.task.SkyCoordParameter;
import uk.ac.starlink.ttools.task.TableProducer;
import uk.ac.starlink.ttools.task.UserFindMode;
import uk.ac.starlink.util.Bi;
import uk.ac.starlink.util.ContentCoding;

public class CdsUploadSkyMatch
extends SingleMapperTask {
    private final StringParameter raParam_;
    private final StringParameter decParam_;
    private final DoubleParameter srParam_;
    private final StringParameter cdstableParam_;
    private final ChoiceParameter<UserFindMode> findParam_;
    private final IntegerParameter chunkParam_;
    private final IntegerParameter maxrecParam_;
    private final ContentCodingParameter codingParam_;
    private final URLParameter urlParam_;
    private final BooleanParameter usemocParam_;
    private final BooleanParameter presortParam_;
    private final JoinFixActionParameter fixcolsParam_;
    private final StringParameter insuffixParam_;
    private final StringParameter cdssuffixParam_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public CdsUploadSkyMatch() {
        super("Crossmatches table on sky position against VizieR/SIMBAD table", new ChoiceMode(), true, true);
        ArrayList<Object> paramList = new ArrayList<Object>();
        String system = "ICRS";
        String inDescrip = "the input table";
        this.raParam_ = SkyCoordParameter.createRaParameter("ra", system, inDescrip);
        paramList.add(this.raParam_);
        this.decParam_ = SkyCoordParameter.createDecParameter("dec", system, inDescrip);
        paramList.add(this.decParam_);
        this.srParam_ = new DoubleParameter("radius");
        this.srParam_.setPrompt("Search radius value in arcsec (0-180)");
        this.srParam_.setUsage("<value/arcsec>");
        this.srParam_.setDescription(new String[]{"<p>Maximum distance from the local table (ra,dec) position", "at which counterparts from the remote table will be identified.", "This is a fixed value given in arcseconds,", "and must be in the range [0,180]", "(this limit is currently enforced by the CDS Xmatch service).", "</p>"});
        this.srParam_.setMinimum(0.0, true);
        this.srParam_.setMaximum(180.0, true);
        paramList.add(this.srParam_);
        this.cdstableParam_ = new StringParameter("cdstable");
        this.cdstableParam_.setPrompt("Identifier for remote table");
        this.cdstableParam_.setDescription(new String[]{"<p>Identifier of the table from the CDS crossmatch service", "that is to be matched against the local table.", "This identifier may be the standard VizieR identifier", "(e.g. \"<code>II/246/out</code>\"", "for the 2MASS Point Source Catalogue)", "or \"<code>simbad</code>\" to indicate SIMBAD data.", "</p>", "<p>See for instance the TAPVizieR table searching facility at", "<code>http://tapvizier.u-strasbg.fr/adql/</code>", "to find VizieR catalogue identifiers.", "</p>"});
        paramList.add(this.cdstableParam_);
        this.chunkParam_ = new IntegerParameter("blocksize");
        this.chunkParam_.setPrompt("Maximum number of rows per request");
        this.chunkParam_.setDescription(new String[]{"<p>The CDS Xmatch service operates limits on", "the maximum number of rows that can be uploaded and", "the maximum number of rows that is returned as a result", "from a single query.", "In the case of large input tables,", "they are broken down into smaller blocks,", "and one request is sent to the external service for each block.", "This parameter controls the number of rows in each block.", "For an input table with fewer rows than this value,", "the whole thing is done as a single request.", "</p>", "<p>At time of writing, the maximum upload size is 100Mb", "(about 3Mrow; this does not depend on the width of your table),", "and the maximum return size is 2Mrow.", "</p>", "<p>Large blocksizes tend to be good (up to a point) for", "reducing the total amount of time a large xmatch operation takes,", "but they can make it harder to see the job progressing.", "There is also the danger (for ALL-type find modes)", "of exceeding the return size limit, which will result in", "truncation of the returned result.", "</p>"});
        this.chunkParam_.setMinimum(1);
        this.chunkParam_.setIntDefault(50000);
        this.findParam_ = new ChoiceParameter("find", (Object[])UserFindMode.getInstances());
        this.findParam_.setPrompt("Which pair matches to include");
        StringBuffer optBuf = new StringBuffer();
        for (UserFindMode findMode : this.findParam_.getOptionValueList()) {
            optBuf.append("<li>").append("<code>").append(findMode.getName()).append("</code>: ").append(findMode.getSummary()).append("</li>").append('\n');
        }
        this.findParam_.setDescription(new String[]{"<p>Determines which pair matches are included in the result.", "<ul>", optBuf.toString(), "</ul>", "Note only the <code>" + UserFindMode.ALL + "</code> mode", "is symmetric between the two tables.", "</p>", "<p><strong>Note also that there is a bug</strong> in", "<code>" + UserFindMode.BEST_REMOTE + "</code>", "matching.", "If the match is done in multiple blocks,", "it's possible for a remote table row to appear matched against", "one local table row per uploaded block,", "rather than just once for the whole result.", "If you're worried about that, set", "<code>" + this.chunkParam_.getName(), "&gt;=</code>", "<em>rowCount</em>.", "This may be fixed in a future release.", "</p>"});
        this.findParam_.setDefaultOption((Object)UserFindMode.ALL);
        paramList.add(this.findParam_);
        paramList.add(this.chunkParam_);
        this.maxrecParam_ = new IntegerParameter("maxrec");
        this.maxrecParam_.setPrompt("Maximum number of output rows");
        this.maxrecParam_.setDescription(new String[]{"<p>Limit to the number of rows resulting from this operation.", "If the value is negative (the default) no limit is imposed.", "Note however that there can be truncation of the result", "if the number of records returned from a single chunk", "exceeds the service hard limit", "(2,000,000 at time of writing).", "</p>"});
        this.maxrecParam_.setIntDefault(-1);
        paramList.add(this.maxrecParam_);
        this.codingParam_ = new ContentCodingParameter();
        paramList.add((Object)this.codingParam_);
        this.urlParam_ = new URLParameter("serviceurl");
        this.urlParam_.setPrompt("URL for CDS Xmatch service");
        this.urlParam_.setDescription(new String[]{"<p>The URL at which the CDS Xmatch service can be found.", "Normally this should not be altered from the default,", "but if other implementations of the same service are known,", "this parameter can be used to access them.", "</p>"});
        this.urlParam_.setStringDefault("http://cdsxmatch.u-strasbg.fr/xmatch/api/v1/sync");
        paramList.add(this.urlParam_);
        this.usemocParam_ = new BooleanParameter("usemoc");
        this.usemocParam_.setPrompt("Use VizieR MOC footprint?");
        this.usemocParam_.setDescription(new String[]{"<p>If true, first acquire a MOC coverage map from CDS,", "and use that to pre-filter rows before uploading them", "for matching.", "This should improve efficiency, but have no effect on the result.", "</p>"});
        this.usemocParam_.setBooleanDefault(true);
        paramList.add(this.usemocParam_);
        this.presortParam_ = new BooleanParameter("presort");
        this.presortParam_.setPrompt("Pre-sort rows before uploading?");
        this.presortParam_.setDescription(new String[]{"<p>If true, the rows are sorted by HEALPix index before", "they are uploaded to the CDS X-Match service.", "If the match is done in multiple blocks,", "this may improve efficiency,", "since when matching against a large remote catalogue", "the X-Match service likes to process requests", "in which sources are grouped into a small region", "rather than scattered all over the sky.", "</p>", "<p>Note this will have a couple of other side effects that may", "be undesirable:", "it will read all the input rows into the task at once,", "which may make it harder to assess progress,", "and it will affect the order of the rows in the output table.", "</p>", "<p>It is <em>probably</em> only worth setting true for rather", "large (multi-million-row?) multi-block matches,", "where both local and remote catalogues are spread over", "a significant fraction of the sky.", "But feel free to experiment.", "</p>"});
        this.presortParam_.setBooleanDefault(false);
        paramList.add(this.presortParam_);
        this.fixcolsParam_ = new JoinFixActionParameter("fixcols");
        this.insuffixParam_ = this.fixcolsParam_.createSuffixParameter("suffixin", "the input table", "_in");
        this.cdssuffixParam_ = this.fixcolsParam_.createSuffixParameter("suffixremote", "the CDS result table", "_cds");
        paramList.add((Object)this.fixcolsParam_);
        paramList.add(this.insuffixParam_);
        paramList.add(this.cdssuffixParam_);
        this.getParameterList().addAll(paramList);
    }

    public Parameter<String> getRaParameter() {
        return this.raParam_;
    }

    public Parameter<String> getDecParameter() {
        return this.decParam_;
    }

    public Parameter<Double> getRadiusArcsecParameter() {
        return this.srParam_;
    }

    public Parameter<String> getCdsTableParameter() {
        return this.cdstableParam_;
    }

    public Parameter<Boolean> getUseMocParameter() {
        return this.usemocParam_;
    }

    public Parameter<UserFindMode> getFindParameter() {
        return this.findParam_;
    }

    public Parameter<Integer> getBlocksizeParameter() {
        return this.chunkParam_;
    }

    public Parameter<JoinFixActionParameter.Fixer> getFixColsParameter() {
        return this.fixcolsParam_;
    }

    public Parameter<String> getCdsSuffixParameter() {
        return this.cdssuffixParam_;
    }

    @Override
    public TableProducer createProducer(Environment env) throws TaskException {
        String raString = this.raParam_.stringValue(env);
        String decString = this.decParam_.stringValue(env);
        double sr = this.srParam_.doubleValue(env);
        String cdsName = this.cdstableParam_.stringValue(env);
        String cdsId = CdsUploadMatcher.toCdsId(cdsName);
        if (cdsId == null) {
            throw new ParameterValueException((Parameter)this.cdstableParam_, "Bad value " + cdsName);
        }
        double srDeg = sr / 3600.0;
        final JELQuerySequenceFactory qsFact0 = new JELQuerySequenceFactory(raString, decString, Double.toString(srDeg));
        UserFindMode userMode = (UserFindMode)this.findParam_.objectValue(env);
        ServiceFindMode serviceMode = userMode.getServiceMode();
        boolean oneToOne = userMode.isOneToOne();
        int blocksize = this.chunkParam_.intValue(env);
        long maxrec = this.maxrecParam_.intValue(env);
        ContentCoding coding = this.codingParam_.codingValue(env);
        URL url = (URL)this.urlParam_.objectValue(env);
        final UrlMocCoverage coverage = this.usemocParam_.booleanValue(env) ? UrlMocCoverage.getVizierMoc(cdsName, -1) : null;
        final boolean presort = this.presortParam_.booleanValue(env);
        CdsUploadMatcher umatcher = new CdsUploadMatcher(url, cdsId, sr, serviceMode, coding);
        String tableName = "xmatch(" + CdsUploadSkyMatch.cdsIdToTableName(cdsId) + ")";
        JoinFixAction inFixAct = this.fixcolsParam_.getJoinFixAction(env, this.insuffixParam_);
        JoinFixAction cdsFixAct = this.fixcolsParam_.getJoinFixAction(env, this.cdssuffixParam_);
        final TableProducer inProd = this.createInputProducer(env);
        final StoragePolicy storage = LineTableEnvironment.getStoragePolicy(env);
        boolean uploadEmpty = false;
        final BlockUploader blocker = new BlockUploader(umatcher, blocksize, maxrec, tableName, inFixAct, cdsFixAct, serviceMode, oneToOne, uploadEmpty);
        return new TableProducer(){

            @Override
            public StarTable getTable() throws IOException, TaskException {
                Coverage cov;
                StarTable inTable = Tables.randomTable((StarTable)inProd.getTable());
                if (coverage != null) {
                    try {
                        coverage.initCoverage();
                        cov = coverage;
                    }
                    catch (IOException e) {
                        logger_.log(Level.WARNING, "Failed to read coverage", e);
                        cov = null;
                    }
                } else {
                    cov = null;
                }
                QuerySequenceFactory qsFact1 = qsFact0;
                if (cov != null) {
                    qsFact1 = new CoverageQuerySequenceFactory(qsFact1, cov);
                }
                if (presort) {
                    qsFact1 = new HealpixSortedQuerySequenceFactory(qsFact1);
                }
                Bi<StarTable, BlockUploader.BlockStats> result = blocker.runMatch(inTable, qsFact1, storage);
                StarTable outTable = (StarTable)result.getItem1();
                BlockUploader.BlockStats stats = (BlockUploader.BlockStats)result.getItem2();
                int nBlock = stats.getBlockCount();
                int nTrunc = stats.getTruncatedBlockCount();
                if (nTrunc > 0) {
                    String msg = "Truncations in " + nTrunc + "/" + nBlock + " blocks; Reduce " + CdsUploadSkyMatch.this.chunkParam_.getName() + "?";
                    logger_.warning(msg);
                }
                return outTable;
            }
        };
    }

    private static String cdsIdToTableName(String cdsId) {
        return cdsId.replaceFirst("^vizier:", "").replaceAll("/", "_");
    }
}

