/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.LineEnvironment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.InputTableParameter;
import uk.ac.starlink.ttools.task.TableProducer;

public abstract class ConsumerTask
implements Task {
    private final FilterParameter outFilterParam_;
    private final ProcessingMode outMode_;
    private final String purpose_;
    private List<Parameter<?>> paramList_;

    public ConsumerTask(String purpose, ProcessingMode outMode, boolean useOutFilter) {
        this.purpose_ = purpose;
        this.outMode_ = outMode;
        this.paramList_ = new ArrayList();
        if (useOutFilter) {
            this.outFilterParam_ = new FilterParameter("ocmd");
            this.outFilterParam_.setTableDescription("the output table", null, Boolean.FALSE);
            this.paramList_.add(this.outFilterParam_);
        } else {
            this.outFilterParam_ = null;
        }
        this.paramList_.addAll(Arrays.asList(outMode.getAssociatedParameters()));
    }

    public String getPurpose() {
        return this.purpose_;
    }

    public Parameter<?>[] getParameters() {
        return this.paramList_.toArray(new Parameter[0]);
    }

    protected List<Parameter<?>> getParameterList() {
        return this.paramList_;
    }

    public abstract TableProducer createProducer(Environment var1) throws TaskException;

    public Executable createExecutable(Environment env) throws TaskException {
        final TableProducer producer = this.createProducer(env);
        final ProcessingStep[] outSteps = this.outFilterParam_ != null ? this.outFilterParam_.stepsValue(env) : new ProcessingStep[]{};
        final TableConsumer baseConsumer = this.outMode_.createConsumer(env);
        final TableConsumer consumer = new TableConsumer(){

            @Override
            public void consume(StarTable table) throws IOException {
                for (int i = 0; i < outSteps.length; ++i) {
                    table = outSteps[i].wrap(table);
                }
                baseConsumer.consume(table);
            }
        };
        this.checkUnused(env);
        return new Executable(){

            public void execute() throws IOException, TaskException {
                consumer.consume(producer.getTable());
            }
        };
    }

    public ProcessingMode getOutputMode() {
        return this.outMode_;
    }

    private void checkUnused(Environment env) throws TaskException {
        if (env instanceof LineEnvironment) {
            String[] unused = ((LineEnvironment)env).getUnused();
            for (int i = 0; i < unused.length; ++i) {
                String word = unused[i];
                if (word.startsWith("out=") || word.startsWith("ofmt=")) {
                    throw new UsageException(word + ": out and ofmt parameters can only be used when omode=out");
                }
                if (!word.startsWith("script=")) continue;
                throw new UsageException(word + ": script parameter withdrawn (use cmd=@file)");
            }
        }
    }

    public static TableProducer createProducer(Environment env, FilterParameter filterParam, InputTableParameter inParam) throws TaskException {
        final StarTable inTable = inParam.tableValue(env);
        if (inTable == null) {
            return null;
        }
        final ProcessingStep[] steps = filterParam == null ? new ProcessingStep[]{} : filterParam.stepsValue(env);
        URL turl = inTable.getURL();
        final String identity = Arrays.toString(new String[]{turl == null ? inParam.stringValue(env) : turl.toString(), filterParam.stringValue(env)});
        return new TableProducer(){

            @Override
            public StarTable getTable() throws IOException {
                StarTable table = inTable;
                for (int i = 0; i < steps.length; ++i) {
                    table = steps[i].wrap(table);
                }
                return new IdentifiedStarTable(table, identity);
            }
        };
    }

    public static String getIdentity(StarTable table) {
        return table instanceof IdentifiedStarTable ? ((IdentifiedStarTable)table).identity_ : null;
    }

    private static class IdentifiedStarTable
    extends WrapperStarTable {
        private final String identity_;

        IdentifiedStarTable(StarTable baseTable, String identity) {
            super(baseTable);
            this.identity_ = identity;
        }

        public int hashCode() {
            return this.identity_.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof IdentifiedStarTable && this.identity_.equals(((IdentifiedStarTable)((Object)o)).identity_);
        }
    }
}

