/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.AbstractInputTableParameter;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.ttools.task.TableEnvironment;

public class InputFormatParameter
extends StringParameter
implements ExtraParameter {
    public InputFormatParameter(String name) {
        super(name);
        this.setNullPermitted(false);
        this.setStringDefault("(auto)");
        this.setTableDescription("the input table", null);
    }

    public final void setTableDescription(String inDescrip, AbstractInputTableParameter<?> tableParam) {
        this.setPrompt("Format name for " + inDescrip);
        StringBuffer dbuf = new StringBuffer();
        dbuf.append(inDescrip);
        if (tableParam != null) {
            dbuf.append(" as specified by parameter <code>").append(tableParam.getName()).append("</code>");
        }
        this.setDescription(new String[]{"<p>Specifies the format of " + dbuf.toString() + ".", "The known formats are listed in <ref id='inFormats'/>.", "This flag can be used if you know what format your", "table is in.", "If it has the special value", "<code>(auto)</code> (the default),", "then an attempt will be", "made to detect the format of the table automatically.", "This cannot always be done correctly however, in which case", "the program will exit with an error explaining which", "formats were attempted.", "This parameter is ignored for scheme-specified tables.", "</p>"});
    }

    public String getUsage() {
        return "<in-format>";
    }

    @Override
    public String getExtraUsage(TableEnvironment env) {
        StarTableFactory tfact = env.getTableFactory();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("   Auto-detected in-formats:\n");
        for (TableBuilder handler : tfact.getDefaultBuilders()) {
            sbuf.append("      ").append(handler.getFormatName().toLowerCase()).append('\n');
        }
        sbuf.append('\n');
        sbuf.append("   Known in-formats:\n");
        for (String fmt : tfact.getKnownFormats()) {
            sbuf.append("      ").append(fmt.toLowerCase()).append('\n');
        }
        return sbuf.toString();
    }

    public String stringToObject(Environment env, String stringval) throws TaskException {
        if (!"(auto)".equals(stringval)) {
            try {
                this.getTableFactory(env).getTableBuilder(stringval);
            }
            catch (TableFormatException e) {
                throw new ParameterValueException((Parameter)this, "Unknown format " + stringval, (Throwable)e);
            }
        }
        return super.stringToObject(env, stringval);
    }

    private StarTableFactory getTableFactory(Environment env) {
        return LineTableEnvironment.getTableFactory(env);
    }
}

