/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public abstract class InputTableSpec {
    private final ProcessingStep[] steps_;
    private final String loc_;

    public InputTableSpec(String loc, ProcessingStep[] steps) {
        this.loc_ = loc;
        this.steps_ = steps == null ? new ProcessingStep[]{} : steps;
    }

    public abstract StarTable getInputTable() throws TaskException;

    public ProcessingStep[] getSteps() {
        return this.steps_;
    }

    public String getLocation() {
        return this.loc_;
    }

    public StarTable getWrappedTable() throws IOException, TaskException {
        ProcessingStep[] steps = this.getSteps();
        StarTable table = this.getInputTable();
        for (int i = 0; i < steps.length; ++i) {
            table = steps[i].wrap(table);
        }
        return table;
    }

    public static InputTableSpec createSpec(String loc, ProcessingStep[] steps, final StarTable table) {
        return new InputTableSpec(loc, steps){

            @Override
            public StarTable getInputTable() {
                return table;
            }
        };
    }
}

