/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.util.logging.Logger;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.JoinStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.JoinFixActionParameter;
import uk.ac.starlink.ttools.task.TableMapper;
import uk.ac.starlink.ttools.task.TableMapping;

public class JoinMapper
implements TableMapper {
    private final JoinFixActionParameter fixcolParam_ = new JoinFixActionParameter("fixcols");
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    @Override
    public Parameter<?>[] getParameters() {
        return new Parameter[]{this.fixcolParam_, this.fixcolParam_.createSuffixParameter("N")};
    }

    @Override
    public TableMapping createMapping(Environment env, int nin) throws TaskException {
        return new JoinMapping(this.fixcolParam_.getJoinFixActions(env, nin));
    }

    private static class JoinMapping
    implements TableMapping {
        private final JoinFixAction[] fixActs_;

        JoinMapping(JoinFixAction[] fixActs) {
            this.fixActs_ = fixActs;
        }

        @Override
        public StarTable mapTables(InputTableSpec[] inSpecs) throws IOException, TaskException {
            int nin = inSpecs.length;
            StarTable[] inTables = new StarTable[nin];
            long nrow = -1L;
            boolean mismatch = false;
            for (int i = 0; i < nin; ++i) {
                inTables[i] = inSpecs[i].getWrappedTable();
                long nr = inTables[i].getRowCount();
                if (nr < 0L) continue;
                if (nrow < 0L) {
                    nrow = nr;
                }
                if (nr == nrow) continue;
                mismatch = true;
            }
            if (mismatch) {
                logger_.warning("Tables do not all have the same length; will truncate to shortest");
            }
            return new JoinStarTable(inTables, this.fixActs_);
        }
    }
}

