/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.ConsumerTask;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.TableMapper;
import uk.ac.starlink.ttools.task.TableMapping;
import uk.ac.starlink.ttools.task.TableProducer;
import uk.ac.starlink.ttools.task.TablesInput;

public abstract class MapperTask
extends ConsumerTask {
    private final TableMapper mapper_;
    private final TablesInput tablesInput_;

    public MapperTask(String purpose, ProcessingMode outMode, boolean useOutFilter, TableMapper mapper, TablesInput tablesInput) {
        super(purpose, outMode, useOutFilter);
        this.mapper_ = mapper;
        this.tablesInput_ = tablesInput;
        List<Parameter<?>> paramList = this.getParameterList();
        paramList.addAll(0, Arrays.asList(tablesInput.getParameters()));
        paramList.addAll(Arrays.asList(mapper.getParameters()));
    }

    @Override
    public TableProducer createProducer(Environment env) throws TaskException {
        final InputTableSpec[] inSpecs = this.tablesInput_.getInputSpecs(env);
        final TableMapping mapping = this.mapper_.createMapping(env, inSpecs.length);
        return new TableProducer(){

            @Override
            public StarTable getTable() throws IOException, TaskException {
                return mapping.mapTables(inSpecs);
            }
        };
    }

    public TableMapper getMapper() {
        return this.mapper_;
    }

    public TablesInput getTablesInput() {
        return this.tablesInput_;
    }
}

