/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.table.MultiStarTableWriter;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.OutputFormatParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;

public class MultiOutputFormatParameter
extends OutputFormatParameter
implements ExtraParameter {
    public MultiOutputFormatParameter(String name) {
        super(name);
        this.setPrompt("Format name for output tables");
        this.setDescription(new String[]{super.getDescription().replaceAll("table\\b", "tables"), "<p>Not all output formats are capable of writing multiple tables;", "if you choose one that is not, an error will result.", "</p>"});
    }

    @Override
    public String getExtraUsage(TableEnvironment env) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("   Known multi-table output formats:\n").append("      ").append("(auto)").append('\n');
        for (StarTableWriter writer : env.getTableOutput().getHandlers()) {
            if (!(writer instanceof MultiStarTableWriter)) continue;
            sbuf.append("      ").append(writer.getFormatName().toLowerCase()).append('\n');
        }
        return sbuf.toString();
    }
}

