/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import cds.healpix.FlatHashIterator;
import cds.healpix.HashComputer;
import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixNestedBMOC;
import cds.healpix.VerticesAndPathComputer;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.HealpixTableInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.func.CoordsRadians;
import uk.ac.starlink.util.LongList;

public class PixSampler {
    private final StarTable pixTable_;
    private final int order_;
    private final HashComputer hasher_;
    private final HealpixNested hnested_;
    private final boolean nested_;
    private final int ncol_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.calc");
    public static final StatMode POINT_MODE = new PointStatMode("Point");
    public static final StatMode MEAN_MODE = new MeanStatMode("Mean");

    public PixSampler(StarTable pixTable, boolean nested, int order) throws IOException {
        long requireNrow;
        if (!pixTable.isRandom()) {
            throw new IOException("Pixel data not random access");
        }
        this.order_ = order;
        this.hnested_ = Healpix.getNested((int)this.order_);
        this.hasher_ = Healpix.getNestedFast((int)this.order_);
        long hasNrow = pixTable.getRowCount();
        if (hasNrow != (requireNrow = 12L << 2 * this.order_)) {
            throw new IOException("Wrong number of rows for order " + order + " (" + hasNrow + "!=" + requireNrow + ")");
        }
        this.pixTable_ = pixTable;
        this.nested_ = nested;
        this.ncol_ = pixTable.getColumnCount();
    }

    public Object sampleValue(int icol, double alphaDeg, double deltaDeg, double radiusDeg, StatMode statMode) throws IOException {
        if (alphaDeg >= -360.0 && alphaDeg <= 360.0 && deltaDeg >= -90.0 && deltaDeg <= 90.0) {
            Object[] samples;
            if (statMode.isPoint()) {
                long irow = this.getPixIndex(alphaDeg, deltaDeg);
                samples = new Object[]{this.pixTable_.getCell(irow, icol)};
            } else {
                long[] irows = this.getPixIndices(alphaDeg, deltaDeg, radiusDeg);
                int nr = irows.length;
                samples = new Object[nr];
                for (int ir = 0; ir < nr; ++ir) {
                    samples[ir] = this.pixTable_.getCell((long)ir, icol);
                }
            }
            return statMode.getResult(samples);
        }
        return null;
    }

    public Object[] sampleValues(double alphaDeg, double deltaDeg, double radiusDeg, StatMode statMode) throws IOException {
        if (alphaDeg >= -360.0 && alphaDeg <= 360.0 && deltaDeg >= -90.0 && deltaDeg <= 90.0) {
            Object[][] samples;
            if (statMode.isPoint()) {
                long irow = this.getPixIndex(alphaDeg, deltaDeg);
                samples = new Object[this.ncol_][1];
                Object[] row = this.pixTable_.getRow(irow);
                for (int icol = 0; icol < this.ncol_; ++icol) {
                    samples[icol][0] = row[icol];
                }
            } else {
                long[] irows = this.getPixIndices(alphaDeg, deltaDeg, radiusDeg);
                int nr = irows.length;
                samples = new Object[this.ncol_][nr];
                for (int ir = 0; ir < nr; ++ir) {
                    Object[] row = this.pixTable_.getRow(irows[ir]);
                    for (int icol = 0; icol < this.ncol_; ++icol) {
                        samples[icol][ir] = row[icol];
                    }
                }
            }
            Object[] outRow = new Object[this.ncol_];
            for (int ic = 0; ic < this.ncol_; ++ic) {
                outRow[ic] = statMode.getResult(samples[ic]);
            }
            return outRow;
        }
        return new Object[this.ncol_];
    }

    public ColumnInfo[] getValueInfos(StatMode statMode) {
        int ncol = this.pixTable_.getColumnCount();
        ColumnInfo[] infos = new ColumnInfo[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            infos[icol] = statMode.getResultInfo(this.pixTable_.getColumnInfo(icol));
        }
        return infos;
    }

    private long getPixIndex(double alphaDeg, double deltaDeg) {
        long inest = this.hasher_.hash(Math.toRadians(alphaDeg), Math.toRadians(deltaDeg));
        return this.nested_ ? inest : this.hnested_.toRing(inest);
    }

    private long[] getPixIndices(double alphaDeg, double deltaDeg, double radiusDeg) {
        double alphaRad = Math.toRadians(alphaDeg);
        double deltaRad = Math.toRadians(deltaDeg);
        double radiusRad = Math.toRadians(radiusDeg);
        HealpixNestedBMOC bmoc = this.hnested_.newConeComputerApprox(Math.toRadians(radiusDeg)).overlappingCenters(Math.toRadians(alphaDeg), Math.toRadians(deltaDeg));
        LongList pixList = new LongList((int)bmoc.computeDeepSize());
        VerticesAndPathComputer vpc = this.hnested_.newVerticesAndPathComputer();
        double[] cpos = new double[2];
        FlatHashIterator fhit = bmoc.flatHashIterator();
        while (fhit.hasNext()) {
            long lpix = fhit.next();
            vpc.center(lpix, cpos);
            if (!(CoordsRadians.skyDistanceRadians(alphaRad, deltaRad, cpos[0], cpos[1]) <= radiusRad)) continue;
            pixList.add(lpix);
        }
        long[] pixes = pixList.toLongArray();
        if (!this.nested_) {
            for (int ip = 0; ip < pixes.length; ++ip) {
                pixes[ip] = this.hnested_.toRing(pixes[ip]);
            }
        }
        return pixes;
    }

    public static PixSampler createPixSampler(StarTable pixTable) throws IOException {
        boolean nested;
        if (!pixTable.isRandom()) {
            throw new IOException("Pixel data not random access");
        }
        if (!HealpixTableInfo.isHealpix((List)pixTable.getParameters())) {
            logger_.warning("Table doesn't look like a HEALPix map");
        }
        int order = PixSampler.inferOrder(pixTable);
        Boolean isNested = PixSampler.inferNested(pixTable);
        if (isNested == null) {
            logger_.warning("Cannot determine HEALPix ordering scheme - assuming nested");
            nested = true;
        } else {
            nested = isNested;
        }
        return new PixSampler(pixTable, nested, order);
    }

    public static Boolean inferNested(StarTable pixTable) {
        Object orderObj = Tables.getValue((Collection)pixTable.getParameters(), (ValueInfo)HealpixTableInfo.HPX_ISNEST_INFO);
        return orderObj instanceof Boolean ? (Boolean)orderObj : null;
    }

    public static int inferOrder(StarTable pixTable) throws IOException {
        Object levelObj;
        if (!pixTable.isRandom()) {
            throw new IOException("Pixel data not random access");
        }
        long nrow = pixTable.getRowCount();
        int level = -1;
        for (int l = 0; level < 0 && l < 29; ++l) {
            if (nrow != 12L << 2 * l) continue;
            level = l;
        }
        if (level < 0) {
            throw new IOException("Unsuitable number of rows for all-sky HEALPix map (" + nrow + ")");
        }
        List pixParams = pixTable.getParameters();
        DescribedValue levelParam = pixTable.getParameterByName(HealpixTableInfo.HPX_LEVEL_INFO.getName());
        long dLevel = -1L;
        if (levelParam != null && ((levelObj = levelParam.getValue()) instanceof Integer || levelObj instanceof Long)) {
            dLevel = ((Number)levelObj).intValue();
        }
        if (dLevel >= 0L && dLevel != (long)level) {
            String msg = "Order mismatch: declared order (" + dLevel + ") != count (" + level + ")";
            if (HealpixTableInfo.isHealpix((List)pixParams)) {
                throw new IOException(msg);
            }
            logger_.warning(msg);
        }
        return level;
    }

    private static class MeanStatMode
    extends AbstractStatMode {
        MeanStatMode(String name) {
            super(name, false);
        }

        @Override
        public ColumnInfo getResultInfo(ColumnInfo baseInfo) {
            String baseDesc = baseInfo.getDescription();
            String desc = baseDesc == null || baseDesc.trim().length() == 0 ? "Mean value" : baseDesc + ", spatial mean";
            return new ColumnInfo(baseInfo.getName(), Double.class, desc);
        }

        @Override
        public Object getResult(Object[] values) {
            double sum = 0.0;
            double count = 0.0;
            for (int i = 0; i < values.length; ++i) {
                double dval;
                Object val = values[i];
                if (!(val instanceof Number) || Double.isNaN(dval = ((Number)val).doubleValue())) continue;
                sum += dval;
                count += 1.0;
            }
            return count > 0.0 ? Double.valueOf(sum / count) : Double.valueOf(Double.NaN);
        }
    }

    private static class PointStatMode
    extends AbstractStatMode {
        PointStatMode(String name) {
            super(name, true);
        }

        @Override
        public ColumnInfo getResultInfo(ColumnInfo baseInfo) {
            return baseInfo;
        }

        @Override
        public Object getResult(Object[] values) {
            return values != null && values.length > 0 ? values[0] : null;
        }
    }

    private static abstract class AbstractStatMode
    implements StatMode {
        private final String name_;
        private final boolean isPoint_;

        protected AbstractStatMode(String name, boolean isPoint) {
            this.name_ = name;
            this.isPoint_ = isPoint;
        }

        @Override
        public boolean isPoint() {
            return this.isPoint_;
        }

        public String toString() {
            return this.name_;
        }
    }

    public static interface StatMode {
        public ColumnInfo getResultInfo(ColumnInfo var1);

        public Object getResult(Object[] var1);

        public boolean isPoint();
    }
}

