/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.util.regex.Pattern;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.task.Credibility;

@Equality
public class Setting {
    private final String key_;
    private final String strValue_;
    private final String strDflt_;
    private Object objValue_;
    private Credibility credibility_;
    private static final Pattern SHELLSAFE_REGEX = Pattern.compile("[a-zA-Z0-9,._+:@%/-]*");

    public Setting(String key, String strValue, String strDflt) {
        this.key_ = key;
        this.strValue_ = strValue;
        this.strDflt_ = strDflt;
        this.credibility_ = Credibility.YES;
    }

    public String getKey() {
        return this.key_;
    }

    public String getStringValue() {
        return this.strValue_;
    }

    public String getStringDefault() {
        return this.strDflt_;
    }

    public boolean isDefaultValue() {
        return this.strValue_ == null || this.strValue_.trim().length() == 0 ? this.strDflt_ == null || this.strDflt_.trim().length() == 0 : this.strValue_.equals(this.strDflt_);
    }

    public void setObjectValue(Object objValue) {
        this.objValue_ = objValue;
    }

    public Object getObjectValue() {
        return this.objValue_;
    }

    public void setCredibility(Credibility cred) {
        this.credibility_ = cred;
    }

    public Credibility getCredibility() {
        return this.credibility_;
    }

    public Setting appendSuffix(String suffix) {
        Setting s = new Setting(this.key_ + suffix, this.strValue_, this.strDflt_);
        s.setObjectValue(this.getObjectValue());
        s.setCredibility(this.getCredibility());
        return s;
    }

    public Setting resetDefault(String strDflt) {
        Setting s = new Setting(this.key_, this.strValue_, strDflt);
        s.setObjectValue(this.getObjectValue());
        s.setCredibility(this.getCredibility());
        return s;
    }

    public int hashCode() {
        int code = 442990;
        code = 23 * code + this.key_.hashCode();
        code = 23 * code + PlotUtil.hashCode(this.strValue_);
        code = 23 * code + PlotUtil.hashCode(this.strDflt_);
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof Setting) {
            Setting other = (Setting)o;
            return this.key_.equals(other.key_) && PlotUtil.equals(this.strValue_, other.strValue_) && PlotUtil.equals(this.strDflt_, other.strDflt_);
        }
        return false;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer().append(this.key_).append('=').append(Setting.shellQuote(this.strValue_));
        return sbuf.toString();
    }

    public static String shellQuote(String txt) {
        if (txt == null) {
            return "";
        }
        if (SHELLSAFE_REGEX.matcher(txt).matches()) {
            return txt;
        }
        if (txt.indexOf(39) < 0) {
            return "'" + txt + "'";
        }
        if (txt.matches("[^\"$`!\\\\]*")) {
            return "\"" + txt + "\"";
        }
        return "'" + txt.replaceAll("'", "'\\\\''") + "'";
    }
}

