/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.jdbc.SequentialResultSetStarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.MultiParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Tokenizer;
import uk.ac.starlink.ttools.task.ConnectionParameter;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.ttools.task.OutputFormatParameter;

public class SqlClient
implements Task {
    private final ConnectionParameter connParam_ = new ConnectionParameter("db");
    private final StatementParameter stmtParam_ = new StatementParameter("sql");
    private final OutputFormatParameter ofmtParam_ = new OutputFormatParameter("ofmt");

    public SqlClient() {
        this.ofmtParam_.setStringDefault("text");
    }

    public String getPurpose() {
        return "Executes SQL statements";
    }

    public Parameter<?>[] getParameters() {
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add((Object)this.connParam_);
        paramList.addAll(Arrays.asList(this.connParam_.getAssociatedParameters()));
        paramList.add((Object)this.stmtParam_);
        paramList.add(this.ofmtParam_);
        return paramList.toArray(new Parameter[0]);
    }

    public Executable createExecutable(Environment env) throws TaskException {
        StarTableWriter writer;
        try {
            writer = LineTableEnvironment.getTableOutput(env).getHandler(this.ofmtParam_.stringValue(env));
        }
        catch (TableFormatException e) {
            throw new ParameterValueException((Parameter)this.ofmtParam_, "Unknown table format", (Throwable)e);
        }
        StreamResultSink sink = new StreamResultSink(writer, env.getOutputStream());
        Connection connection = (Connection)this.connParam_.objectValue(env);
        String[] sqlLines = Tokenizer.tokenizeLines(this.stmtParam_.stringValue(env));
        PrintStream err = env.getErrorStream();
        try {
            return new SqlExecutable(connection, sqlLines, sink, err);
        }
        catch (SQLException e) {
            throw new TaskException(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean isStreamable(StarTableWriter writer) {
        return writer.getFormatName().toLowerCase().indexOf("fits") < 0;
    }

    private static class StatementParameter
    extends StringParameter
    implements MultiParameter {
        StatementParameter(String name) {
            super(name);
            this.setUsage("<sql>");
            this.setPrompt("Line of SQL");
            this.setDescription(new String[]{"<p>Text of an SQL statement for execution.", "This parameter may be repeated, or statements may be", "separated by semicolon (\"<code>;</code>\") characters.", "</p>"});
        }

        public char getValueSeparator() {
            return ';';
        }
    }

    private static class StreamResultSink
    extends ResultSink {
        private final StarTableWriter writer_;
        private final PrintStream out_;

        public StreamResultSink(StarTableWriter writer, PrintStream out) {
            super(SqlClient.isStreamable(writer));
            this.writer_ = writer;
            this.out_ = out;
        }

        @Override
        protected void write(StarTable table) throws IOException {
            this.writer_.writeStarTable(table, (OutputStream)this.out_);
        }
    }

    private static abstract class ResultSink {
        private final boolean isStream_;

        protected ResultSink(boolean isStream) {
            this.isStream_ = isStream;
        }

        protected abstract void write(StarTable var1) throws IOException;

        public void write(ResultSet rset) throws SQLException, IOException {
            SequentialResultSetStarTable table = new SequentialResultSetStarTable(rset);
            if (!this.isStream_) {
                table = Tables.randomTable((StarTable)table);
            }
            this.write((StarTable)table);
        }
    }

    private static class SqlExecutable
    implements Executable {
        private final Connection connection_;
        private final Statement stmt_;
        private final String[] sqlLines_;
        private final ResultSink sink_;
        private final PrintStream err_;

        SqlExecutable(Connection connection, String[] sqlLines, ResultSink sink, PrintStream err) throws SQLException {
            this.connection_ = connection;
            this.stmt_ = connection.createStatement();
            this.sqlLines_ = sqlLines;
            this.sink_ = sink;
            this.err_ = err;
        }

        public void execute() throws TaskException, IOException {
            try {
                for (int i = 0; i < this.sqlLines_.length; ++i) {
                    this.executeLine(this.sqlLines_[i]);
                }
            }
            catch (SQLException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
            finally {
                try {
                    this.connection_.close();
                }
                catch (SQLException sQLException) {}
            }
        }

        private void executeLine(String sqlLine) throws SQLException, IOException {
            long start = System.currentTimeMillis();
            this.err_.println("sql> " + sqlLine.trim());
            boolean hasRset = this.stmt_.execute(sqlLine);
            while (hasRset || this.stmt_.getUpdateCount() >= 0) {
                if (hasRset) {
                    this.sink_.write(this.stmt_.getResultSet());
                } else {
                    this.err_.println("Updates: " + this.stmt_.getUpdateCount());
                }
                hasRset = this.stmt_.getMoreResults();
            }
            long elapsed = System.currentTimeMillis() - start;
            this.err_.println("Elapsed time: " + (float)((double)elapsed / 1000.0) + " sec");
            this.err_.println();
        }
    }
}

