/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.filter.ProgressFilter;
import uk.ac.starlink.ttools.filter.SelectFilter;
import uk.ac.starlink.ttools.task.AbstractInputTableParameter;
import uk.ac.starlink.ttools.task.Credibility;
import uk.ac.starlink.ttools.task.CredibleString;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.InputFormatParameter;
import uk.ac.starlink.ttools.task.MapEnvironment;
import uk.ac.starlink.ttools.task.Setting;
import uk.ac.starlink.ttools.task.SettingGroup;
import uk.ac.starlink.ttools.task.TableNamer;

public class StiltsCommand {
    private final Task task_;
    private final String taskName_;
    private final SettingGroup[] groups_;
    private static final Collection<String> autoFormatNames_ = StiltsCommand.getAutoFormatNames();

    public StiltsCommand(Task task, String taskName, SettingGroup[] groups) {
        this.task_ = task;
        this.taskName_ = taskName;
        this.groups_ = groups;
    }

    public Task getTask() {
        return this.task_;
    }

    public String getTaskName() {
        return this.taskName_;
    }

    public SettingGroup[] getGroups() {
        return this.groups_;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("stilts ").append(this.taskName_).append(" \\\n");
        for (SettingGroup group : this.groups_) {
            Setting[] settings = (Setting[])Arrays.stream(group.getSettings()).filter(s -> !s.isDefaultValue()).toArray(Setting[]::new);
            if (settings.length <= 0) continue;
            sbuf.append(Stream.generate(() -> "   ").limit(group.getLevel()).collect(Collectors.joining())).append(Arrays.stream(settings).map(s -> s.toString()).collect(Collectors.joining(" "))).append(" \\\n");
        }
        return sbuf.toString();
    }

    public static StiltsCommand createCommand(Task task, SettingGroup[] groups) {
        String taskName = Stilts.getTaskFactory().getNickName(task.getClass());
        return new StiltsCommand(task, taskName, groups);
    }

    public static List<Setting> createInputTableSettings(AbstractInputTableParameter<?> inParam, StarTable table, TableNamer namer, FilterParameter filterParam, CredibleString selection) {
        ArrayList<Setting> settings = new ArrayList<Setting>();
        if (table != null) {
            Setting selectSetting;
            CredibleString naming = namer.nameTable(table);
            Credibility nameCred = naming.getCredibility();
            Setting tableSetting = new Setting(inParam.getName(), naming.getValue(), null);
            tableSetting.setObjectValue(table);
            tableSetting.setCredibility(nameCred);
            settings.add(tableSetting);
            if (nameCred == Credibility.YES || nameCred == Credibility.MAYBE) {
                Setting tfmtSetting;
                InputFormatParameter fmtParam = inParam.getFormatParameter();
                TableBuilder tfmt = namer.getTableFormat(table);
                if (tfmt != null) {
                    String fmtName = tfmt.getFormatName();
                    tfmtSetting = autoFormatNames_.contains(fmtName) ? StiltsCommand.createDefaultParamSetting(fmtParam) : StiltsCommand.createParamSetting(fmtParam, fmtName);
                } else {
                    tfmtSetting = StiltsCommand.createDefaultParamSetting(fmtParam);
                    tfmtSetting.setCredibility(Credibility.MAYBE);
                }
                settings.add(tfmtSetting);
            }
            if (selection != null) {
                String filterCmd = new SelectFilter().getName() + " " + StiltsCommand.argQuote(selection.getValue());
                selectSetting = new Setting(filterParam.getName(), filterCmd, null);
                selectSetting.setCredibility(selection.getCredibility());
            } else {
                selectSetting = new Setting(filterParam.getName(), null, null);
            }
            settings.add(selectSetting);
        }
        return settings;
    }

    public static <T> Setting createParamSetting(Parameter<T> param, T tval) {
        String value;
        String key = param.getName();
        try {
            value = param.objectToString((Environment)new MapEnvironment(), tval);
        }
        catch (TaskException e) {
            assert (false);
            throw new RuntimeException();
        }
        String dflt = param.getStringDefault();
        return new Setting(key, value, dflt);
    }

    public static Setting createDefaultParamSetting(Parameter<?> param) {
        String dflt = param.getStringDefault();
        return new Setting(param.getName(), dflt, dflt);
    }

    public static Setting createProgressSetting(FilterParameter filterParam) {
        return new Setting(filterParam.getName(), new ProgressFilter().getName(), null);
    }

    public static <T> Parameter<T> getParameterByType(Task task, Class<T> ptype) {
        List params = Arrays.stream(task.getParameters()).filter(p -> ptype.isAssignableFrom(p.getValueClass())).collect(Collectors.toList());
        if (params.size() == 1) {
            Parameter tparam = (Parameter)params.get(0);
            return tparam;
        }
        return null;
    }

    public static List<SettingGroup> toGroups(int level, List<Setting> settings) {
        ArrayList<Setting> inList = new ArrayList<Setting>(settings);
        inList.add(null);
        ArrayList<SettingGroup> glist = new ArrayList<SettingGroup>();
        ArrayList<Setting> slist = new ArrayList<Setting>();
        for (Setting s : inList) {
            if (s != null) {
                slist.add(s);
                continue;
            }
            if (slist.size() <= 0) continue;
            Setting[] line = slist.toArray(new Setting[0]);
            glist.add(new SettingGroup(level, line));
            slist = new ArrayList();
        }
        return glist;
    }

    private static String argQuote(String txt) {
        boolean hasSpace;
        boolean hasSquot = txt.indexOf(39) >= 0;
        boolean hasDquot = txt.indexOf(34) >= 0;
        boolean bl = hasSpace = txt.indexOf(32) >= 0;
        if (hasSquot || hasDquot || hasSpace) {
            return "\"" + txt.replaceAll("\"", "\\\\\"") + "\"";
        }
        return txt;
    }

    private static Collection<String> getAutoFormatNames() {
        HashSet<String> list = new HashSet<String>();
        for (Object obj : new StarTableFactory().getDefaultBuilders()) {
            if (obj instanceof TableBuilder) {
                list.add(((TableBuilder)obj).getFormatName());
                continue;
            }
            assert (false);
        }
        return list;
    }
}

