/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.DoubleParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.URLParameter;
import uk.ac.starlink.ttools.cone.ConeSearcher;
import uk.ac.starlink.ttools.cone.ConeServiceType;
import uk.ac.starlink.ttools.convert.SkySystem;
import uk.ac.starlink.ttools.task.ChoiceMode;
import uk.ac.starlink.ttools.task.ConsumerTask;
import uk.ac.starlink.ttools.task.ContentCodingParameter;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.ttools.task.TableProducer;
import uk.ac.starlink.util.ContentCoding;

public class TableCone
extends ConsumerTask {
    private final URLParameter urlParam_;
    private final DoubleParameter lonParam_;
    private final DoubleParameter latParam_;
    private final DoubleParameter radiusParam_;
    private final ChoiceParameter<String> verbParam_;
    private final ChoiceParameter<ConeServiceType> serviceParam_;
    private final ContentCodingParameter codingParam_;
    private final ChoiceParameter<SkySystem> sysParam_;
    private final StringParameter formatParam_;

    public TableCone() {
        super("Executes a Cone Search-like query", new ChoiceMode(), true);
        ArrayList<Object> coneParams = new ArrayList<Object>();
        String sysParamName = "skysys";
        this.urlParam_ = new URLParameter("serviceurl");
        this.urlParam_.setPrompt("Base URL for query returning VOTable");
        this.urlParam_.setDescription(new String[]{"<p>The base part of a URL which defines the query to be made.", "Additional parameters will be appended to this using CGI syntax", "(\"<code>name=value</code>\", separated by '&amp;' characters).", "If this value does not end in either a '?' or a '&amp;',", "one will be added as appropriate.", "</p>"});
        coneParams.add(this.urlParam_);
        this.lonParam_ = new DoubleParameter("lon");
        this.lonParam_.setPrompt("Longitude in degrees");
        this.lonParam_.setUsage("<degrees>");
        this.lonParam_.setDescription(new String[]{"<p>Central longitude position for cone search.", "By default this is the Right Ascension,", "but depending on the value of the", "<code>skysys</code> parameter", "it may be in a different sky system.", "</p>"});
        coneParams.add(this.lonParam_);
        this.latParam_ = new DoubleParameter("lat");
        this.latParam_.setPrompt("Latitude in degrees");
        this.latParam_.setUsage("<degrees>");
        this.latParam_.setDescription(new String[]{"<p>Central latitude position for cone search.", "By default this is the Declination,", "but depending on the value of the", "<code>skysys</code> parameter", "it may be in a different sky system.", "</p>"});
        coneParams.add(this.latParam_);
        this.radiusParam_ = new DoubleParameter("radius");
        this.radiusParam_.setPrompt("Radius in degrees");
        this.radiusParam_.setUsage("<degrees>");
        this.radiusParam_.setDescription(new String[]{"<p>Search radius in degrees.", "</p>"});
        coneParams.add(this.radiusParam_);
        this.sysParam_ = new ChoiceParameter("skysys", (Object[])SkySystem.getKnownSystems());
        this.sysParam_.setPrompt("Sky coordinate system for central position");
        this.sysParam_.setDescription(new String[]{"<p>Sky coordinate system used to interpret the", "<code>" + this.lonParam_.getName() + "</code> and", "<code>" + this.latParam_.getName() + "</code> parameters.", "If the value is ICRS (the default)", "the provided values are assumed to be", "Right Ascension and Declination and", "are sent unchanged; for other values they will be", "converted from the named system into RA and Dec first.", "</p>"});
        this.sysParam_.setDefaultOption((Object)SkySystem.ICRS);
        coneParams.add(this.sysParam_);
        Object[] serviceTypes = ConeServiceType.getAllTypes();
        this.serviceParam_ = new ChoiceParameter("servicetype", serviceTypes);
        this.serviceParam_.setPrompt("Search service type");
        StringBuffer typesDescrip = new StringBuffer();
        for (Object stype : serviceTypes) {
            typesDescrip.append("<li>").append("<code>").append(stype).append("</code>:\n").append(((ConeServiceType)stype).getDescription()).append("</li>").append("\n");
        }
        this.serviceParam_.setDescription(new String[]{"<p>Selects the type of data access service to contact.", "Most commonly this will be the Cone Search service itself,", "but there are one or two other possibilities:", "<ul>", typesDescrip.toString(), "</ul>", "</p>"});
        this.serviceParam_.setDefaultOption(serviceTypes[0]);
        coneParams.add(this.serviceParam_);
        this.verbParam_ = new ChoiceParameter("verb", (Object[])new String[]{"1", "2", "3"});
        this.verbParam_.setNullPermitted(true);
        this.verbParam_.setPrompt("Verbosity level of search responses (1..3)");
        this.verbParam_.setDescription(new String[]{"<p>Verbosity level of the tables returned by the query service.", "A value of 1 indicates the bare minimum and", "3 indicates all available information.", "</p>"});
        coneParams.add(this.verbParam_);
        this.codingParam_ = new ContentCodingParameter();
        coneParams.add((Object)this.codingParam_);
        this.formatParam_ = new StringParameter("dataformat");
        this.formatParam_.setPrompt("Data format type for DAL outputs");
        this.formatParam_.setNullPermitted(true);
        StringBuffer formatsDescrip = new StringBuffer();
        for (int i = 0; i < serviceTypes.length; ++i) {
            Object stype = serviceTypes[i];
            formatsDescrip.append("<li>").append("<code>").append(this.serviceParam_.getName()).append("=").append(stype).append("</code>:\n").append(((ConeServiceType)stype).getFormatDescription()).append("</li>").append("\n");
        }
        this.formatParam_.setDescription(new String[]{"<p>Indicates the format of data objects described in the", "returned table.", "The meaning of this is dependent on the value of the", "<code>" + this.serviceParam_.getName() + "</code>", "parameter:", "<ul>", formatsDescrip.toString(), "</ul>", "</p>"});
        coneParams.add(this.formatParam_);
        this.getParameterList().addAll(0, coneParams);
    }

    @Override
    public TableProducer createProducer(Environment env) throws TaskException {
        double decDeg;
        double raDeg;
        URL url = (URL)this.urlParam_.objectValue(env);
        ConeServiceType serviceType = (ConeServiceType)this.serviceParam_.objectValue(env);
        serviceType.configureRadiusParam((Parameter<Double>)this.radiusParam_);
        double lon = this.lonParam_.doubleValue(env);
        double lat = this.latParam_.doubleValue(env);
        final double radius = this.radiusParam_.doubleValue(env);
        SkySystem skysys = (SkySystem)this.sysParam_.objectValue(env);
        ContentCoding coding = this.codingParam_.codingValue(env);
        if (SkySystem.ICRS.equals(skysys)) {
            raDeg = lon;
            decDeg = lat;
        } else {
            double epoch = 2000.0;
            double[] posFk5Rad = skysys.toFK5(Math.toRadians(lon), Math.toRadians(lat), epoch);
            double[] posIcrsRad = SkySystem.ICRS.fromFK5(posFk5Rad[0], posFk5Rad[1], epoch);
            raDeg = Math.toDegrees(posIcrsRad[0]);
            decDeg = Math.toDegrees(posIcrsRad[1]);
        }
        StarTableFactory tfact = LineTableEnvironment.getTableFactory(env);
        final ConeSearcher searcher = serviceType.createSingleSearcher(env, this, url.toString(), tfact, coding);
        return new TableProducer(){

            @Override
            public StarTable getTable() throws IOException {
                return searcher.performSearch(raDeg, decDeg, radius);
            }
        };
    }

    public Parameter<String> getFormatParameter() {
        return this.formatParam_;
    }

    public Parameter<String> getVerbosityParameter() {
        return this.verbParam_;
    }

    public Parameter<URL> getServiceUrlParameter() {
        return this.urlParam_;
    }

    public Parameter<ConeServiceType> getServiceTypeParameter() {
        return this.serviceParam_;
    }

    public Parameter<Double> getLongitudeParameter() {
        return this.lonParam_;
    }

    public Parameter<Double> getLatitudeParameter() {
        return this.latParam_;
    }

    public Parameter<Double> getRadiusDegParameter() {
        return this.radiusParam_;
    }

    public Parameter<SkySystem> getSkySystemParameter() {
        return this.sysParam_;
    }
}

