/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.util.Arrays;
import uk.ac.starlink.table.LoopStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.DoubleParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.ChoiceMode;
import uk.ac.starlink.ttools.task.ConsumerTask;
import uk.ac.starlink.ttools.task.TableProducer;

public class TableLoop
extends ConsumerTask {
    private final StringParameter varParam_ = new StringParameter("colname");
    private final DoubleParameter startParam_;
    private final DoubleParameter endParam_;
    private final DoubleParameter stepParam_;
    private final BooleanParameter forceFloatParam_;

    public TableLoop() {
        super("Generates a single-column table from a loop variable", new ChoiceMode(), true);
        this.varParam_.setPrompt("Column name");
        this.varParam_.setDescription(new String[]{"<p>Gives the name of the single column produced by this command.", "</p>"});
        this.varParam_.setStringDefault("i");
        this.stepParam_ = new DoubleParameter("step");
        this.stepParam_.setPrompt("Loop step value");
        this.stepParam_.setDescription(new String[]{"<p>Amount by which the loop variable will be incremented", "at each iteration, i.e. each table row.", "</p>"});
        this.stepParam_.setDoubleDefault(1.0);
        this.startParam_ = new DoubleParameter("start");
        this.startParam_.setPrompt("Loop initial value");
        this.startParam_.setDescription(new String[]{"<p>Gives the starting value of the loop variable.", "This will the the value in the first row of the table.", "</p>"});
        this.startParam_.setDoubleDefault(0.0);
        this.endParam_ = new DoubleParameter("end");
        this.endParam_.setPrompt("Loop final value");
        this.endParam_.setDescription(new String[]{"<p>Gives the value which the loop variable will not exceed.", "Exceeding is in the positive or negative sense according to", "the sense of the <code>" + this.stepParam_.getName() + "</code>", "parameter, as usual for a <code>for</code>-type loop.", "</p>"});
        this.forceFloatParam_ = new BooleanParameter("forcefloat");
        this.forceFloatParam_.setPrompt("Force loop column to be floating point?");
        this.forceFloatParam_.setDescription(new String[]{"<p>Affects the data type of the loop variable column.", "If true, the column is always floating point.", "If false, and if the other parameters are all of integer type,", "the column will be an integer column.", "</p>"});
        this.forceFloatParam_.setBooleanDefault(false);
        int ipos = 0;
        this.varParam_.setPosition(++ipos);
        this.startParam_.setPosition(++ipos);
        this.endParam_.setPosition(++ipos);
        this.stepParam_.setPosition(++ipos);
        this.getParameterList().addAll(Arrays.asList(this.varParam_, this.startParam_, this.endParam_, this.stepParam_, this.forceFloatParam_));
    }

    @Override
    public TableProducer createProducer(Environment env) throws TaskException {
        String colname = this.varParam_.stringValue(env);
        double start = this.startParam_.doubleValue(env);
        double end = this.endParam_.doubleValue(env);
        double step = this.stepParam_.doubleValue(env);
        Boolean isInteger = this.forceFloatParam_.booleanValue(env) ? Boolean.FALSE : null;
        LoopStarTable table = new LoopStarTable(colname, start, end, step, isInteger);
        return new TableProducer((StarTable)table){
            final /* synthetic */ StarTable val$table;
            {
                this.val$table = starTable;
            }

            @Override
            public StarTable getTable() {
                return this.val$table;
            }
        };
    }
}

