/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.URLParameter;
import uk.ac.starlink.ttools.task.ChoiceMode;
import uk.ac.starlink.ttools.task.ConsumerTask;
import uk.ac.starlink.ttools.task.ContentCodingParameter;
import uk.ac.starlink.ttools.task.TableProducer;
import uk.ac.starlink.ttools.task.TapResultProducer;
import uk.ac.starlink.ttools.task.TapResultReader;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.UwsJob;
import uk.ac.starlink.vo.UwsJobInfo;
import uk.ac.starlink.vo.UwsStage;

public class TapResume
extends ConsumerTask {
    private final URLParameter urlParam_;
    private final ContentCodingParameter codingParam_;
    private final TapResultReader resultReader_;

    public TapResume() {
        super("Resumes a previous query to a Table Access Protocol server", new ChoiceMode(), true);
        ArrayList<Object> paramList = new ArrayList<Object>();
        this.urlParam_ = new URLParameter("joburl");
        this.urlParam_.setPrompt("Job URL for a previously created TAP query");
        this.urlParam_.setDescription(new String[]{"<p>The URL of a job created by submission of a TAP query", "which was created earlier and has not yet been", "deleted (by the client) or destroyed (by the server).", "This will usually be of the form", "<code>&lt;tap-url&gt;/async/&lt;job-id&gt;</code>.", "You can also find out, and possibly retrieve results from", "the job by pointing a web browser at this URL.", "</p>"});
        paramList.add(this.urlParam_);
        this.codingParam_ = new ContentCodingParameter();
        paramList.add((Object)this.codingParam_);
        this.resultReader_ = new TapResultReader();
        paramList.addAll(Arrays.asList(this.resultReader_.getParameters()));
        this.getParameterList().addAll(0, paramList);
    }

    @Override
    public TableProducer createProducer(Environment env) throws TaskException {
        final URL jobUrl = (URL)this.urlParam_.objectValue(env);
        ContentCoding coding = this.codingParam_.codingValue(env);
        final TapResultProducer resultProducer = this.resultReader_.createResultProducer(env, coding);
        return new TableProducer(){

            @Override
            public StarTable getTable() throws IOException {
                UwsJobInfo info;
                UwsJob uwsJob = new UwsJob(jobUrl);
                try {
                    info = uwsJob.readInfo();
                }
                catch (FileNotFoundException e) {
                    throw (IOException)new IOException("No such TAP job").initCause(e);
                }
                UwsStage stage = UwsStage.forPhase((String)info.getPhase());
                if (stage == UwsStage.UNSTARTED) {
                    uwsJob.start();
                }
                return resultProducer.waitForResult(uwsJob);
            }
        };
    }
}

