/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import java.util.ArrayList;
import java.util.List;
import uk.ac.starlink.ttools.votlint.AttributeChecker;
import uk.ac.starlink.ttools.votlint.ElementHandler;
import uk.ac.starlink.ttools.votlint.FieldHandler;
import uk.ac.starlink.ttools.votlint.VotLintCode;

public class TableHandler
extends ElementHandler {
    private long nrowsSpecified_ = -1L;
    private long nrowsSeen_ = 0L;
    private boolean dataSeen_;
    private List<FieldHandler> fields_ = new ArrayList<FieldHandler>();

    @Override
    public void endElement() {
        if (this.nrowsSpecified_ >= 0L && this.dataSeen_ && this.nrowsSeen_ != this.nrowsSpecified_) {
            this.error(new VotLintCode("NRM"), "Row count (" + this.nrowsSeen_ + ") not equal to nrows attribute (" + this.nrowsSpecified_ + ")");
        }
    }

    public void foundRow() {
        ++this.nrowsSeen_;
    }

    public void foundData() {
        this.dataSeen_ = true;
    }

    public long getCurrentRowIndex() {
        return this.nrowsSeen_;
    }

    public void registerField(FieldHandler field) {
        this.fields_.add(field);
    }

    public List<FieldHandler> getFields() {
        return this.fields_;
    }

    public static class NrowsChecker
    implements AttributeChecker {
        @Override
        public void check(String value, ElementHandler handler) {
            TableHandler thandler = (TableHandler)handler;
            try {
                long nr = Long.parseLong(value);
                if (nr < 0L) {
                    handler.error(new VotLintCode("NRM"), "Negative value for nrows: " + value);
                } else {
                    thandler.nrowsSpecified_ = nr;
                }
            }
            catch (IllegalArgumentException e) {
                handler.error(new VotLintCode("NFT"), "Bad number format for nrows: " + value);
            }
        }
    }
}

