/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import uk.ac.starlink.ttools.votlint.Ancestry;
import uk.ac.starlink.ttools.votlint.DataHandler;
import uk.ac.starlink.ttools.votlint.ElementHandler;
import uk.ac.starlink.ttools.votlint.TableHandler;
import uk.ac.starlink.ttools.votlint.VotLintCode;

public class TrHandler
extends ElementHandler {
    @Override
    public void endElement() {
        Ancestry family = this.getAncestry();
        DataHandler data = family.getAncestor(DataHandler.class);
        if (data != null) {
            int nchild;
            int ncol = data.getColumnCount();
            if (ncol != (nchild = family.getChildCount())) {
                this.warning(new VotLintCode("TR9"), "Wrong number of TDs in row (expecting " + ncol + " found " + nchild + ")");
            }
        } else {
            this.error(new VotLintCode("TRS"), this.getName() + " outside DATA");
        }
        TableHandler table = family.getAncestor(TableHandler.class);
        if (table != null) {
            table.foundRow();
        } else {
            this.error(new VotLintCode("TRS"), this.getName() + " outside TABLE");
        }
    }
}

