/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import uk.ac.starlink.ttools.votlint.AttributeChecker;
import uk.ac.starlink.ttools.votlint.ElementHandler;
import uk.ac.starlink.ttools.votlint.VotLintCode;
import uk.ac.starlink.ttools.votlint.VotLintContext;
import uk.ac.starlink.vo.UcdStatus;

public class UcdChecker
implements AttributeChecker {
    public static final UcdChecker INSTANCE = new UcdChecker();

    private UcdChecker() {
    }

    @Override
    public void check(String ucd, ElementHandler handler) {
        UcdStatus status;
        VotLintContext context = handler.getContext();
        if (context.isCheckUcd() && (status = UcdStatus.getStatus((String)ucd)) != null) {
            UcdStatus.Code code = status.getCode();
            if (code.isError()) {
                context.error(new VotLintCode("UCD"), "Bad UCD \"" + ucd + "\" (" + code + "): " + status.getMessage());
            } else if (code.isWarning()) {
                context.warning(new VotLintCode("UCW"), "Questionable UCD \"" + ucd + "\" (" + code + "): " + status.getMessage());
            }
        }
    }
}

