/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.ttools.func.Times;
import uk.ac.starlink.ttools.votlint.ElementHandler;
import uk.ac.starlink.ttools.votlint.VotLintCode;
import uk.ac.starlink.ttools.votlint.VotLintContext;

public abstract class ValueParser {
    private final ReportElement el_;
    private VotLintContext context_;
    private static final Pattern DOUBLE_REGEX = Pattern.compile("([+-])?[0-9]*([0-9]|[0-9]\\.|\\.[0-9])[0-9]*([Ee][+-]?[0-9]{1,3})?");
    private static final Pattern ISO_REGEX = Pattern.compile("[0-9]{4}-[01][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9]:[0-6][0-9]([.][0-9]+)?)?Z?");

    private ValueParser(ReportElement el) {
        this.el_ = el;
    }

    public abstract void checkString(String var1, long var2);

    public abstract void checkStream(InputStream var1, long var2) throws IOException;

    public abstract Class<?> getContentClass();

    public abstract int getElementCount();

    public void setContext(VotLintContext context) {
        this.context_ = context;
    }

    public VotLintContext getContext() {
        return this.context_;
    }

    public void info(VotLintCode code, String msg, long irow) {
        this.getContext().info(code, this.el_.msg(msg, irow));
    }

    public void warning(VotLintCode code, String msg, long irow) {
        this.getContext().warning(code, this.el_.msg(msg, irow));
    }

    public void error(VotLintCode code, String msg, long irow) {
        this.getContext().error(code, this.el_.msg(msg, irow));
    }

    public static ValueParser makeParser(ElementHandler handler, String name, String datatype, String arraysize, String xtype) {
        int[] shape;
        ReportElement el = new ReportElement(handler, name);
        if (datatype == null || datatype.trim().length() == 0) {
            return null;
        }
        if (arraysize == null || arraysize.trim().length() == 0) {
            shape = new int[]{1};
            if ("char".equals(datatype) || "unicodeChar".equals(datatype)) {
                handler.info(new VotLintCode("AR1"), el.msg("No arraysize for datatype='character'; implies single character"));
            }
        } else {
            String[] dims = arraysize.split("x");
            shape = new int[dims.length];
            for (int i = 0; i < dims.length; ++i) {
                if (i == dims.length - 1 && dims[i].endsWith("*")) {
                    String num = dims[i].substring(0, dims[i].length() - 1);
                    if (num.length() > 0) {
                        try {
                            Integer.parseInt(num);
                        }
                        catch (NumberFormatException e) {
                            handler.error(new VotLintCode("ARB"), el.msg("Bad arraysize value '" + arraysize + "'"));
                        }
                    }
                    shape[i] = -1;
                    continue;
                }
                try {
                    shape[i] = Integer.parseInt(dims[i]);
                }
                catch (NumberFormatException e) {
                    handler.error(new VotLintCode("ARB"), el.msg("Bad arraysize value '" + arraysize + "'"));
                    return null;
                }
                if (shape[i] >= 0) continue;
                handler.error(new VotLintCode("DMN"), el.msg("Negative dimensions element " + shape[i]));
                return null;
            }
        }
        int nel = Arrays.stream(shape).reduce(1, (a, b) -> a * b);
        ValueParser xtypeParser = ValueParser.makeXtypeParser(el, handler.getContext(), xtype, datatype, shape);
        if (xtypeParser != null) {
            return xtypeParser;
        }
        if ("char".equals(datatype) || "unicodeChar".equals(datatype)) {
            boolean ascii = "char".equals(datatype);
            int stringLeng = shape[0];
            if (nel == 1) {
                return new SingleCharParser(el, ascii);
            }
            if (shape.length == 1) {
                return stringLeng < 0 ? new VariableCharParser(el, ascii) : new FixedCharParser(el, ascii, stringLeng);
            }
            return nel < 0 ? new VariableCharArrayParser(el, ascii) : new FixedCharArrayParser(el, ascii, nel, stringLeng);
        }
        if ("bit".equals(datatype)) {
            return nel < 0 ? new VariableBitParser(el) : new FixedBitParser(el, nel);
        }
        if ("floatComplex".equals(datatype)) {
            FloatParser fParser = new FloatParser(new ReportElement());
            return nel < 0 ? new VariableArrayParser(el, fParser, float[].class) : new FixedArrayParser(el, fParser, float[].class, nel * 2);
        }
        if ("doubleComplex".equals(datatype)) {
            DoubleParser dParser = new DoubleParser(new ReportElement());
            return nel < 0 ? new VariableArrayParser(el, dParser, double[].class) : new FixedArrayParser(el, dParser, double[].class, nel * 2);
        }
        if (nel == 1) {
            return ValueParser.makeScalarParser(el, datatype, handler);
        }
        ValueParser base = ValueParser.makeScalarParser(new ReportElement(), datatype, handler);
        if (base == null) {
            return null;
        }
        Class<?> clazz = ValueParser.getArrayClass(base.getContentClass());
        return nel < 0 ? new VariableArrayParser(el, base, clazz) : new FixedArrayParser(el, base, clazz, nel);
    }

    private static ValueParser makeXtypeParser(ReportElement el, VotLintContext context, String xtype, String datatype, int[] shape) {
        boolean isChars;
        if (xtype == null || xtype.trim().length() == 0) {
            return null;
        }
        boolean isFloating = "float".equals(datatype) || "double".equals(datatype);
        boolean isNumeric = isFloating || "short".equals(datatype) || "int".equals(datatype) || "long".equals(datatype);
        boolean isArray1d = shape.length == 1;
        int arraysize1d = isArray1d ? shape[0] : 0;
        int nel = Arrays.stream(shape).reduce(1, (a, b) -> a * b);
        boolean bl = isChars = isArray1d && "char".equals(datatype);
        if ("timestamp".equals(xtype)) {
            if (!isChars) {
                context.error(new VotLintCode("XTS"), el.msg("xtype='timestamp' for non-string-type value"));
                return null;
            }
            return ValueParser.makeTimestampParser(el, arraysize1d);
        }
        if ("interval".equals(xtype)) {
            if (arraysize1d != 2) {
                context.error(new VotLintCode("XI2"), el.msg("xtype='interval' for arraysize != 2"));
                return null;
            }
            if (!isNumeric) {
                context.error(new VotLintCode("XI9"), el.msg("xtype='interval' for non-numeric datatype"));
                return null;
            }
            if (isFloating) {
                return ValueParser.makeFloatingIntervalParser(el, datatype);
            }
            return null;
        }
        if ("point".equals(xtype)) {
            if (arraysize1d != 2) {
                context.error(new VotLintCode("XP2"), el.msg("xtype='point' for arraysize != 2"));
                return null;
            }
            if (!isFloating) {
                context.error(new VotLintCode("XP9"), el.msg("xtype='point' for non-floating datatype"));
                return null;
            }
            return ValueParser.makePointParser(el, datatype);
        }
        if ("circle".equals(xtype)) {
            if (arraysize1d != 3) {
                context.error(new VotLintCode("XC3"), el.msg("xtype='circle' for arraysize != 3"));
                return null;
            }
            if (!isFloating) {
                context.error(new VotLintCode("XC9"), el.msg("xtype='circle' for non-floating datatype"));
                return null;
            }
            return ValueParser.makeCircleParser(el, datatype);
        }
        if ("polygon".equals(xtype)) {
            if (!isArray1d) {
                context.error(new VotLintCode("XSV"), el.msg("xtype='polygon' for non-vector arraysize"));
                return null;
            }
            if (!isFloating) {
                context.error(new VotLintCode("XS9"), el.msg("xtype='polygon' for non-floating datatype"));
                return null;
            }
            return ValueParser.makePolygonParser(el, datatype, arraysize1d);
        }
        if (xtype.indexOf(58) > 0) {
            context.info(new VotLintCode("XNI"), el.msg("Namespaced non-DALI xtype value \"" + xtype + "\""));
            return null;
        }
        context.warning(new VotLintCode("XDL"), el.msg("Non-DALI 1.1 xtype value \"" + xtype + "\""));
        return null;
    }

    private static ValueParser makeScalarParser(ReportElement el, String datatype, ElementHandler handler) {
        if ("boolean".equals(datatype)) {
            return new BooleanParser(el);
        }
        if ("unsignedByte".equals(datatype)) {
            return new IntegerParser(el, 1, 0L, 255L, Short.class);
        }
        if ("short".equals(datatype)) {
            return new IntegerParser(el, 2, -32768L, 32767L, Short.class);
        }
        if ("int".equals(datatype)) {
            return new IntegerParser(el, 4, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.class);
        }
        if ("long".equals(datatype)) {
            return new IntegerParser(el, 8, Long.MIN_VALUE, Long.MAX_VALUE, Long.class);
        }
        if ("float".equals(datatype)) {
            return new FloatParser(el);
        }
        if ("double".equals(datatype)) {
            return new DoubleParser(el);
        }
        handler.error(new VotLintCode("DTX"), "Unknown datatype '" + datatype + "' - can't parse column");
        return null;
    }

    private static ValueParser makeTimestampParser(ReportElement el, int stringLeng) {
        return ValueParser.makeStringParser(el, stringLeng, (context, txt, irow) -> {
            if (txt != null && txt.trim().length() > 0) {
                if (!ISO_REGEX.matcher(txt).matches()) {
                    context.error(new VotLintCode("TSR"), el.msg("Timestamp value \"" + txt + "\" does not match YYYY-MM-DD['T'hh:mm:ss[.SSS]]['Z']", irow));
                } else {
                    try {
                        Times.isoToMjd(txt);
                    }
                    catch (RuntimeException e) {
                        context.error(new VotLintCode("TSR"), el.msg("Bad timestamp \"" + txt + "\" " + e.getMessage(), irow));
                    }
                }
            }
        });
    }

    private static ValueParser makeFloatingIntervalParser(ReportElement el, String datatype) {
        return ValueParser.makeFloatingArrayParser(el, datatype, 2, (context, values, irow) -> {
            double d0 = values[0];
            double d1 = values[1];
            if (Double.isNaN(d0) != Double.isNaN(d1)) {
                context.error(new VotLintCode("XIN"), el.msg("One but not both interval limit is NaN " + Arrays.toString(values), irow));
            }
        });
    }

    private static ValueParser makePointParser(ReportElement el, String datatype) {
        return ValueParser.makeFloatingArrayParser(el, datatype, 2, (context, values, irow) -> {
            double d0 = values[0];
            double d1 = values[1];
            if (Double.isNaN(d0) != Double.isNaN(d1)) {
                context.error(new VotLintCode("XIN"), el.msg("One but not both point coordinate is NaN " + Arrays.toString(values), irow));
            } else if (Double.isInfinite(d0) || Double.isInfinite(d1)) {
                context.error(new VotLintCode("XIZ"), el.msg("Infinite point coordinate(s) " + Arrays.toString(values), irow));
            }
        });
    }

    private static ValueParser makeCircleParser(ReportElement el, String datatype) {
        return ValueParser.makeFloatingArrayParser(el, datatype, 3, (context, values, irow) -> {
            double c1 = values[0];
            double c2 = values[1];
            double r = values[2];
            if (Double.isNaN(c1) != Double.isNaN(c2) || Double.isNaN(c1) != Double.isNaN(r)) {
                context.error(new VotLintCode("XIN"), el.msg("Some but not all circle parameters are NaN " + Arrays.toString(values), irow));
            }
        });
    }

    private static ValueParser makePolygonParser(ReportElement el, String datatype, int nel) {
        return ValueParser.makeFloatingArrayParser(el, datatype, nel, (context, values, irow) -> {
            int ncoord = values.length;
            if (nel >= 0 && ncoord != nel) {
                context.error(new VotLintCode("E09"), el.msg("Wrong number of elements in array, " + ncoord + " found, " + nel + " expected", irow));
            } else if (ncoord % 2 != 0) {
                context.error(new VotLintCode("XSO"), el.msg("Odd number (" + ncoord + ") of polygon coords", irow));
            } else if (ncoord > 0 && ncoord < 6) {
                context.error(new VotLintCode("XSF"), el.msg("Too few (" + ncoord + ") polygon coords", irow));
            }
        });
    }

    private static ValueParser makeStringParser(ReportElement el, final int stringLeng, final StringChecker stringChecker) {
        return new AbstractParser(el, String.class, 1){

            @Override
            public void checkString(String txt, long irow) {
                stringChecker.check(this.getContext(), txt, irow);
            }

            @Override
            public void checkStream(InputStream in, long irow) throws IOException {
                int nchar = stringLeng >= 0 ? stringLeng : this.readCount(in);
                String txt = new String(this.readStreamBytes(in, nchar), StandardCharsets.UTF_8);
                stringChecker.check(this.getContext(), txt, irow);
            }
        };
    }

    private static ValueParser makeFloatingArrayParser(ReportElement el, final String datatype, final int nel, final DoubleArrayChecker arrayChecker) {
        FloatReader floatReader;
        Class<float[]> aclazz;
        if ("float".equals(datatype)) {
            aclazz = float[].class;
            int elSize = 4;
            floatReader = DataInput::readFloat;
        } else if ("double".equals(datatype)) {
            aclazz = double[].class;
            int elSize = 8;
            floatReader = DataInput::readDouble;
        } else {
            throw new AssertionError((Object)("datatype? " + datatype));
        }
        return new AbstractParser(el, aclazz, nel >= 0 ? nel : -1){

            @Override
            public void checkString(String text, long irow) {
                double[] values = this.readString(text, irow);
                if (values != null) {
                    VotLintContext context = this.getContext();
                    if (nel >= 0 && values.length != nel) {
                        this.error(new VotLintCode("E08"), "Wrong number of elements in array, " + values.length + " found, " + nel + " expected", irow);
                    } else {
                        arrayChecker.check(context, values, irow);
                    }
                }
            }

            @Override
            public void checkStream(InputStream in, long irow) throws IOException {
                double[] values = this.readStream(in);
                if (values != null) {
                    assert (nel < 0 || values.length == nel);
                    arrayChecker.check(this.getContext(), values, irow);
                }
            }

            private double[] readString(String text, long irow) {
                String[] sitems = text.trim().split("\\s+");
                int n = sitems.length;
                double[] ditems = new double[n];
                for (int i = 0; i < n; ++i) {
                    double ditem;
                    String sitem = sitems[i];
                    if ("NaN".equals(sitem)) {
                        ditem = Double.NaN;
                    } else if ("+Inf".equals(sitem)) {
                        ditem = Double.POSITIVE_INFINITY;
                    } else if ("-Inf".equals(sitem)) {
                        ditem = Double.NEGATIVE_INFINITY;
                    } else {
                        Matcher matcher = DOUBLE_REGEX.matcher(sitem);
                        if (matcher.matches()) {
                            try {
                                ditem = Double.parseDouble(sitem);
                            }
                            catch (NumberFormatException e) {
                                this.error(new VotLintCode("FPX"), "Unexpected bad " + datatype + " string '" + sitem + "'", irow);
                                return null;
                            }
                        } else {
                            this.error(new VotLintCode("FP0"), "Bad " + datatype + " string '" + sitem + "'", irow);
                            return null;
                        }
                    }
                    ditems[i] = ditem;
                }
                return ditems;
            }

            private double[] readStream(InputStream in) throws IOException {
                int nitem = nel >= 0 ? nel : this.readCount(in);
                DataInputStream dataIn = new DataInputStream(in);
                double[] ditems = new double[nitem];
                for (int i = 0; i < nitem; ++i) {
                    ditems[i] = floatReader.readDouble(dataIn);
                }
                return ditems;
            }
        };
    }

    void slurpStream(InputStream in, int nbyte) throws IOException {
        ValueParser.slurpStream(in, nbyte, this.getContext());
    }

    byte[] readStreamBytes(InputStream in, int nbyte) throws IOException {
        return ValueParser.readStreamBytes(in, nbyte, this.getContext());
    }

    public static void slurpStream(InputStream in, int nbyte, VotLintContext context) throws IOException {
        for (int i = 0; i < nbyte; ++i) {
            if (in.read() >= 0) continue;
            context.error(new VotLintCode("EOF"), "Stream ended during data read; done " + i + "/" + nbyte);
            throw new EOFException();
        }
    }

    public static byte[] readStreamBytes(InputStream in, int nbyte, VotLintContext context) throws IOException {
        int nr;
        byte[] buf = new byte[nbyte];
        for (int ip = 0; ip < nbyte; ip += nr) {
            nr = in.read(buf, ip, nbyte - ip);
            if (nr >= 0) continue;
            context.error(new VotLintCode("EOF"), "Scream ended during data read; done " + ip + "/" + nbyte);
            throw new EOFException();
        }
        return buf;
    }

    int readCount(InputStream in) throws IOException {
        int c1 = in.read();
        int c2 = in.read();
        int c3 = in.read();
        int c4 = in.read();
        if (c1 < 0 || c2 < 0 || c3 < 0 || c4 < 0) {
            this.error(new VotLintCode("EOF"), "End of stream while reading element count (probable stream corruption)", -1L);
            throw new EOFException();
        }
        int count = (c1 & 0xFF) << 24 | (c2 & 0xFF) << 16 | (c3 & 0xFF) << 8 | (c4 & 0xFF) << 0;
        if (count < 0) {
            this.error(new VotLintCode("MEL"), "Apparent negative element count (probably stream corruption)", -1L);
            throw new IOException("Unrecoverable stream error");
        }
        return count;
    }

    private static Class<?> getArrayClass(Class<?> wclazz) {
        if (wclazz == Boolean.class) {
            return boolean[].class;
        }
        if (wclazz == Character.class) {
            return char[].class;
        }
        if (wclazz == Byte.class) {
            return byte[].class;
        }
        if (wclazz == Short.class) {
            return short[].class;
        }
        if (wclazz == Integer.class) {
            return int[].class;
        }
        if (wclazz == Long.class) {
            return long[].class;
        }
        if (wclazz == Float.class) {
            return float[].class;
        }
        if (wclazz == Double.class) {
            return double[].class;
        }
        assert (false);
        return Array.newInstance(wclazz, 0).getClass();
    }

    private static class ReportElement {
        final ElementHandler handler_;
        final String name_;

        ReportElement(ElementHandler handler, String name) {
            this.handler_ = handler;
            this.name_ = name;
        }

        ReportElement() {
            this(null, null);
        }

        String msg(String txt, long irow) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(txt);
            if (this.handler_ != null || this.name_ != null) {
                sbuf.append(" (");
                if (irow < 0L && this.handler_ != null) {
                    sbuf.append(this.handler_.toString()).append(' ');
                }
                if (this.name_ != null) {
                    sbuf.append(this.name_);
                }
                if (irow >= 0L) {
                    sbuf.append(" row ").append(irow + 1L);
                }
                sbuf.append(')');
            }
            return sbuf.toString();
        }

        String msg(String txt) {
            return this.msg(txt, -1L);
        }
    }

    private static class FixedCharArrayParser
    extends AbstractParser {
        final boolean ascii_;
        final int nchar_;

        FixedCharArrayParser(ReportElement el, boolean ascii, int nchar, int stringLeng) {
            super(el, String[].class, nchar / stringLeng);
            this.ascii_ = ascii;
            this.nchar_ = nchar;
        }

        @Override
        public void checkStream(InputStream in, long irow) throws IOException {
            this.slurpStream(in, this.nchar_ * (this.ascii_ ? 1 : 2));
        }

        @Override
        public void checkString(String text, long irow) {
            int leng = text.length();
            if (text.length() != this.nchar_) {
                this.warning(new VotLintCode("C09"), "Wrong number of characters in string (" + leng + " found, " + this.nchar_ + " expected)", irow);
            }
        }
    }

    private static class VariableCharArrayParser
    extends AbstractParser {
        final boolean ascii_;

        VariableCharArrayParser(ReportElement el, boolean ascii) {
            super(el, String[].class, -1);
            this.ascii_ = ascii;
        }

        @Override
        public void checkStream(InputStream in, long irow) throws IOException {
            this.slurpStream(in, this.readCount(in) * (this.ascii_ ? 1 : 2));
        }

        @Override
        public void checkString(String text, long irow) {
        }
    }

    private static class VariableCharParser
    extends AbstractParser {
        final boolean ascii_;

        VariableCharParser(ReportElement el, boolean ascii) {
            super(el, String.class, 1);
            this.ascii_ = ascii;
        }

        @Override
        public void checkString(String text, long irow) {
        }

        @Override
        public void checkStream(InputStream in, long irow) throws IOException {
            this.slurpStream(in, this.readCount(in) * (this.ascii_ ? 1 : 2));
        }
    }

    private static class FixedCharParser
    extends SlurpParser {
        public FixedCharParser(ReportElement el, boolean ascii, int count) {
            super(el, count * (ascii ? 1 : 2), String.class, 1);
        }

        @Override
        public void checkString(String text, long irow) {
        }
    }

    private static class SingleCharParser
    extends SlurpParser {
        private final boolean ascii_;

        public SingleCharParser(ReportElement el, boolean ascii) {
            super(el, ascii ? 1 : 2, Character.class, 1);
            this.ascii_ = ascii;
        }

        @Override
        public void checkString(String text, long irow) {
            int leng = text.length();
            switch (leng) {
                case 0: {
                    this.warning(new VotLintCode("CH0"), "Empty character value is questionable", irow);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    this.warning(new VotLintCode("CH1"), "Characters after first in char scalar ignored - missing arraysize?", irow);
                }
            }
            if (this.ascii_ && leng > 0 && text.charAt(0) > '\u007f') {
                this.error(new VotLintCode("CRU"), "Non-ascii character in 'char' data", irow);
            }
        }
    }

    private static class VariableBitParser
    extends AbstractParser {
        public VariableBitParser(ReportElement el) {
            super(el, boolean[].class, -1);
        }

        @Override
        public void checkString(String text, long irow) {
            int leng = text.length();
            block3: for (int i = 0; i < leng; ++i) {
                switch (text.charAt(i)) {
                    case '\n': 
                    case ' ': 
                    case '0': 
                    case '1': {
                        continue block3;
                    }
                    default: {
                        this.error(new VotLintCode("BV0"), "Bad value for bit vector " + text, irow);
                        return;
                    }
                }
            }
        }

        @Override
        public void checkStream(InputStream in, long irow) throws IOException {
            this.slurpStream(in, (1 + this.readCount(in)) / 8);
        }
    }

    private static class FixedBitParser
    extends SlurpParser {
        final int count_;

        FixedBitParser(ReportElement el, int count) {
            super(el, (count + 7) / 8, Boolean.class, count);
            this.count_ = count;
        }

        @Override
        public void checkString(String text, long irow) {
            int leng = text.length();
            int nbit = 0;
            block4: for (int i = 0; i < leng; ++i) {
                switch (text.charAt(i)) {
                    case '0': 
                    case '1': {
                        ++nbit;
                        continue block4;
                    }
                    case '\n': 
                    case ' ': {
                        continue block4;
                    }
                    default: {
                        this.error(new VotLintCode("BT0"), "Bad value for bit vector " + text, irow);
                        return;
                    }
                }
            }
            if (nbit != this.count_) {
                this.error(new VotLintCode("CT9"), "Wrong number of elements in array (" + nbit + " found, " + this.count_ + " expected)", irow);
            }
        }
    }

    private static class DoubleParser
    extends SlurpParser {
        DoubleParser(ReportElement el) {
            super(el, 8, Double.class, 1);
        }

        @Override
        public void checkString(String text, long irow) {
            if ("NaN".equals(text = text.trim()) || "+Inf".equals(text) || "-Inf".equals(text) || text.length() == 0) {
                return;
            }
            Matcher matcher = DOUBLE_REGEX.matcher(text);
            if (!matcher.matches()) {
                this.error(new VotLintCode("FP0"), "Bad double string '" + text + "'", irow);
            }
        }
    }

    private static class FloatParser
    extends SlurpParser {
        FloatParser(ReportElement el) {
            super(el, 4, Float.class, 1);
        }

        @Override
        public void checkString(String text, long irow) {
            if ("NaN".equals(text = text.trim()) || "+Inf".equals(text) || "-Inf".equals(text) || text.length() == 0) {
                return;
            }
            Matcher matcher = DOUBLE_REGEX.matcher(text);
            if (!matcher.matches()) {
                this.error(new VotLintCode("FP0"), "Bad float string '" + text + "'", irow);
            }
        }
    }

    private static class IntegerParser
    extends SlurpParser {
        final long minVal_;
        final long maxVal_;

        IntegerParser(ReportElement el, int nbyte, long minVal, long maxVal, Class<?> clazz) {
            super(el, nbyte, clazz, 1);
            this.minVal_ = minVal;
            this.maxVal_ = maxVal;
        }

        @Override
        public void checkString(String text, long irow) {
            long value;
            int pos;
            int leng = text.length();
            for (pos = 0; pos < leng && text.charAt(pos) == ' '; ++pos) {
            }
            if (leng - pos > 1 && text.charAt(pos + 1) == 'x' && text.charAt(pos) == '0') {
                try {
                    value = Long.parseLong(text.substring(pos + 2), 16);
                }
                catch (NumberFormatException e) {
                    this.error(new VotLintCode("HX0"), "Bad hexadecimal string '" + text + "'", irow);
                    return;
                }
            }
            if (text.length() == 0) {
                if (!this.getContext().getVersion().allowEmptyTd()) {
                    this.error(new VotLintCode("ETD"), "Empty cell illegal for integer value", irow);
                }
                return;
            }
            try {
                value = Long.parseLong(text);
            }
            catch (NumberFormatException e) {
                this.error(new VotLintCode("IT0"), "Bad integer string '" + text + "'", irow);
                return;
            }
            if (value < this.minVal_ || value > this.maxVal_) {
                this.error(new VotLintCode("BND"), "Value " + text + " outside type range " + this.minVal_ + "..." + this.maxVal_, irow);
            }
        }
    }

    private static class BooleanParser
    extends AbstractParser {
        public BooleanParser(ReportElement el) {
            super(el, Boolean.class, 1);
        }

        @Override
        public void checkString(String text, long irow) {
            int leng = text.length();
            if (leng == 0) {
                return;
            }
            if (leng == 1) {
                switch (text.charAt(0)) {
                    case '\u0000': 
                    case ' ': 
                    case '0': 
                    case '1': 
                    case '?': 
                    case 'F': 
                    case 'T': 
                    case 'f': 
                    case 't': {
                        return;
                    }
                }
                this.error(new VotLintCode("TFX"), "Bad boolean value '" + text + "'", irow);
            } else {
                if (text.equalsIgnoreCase("true") || text.equalsIgnoreCase("false")) {
                    return;
                }
                this.error(new VotLintCode("TFX"), "Bad boolean value '" + text + "'", irow);
            }
        }

        @Override
        public void checkStream(InputStream in, long irow) throws IOException {
            char chr = (char)(0xFFFF & in.read());
            switch (chr) {
                case '\u0000': 
                case ' ': 
                case '0': 
                case '1': 
                case '?': 
                case 'F': 
                case 'T': 
                case 'f': 
                case 't': {
                    return;
                }
                case '\uffff': {
                    this.error(new VotLintCode("EOF"), "End of stream during read", irow);
                    throw new EOFException();
                }
            }
            this.error(new VotLintCode("TFX"), "Bad boolean value '" + chr + "'", irow);
        }
    }

    private static class VariableArrayParser
    extends AbstractParser {
        final ValueParser base_;

        VariableArrayParser(ReportElement el, ValueParser base, Class<?> clazz) {
            super(el, clazz, -1);
            this.base_ = base;
            this.base_.toString();
        }

        @Override
        public VotLintContext getContext() {
            return this.base_.getContext();
        }

        @Override
        public void setContext(VotLintContext context) {
            this.base_.setContext(context);
        }

        @Override
        public void checkString(String text, long irow) {
            StringTokenizer stok = new StringTokenizer(text);
            while (stok.hasMoreTokens()) {
                this.base_.checkString(stok.nextToken(), irow);
            }
        }

        @Override
        public void checkStream(InputStream in, long irow) throws IOException {
            int count = this.readCount(in);
            for (int i = 0; i < count; ++i) {
                try {
                    this.base_.checkStream(in, irow);
                    continue;
                }
                catch (EOFException e) {
                    this.error(new VotLintCode("EOF"), "End of stream while reading " + count + " elements (probable stream corruption)", irow);
                    throw e;
                }
            }
        }
    }

    private static class FixedArrayParser
    extends AbstractParser {
        final ValueParser base_;
        final int count_;

        FixedArrayParser(ReportElement el, ValueParser base, Class<?> clazz, int count) {
            super(el, clazz, count);
            this.base_ = base;
            this.count_ = count;
            this.base_.toString();
        }

        @Override
        public VotLintContext getContext() {
            return this.base_.getContext();
        }

        @Override
        public void setContext(VotLintContext context) {
            this.base_.setContext(context);
        }

        @Override
        public void checkString(String text, long irow) {
            StringTokenizer stok = new StringTokenizer(text);
            int ntok = stok.countTokens();
            if (ntok != this.count_) {
                this.error(new VotLintCode("E09"), "Wrong number of elements in array, " + ntok + " found, " + this.count_ + " expected", irow);
            }
            while (stok.hasMoreTokens()) {
                this.base_.checkString(stok.nextToken(), irow);
            }
        }

        @Override
        public void checkStream(InputStream in, long irow) throws IOException {
            for (int i = 0; i < this.count_; ++i) {
                this.base_.checkStream(in, irow);
            }
        }
    }

    private static abstract class SlurpParser
    extends ValueParser {
        private final int nbyte_;
        private final Class<?> clazz_;
        private final int count_;

        SlurpParser(ReportElement el, int nbyte, Class<?> clazz, int count) {
            super(el);
            this.nbyte_ = nbyte;
            this.clazz_ = clazz;
            this.count_ = count;
        }

        @Override
        public Class<?> getContentClass() {
            return this.clazz_;
        }

        @Override
        public int getElementCount() {
            return this.count_;
        }

        @Override
        public void checkStream(InputStream in, long irow) throws IOException {
            this.slurpStream(in, this.nbyte_);
        }
    }

    private static abstract class AbstractParser
    extends ValueParser {
        private final Class<?> clazz_;
        private final int count_;

        public AbstractParser(ReportElement el, Class<?> clazz, int count) {
            super(el);
            this.clazz_ = clazz;
            this.count_ = count;
        }

        @Override
        public Class<?> getContentClass() {
            return this.clazz_;
        }

        @Override
        public int getElementCount() {
            return this.count_;
        }
    }

    @FunctionalInterface
    private static interface DoubleArrayChecker {
        public void check(VotLintContext var1, double[] var2, long var3);
    }

    @FunctionalInterface
    private static interface StringChecker {
        public void check(VotLintContext var1, String var2, long var3);
    }

    @FunctionalInterface
    private static interface FloatReader {
        public double readDouble(DataInput var1) throws IOException;
    }
}

