/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import uk.ac.starlink.ttools.votlint.AttributeChecker;
import uk.ac.starlink.ttools.votlint.ElementHandler;
import uk.ac.starlink.ttools.votlint.VotLintCode;
import uk.ac.starlink.ttools.votlint.VotLintContext;
import uk.ac.starlink.votable.VOTableVersion;

public class VersionChecker
implements AttributeChecker {
    @Override
    public void check(String value, ElementHandler handler) {
        VotLintContext context = handler.getContext();
        VOTableVersion statedVersion = (VOTableVersion)VOTableVersion.getKnownVersions().get(value);
        if (statedVersion == null) {
            context.warning(new VotLintCode("VR9"), "Unknown VOTable version: " + value);
        } else {
            VOTableVersion contextVersion = context.getVersion();
            if (!contextVersion.equals(statedVersion)) {
                context.warning(new VotLintCode("VRM"), "Declared version (" + statedVersion + ") differs from version specified to linter (" + contextVersion + ")");
            }
        }
    }
}

