/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.ac.starlink.ttools.votlint.ArraysizeChecker;
import uk.ac.starlink.ttools.votlint.AttributeChecker;
import uk.ac.starlink.ttools.votlint.BinaryHandler;
import uk.ac.starlink.ttools.votlint.DataHandler;
import uk.ac.starlink.ttools.votlint.DeprecatedAttChecker;
import uk.ac.starlink.ttools.votlint.ElementHandler;
import uk.ac.starlink.ttools.votlint.FieldHandler;
import uk.ac.starlink.ttools.votlint.FitsHandler;
import uk.ac.starlink.ttools.votlint.IDChecker;
import uk.ac.starlink.ttools.votlint.NameChecker;
import uk.ac.starlink.ttools.votlint.ParamHandler;
import uk.ac.starlink.ttools.votlint.RefChecker;
import uk.ac.starlink.ttools.votlint.StreamHandler;
import uk.ac.starlink.ttools.votlint.TableHandler;
import uk.ac.starlink.ttools.votlint.TdHandler;
import uk.ac.starlink.ttools.votlint.TrHandler;
import uk.ac.starlink.ttools.votlint.UcdChecker;
import uk.ac.starlink.ttools.votlint.UnitChecker;
import uk.ac.starlink.ttools.votlint.VersionChecker;
import uk.ac.starlink.ttools.votlint.VocabAttributeChecker;
import uk.ac.starlink.ttools.votlint.VocabChecker;
import uk.ac.starlink.ttools.votlint.VotLintCode;
import uk.ac.starlink.ttools.votlint.VotLintContext;
import uk.ac.starlink.votable.VOTableVersion;

public abstract class VersionDetail {
    private final VOTableVersion version_;
    private final Map<String, Map<String, AttributeChecker>> checkersMap_;
    private static final VersionDetail V10;
    private static final VersionDetail V11;
    private static final VersionDetail V12;
    private static final VersionDetail V13;
    private static final VersionDetail V14;
    private static final VersionDetail V15;
    private static final VersionDetail DUMMY;
    private static final Map<VOTableVersion, VersionDetail> VERSION_MAP;

    protected VersionDetail(VOTableVersion version) {
        this.version_ = version;
        this.checkersMap_ = new HashMap<String, Map<String, AttributeChecker>>();
    }

    public Map<String, AttributeChecker> getAttributeCheckers(String voTagname) {
        if (!this.checkersMap_.containsKey(voTagname)) {
            this.checkersMap_.put(voTagname, this.createAttributeCheckers(voTagname));
        }
        return this.checkersMap_.get(voTagname);
    }

    public ElementHandler createElementHandler(String voTagname, VotLintContext context) {
        if (voTagname == null) {
            throw new NullPointerException();
        }
        ElementHandler handler = this.createElementHandler(voTagname);
        if (handler == null) {
            if (!context.isValidating()) {
                context.error(new VotLintCode("VBE"), "Element " + voTagname + " not known at VOTable " + this.version_);
            }
            handler = new ElementHandler();
        }
        handler.configure(voTagname, context);
        return handler;
    }

    protected abstract ElementHandler createElementHandler(String var1);

    protected abstract Map<String, AttributeChecker> createAttributeCheckers(String var1);

    public static VersionDetail getInstance(VotLintContext context) {
        VOTableVersion version = context.getVersion();
        if (VERSION_MAP.containsKey(version)) {
            return VERSION_MAP.get(version);
        }
        context.warning(new VotLintCode("UKV"), "No checking information available for version " + version);
        return DUMMY;
    }

    private static Map<VOTableVersion, VersionDetail> createMap(VersionDetail[] vds) {
        LinkedHashMap<VOTableVersion, VersionDetail> map = new LinkedHashMap<VOTableVersion, VersionDetail>();
        for (int i = 0; i < vds.length; ++i) {
            map.put(vds[i].version_, vds[i]);
        }
        return map;
    }

    static {
        DUMMY = new DummyVersionDetail();
        V10 = new VersionDetail10(VOTableVersion.V10);
        V11 = new VersionDetail11(VOTableVersion.V11);
        V12 = new VersionDetail12(VOTableVersion.V12);
        V13 = new VersionDetail13(VOTableVersion.V13);
        V14 = new VersionDetail14(VOTableVersion.V14);
        V15 = new VersionDetail15(VOTableVersion.V15);
        VERSION_MAP = VersionDetail.createMap(new VersionDetail[]{V10, V11, V12, V13, V14, V15});
    }

    private static class DummyVersionDetail
    extends VersionDetail {
        DummyVersionDetail() {
            super(null);
        }

        @Override
        protected ElementHandler createElementHandler(String voTagName) {
            return new ElementHandler();
        }

        @Override
        protected Map<String, AttributeChecker> createAttributeCheckers(String name) {
            return new HashMap<String, AttributeChecker>();
        }
    }

    private static class VersionDetail15
    extends VersionDetail {
        VersionDetail15(VOTableVersion version) {
            super(version);
        }

        @Override
        protected ElementHandler createElementHandler(String name) {
            return V14.createElementHandler(name);
        }

        @Override
        protected Map<String, AttributeChecker> createAttributeCheckers(String name) {
            Map<String, AttributeChecker> map = V14.createAttributeCheckers(name);
            if ("COOSYS".equals(name)) {
                map.put("system", new VocabAttributeChecker(VocabChecker.REFFRAME));
                map.put("refposition", new VocabAttributeChecker(VocabChecker.REFPOSITION));
            }
            return map;
        }
    }

    private static class VersionDetail14
    extends VersionDetail {
        VersionDetail14(VOTableVersion version) {
            super(version);
        }

        @Override
        protected ElementHandler createElementHandler(String name) {
            return V13.createElementHandler(name);
        }

        @Override
        protected Map<String, AttributeChecker> createAttributeCheckers(String name) {
            return V13.createAttributeCheckers(name);
        }
    }

    private static class VersionDetail13
    extends VersionDetail {
        VersionDetail13(VOTableVersion version) {
            super(version);
        }

        @Override
        protected ElementHandler createElementHandler(String name) {
            if ("TD".equals(name)) {
                return new TdHandler(true);
            }
            ElementHandler handler = V11.createElementHandler(name);
            if (handler != null) {
                return handler;
            }
            if ("BINARY2".equals(name)) {
                return new BinaryHandler(true);
            }
            return null;
        }

        @Override
        protected Map<String, AttributeChecker> createAttributeCheckers(String name) {
            Map<String, AttributeChecker> map = V12.createAttributeCheckers(name);
            if ("FIELD".equals(name) || "PARAM".equals(name)) {
                map.put("arraysize", new ArraysizeChecker());
            }
            return map;
        }
    }

    private static class VersionDetail12
    extends VersionDetail {
        VersionDetail12(VOTableVersion version) {
            super(version);
        }

        @Override
        protected ElementHandler createElementHandler(String name) {
            if ("COOSYS".equals(name)) {
                return new ElementHandler(){

                    @Override
                    public void startElement() {
                        super.startElement();
                        this.info(new VotLintCode("CD2"), "COOSYS is deprecated at VOTable 1.2 (though reprieved at 1.3)");
                    }
                };
            }
            return V11.createElementHandler(name);
        }

        @Override
        protected Map<String, AttributeChecker> createAttributeCheckers(String name) {
            Map<String, AttributeChecker> map = V11.createAttributeCheckers(name);
            if ("GROUP".equals(name)) {
                map.put("ref", new RefChecker(new String[]{"GROUP", "COOSYS", "TABLE"}));
                map.put("ucd", UcdChecker.INSTANCE);
            }
            return map;
        }
    }

    private static class VersionDetail11
    extends VersionDetail {
        VersionDetail11(VOTableVersion version) {
            super(version);
        }

        @Override
        protected ElementHandler createElementHandler(String name) {
            ElementHandler handler = V10.createElementHandler(name);
            if (handler != null) {
                return handler;
            }
            if ("GROUP".equals(name) || "FIELDref".equals(name) || "PARAMref".equals(name)) {
                return new ElementHandler();
            }
            return null;
        }

        @Override
        protected Map<String, AttributeChecker> createAttributeCheckers(String name) {
            Map<String, AttributeChecker> map = V10.createAttributeCheckers(name);
            if ("LINK".equals(name)) {
                map.put("gref", new DeprecatedAttChecker("gref"));
            } else if ("FIELDref".equals(name)) {
                map.put("ref", new RefChecker("FIELD"));
                map.put("ucd", UcdChecker.INSTANCE);
            } else if ("GROUP".equals(name)) {
                map.put("ref", new RefChecker(new String[]{"GROUP", "COOSYS"}));
                map.put("ID", new IDChecker());
                map.put("name", new NameChecker());
            } else if ("PARAMref".equals(name)) {
                map.put("ref", new RefChecker("PARAM"));
                map.put("ucd", UcdChecker.INSTANCE);
            }
            return map;
        }
    }

    private static class VersionDetail10
    extends VersionDetail {
        VersionDetail10(VOTableVersion version) {
            super(version);
        }

        @Override
        protected ElementHandler createElementHandler(String name) {
            if ("TABLE".equals(name)) {
                return new TableHandler();
            }
            if ("PARAM".equals(name)) {
                return new ParamHandler();
            }
            if ("FIELD".equals(name)) {
                return new FieldHandler();
            }
            if ("DATA".equals(name)) {
                return new DataHandler();
            }
            if ("TR".equals(name)) {
                return new TrHandler();
            }
            if ("TD".equals(name)) {
                return new TdHandler(false);
            }
            if ("STREAM".equals(name)) {
                return new StreamHandler();
            }
            if ("BINARY".equals(name)) {
                return new BinaryHandler(false);
            }
            if ("FITS".equals(name)) {
                return new FitsHandler();
            }
            if ("VOTABLE".equals(name) || "RESOURCE".equals(name) || "DESCRIPTION".equals(name) || "DEFINITIONS".equals(name) || "INFO".equals(name) || "VALUES".equals(name) || "MIN".equals(name) || "MAX".equals(name) || "OPTION".equals(name) || "LINK".equals(name) || "TABLEDATA".equals(name) || "COOSYS".equals(name)) {
                return new ElementHandler();
            }
            return null;
        }

        @Override
        protected Map<String, AttributeChecker> createAttributeCheckers(String name) {
            HashMap<String, AttributeChecker> map = new HashMap<String, AttributeChecker>();
            boolean hasID = false;
            boolean hasName = false;
            if (name == null) {
                throw new NullPointerException();
            }
            if (!"BINARY".equals(name)) {
                if ("COOSYS".equals(name)) {
                    hasID = true;
                } else if (!("DATA".equals(name) || "DEFINITIONS".equals(name) || "DESCRIPTION".equals(name))) {
                    if ("FIELD".equals(name)) {
                        hasID = true;
                        hasName = true;
                        map.put("ref", new RefChecker(new String[]{"COOSYS", "TIMESYS", "GROUP"}));
                        map.put("ucd", UcdChecker.INSTANCE);
                        map.put("unit", UnitChecker.INSTANCE);
                    } else if (!"FITS".equals(name)) {
                        if ("INFO".equals(name)) {
                            hasID = true;
                            map.put("ucd", UcdChecker.INSTANCE);
                            map.put("unit", UnitChecker.INSTANCE);
                        } else if ("LINK".equals(name)) {
                            hasID = true;
                        } else if (!"MAX".equals(name) && !"MIN".equals(name)) {
                            if ("OPTION".equals(name)) {
                                hasName = true;
                            } else if ("PARAM".equals(name)) {
                                hasID = true;
                                hasName = true;
                                map.put("value", new ParamHandler.ValueChecker());
                                map.put("ref", new RefChecker(new String[]{"COOSYS", "TIMESYS", "FIELD", "GROUP"}));
                                map.put("ucd", UcdChecker.INSTANCE);
                                map.put("unit", UnitChecker.INSTANCE);
                            } else if ("RESOURCE".equals(name)) {
                                hasID = true;
                                hasName = true;
                            } else if (!"STREAM".equals(name)) {
                                if ("TABLE".equals(name)) {
                                    hasID = true;
                                    hasName = true;
                                    map.put("ref", new RefChecker("TABLE"));
                                    map.put("nrows", new TableHandler.NrowsChecker());
                                    map.put("ucd", UcdChecker.INSTANCE);
                                } else if (!"TABLEDATA".equals(name)) {
                                    if ("TD".equals(name)) {
                                        map.put("ref", new RefChecker(new String[0]));
                                    } else if ("TIMESYS".equals(name)) {
                                        hasID = true;
                                        map.put("timescale", new VocabAttributeChecker(VocabChecker.TIMESCALE));
                                        map.put("refposition", new VocabAttributeChecker(VocabChecker.REFPOSITION));
                                    } else if (!"TR".equals(name)) {
                                        if ("VALUES".equals(name)) {
                                            hasID = true;
                                        } else if ("VOTABLE".equals(name)) {
                                            hasID = true;
                                            map.put("version", new VersionChecker());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (hasID) {
                map.put("ID", new IDChecker());
            }
            if (hasName) {
                map.put("name", new NameChecker());
            }
            return map;
        }
    }
}

