/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.vo.VocabTerm;
import uk.ac.starlink.vo.Vocabulary;

public class VocabChecker {
    private final URL vocabUrl_;
    private final String vocabUri_;
    private final Collection<String> fixedTerms_;
    private Map<String, VocabTerm> retrievedTerms_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.votlint");
    public static final VocabChecker TIMESCALE = new VocabChecker("http://www.ivoa.net/rdf/timescale", new String[]{"TAI", "TT", "UT", "UTC", "GPS", "TCG", "TCB", "TDB", "UNKNOWN"});
    public static final VocabChecker REFPOSITION = new VocabChecker("http://www.ivoa.net/rdf/refposition", new String[]{"TOPOCENTER", "GEOCENTER", "BARYCENTER", "HELIOCENTER", "EMBARYCENTER", "UNKNOWN"});
    public static final VocabChecker REFFRAME = new VocabChecker("http://www.ivoa.net/rdf/refframe", new String[]{"AZ_EL", "BODY", "ecl_FK4", "ECLIPTIC", "EQUATORIAL", "FK4", "FK5", "GALACTIC", "GALACTIC_I", "GENERIC_GALACTIC", "ICRS", "SUPER_GALACTIC", "UNKNOWN"});
    public static final VocabChecker DATALINK_CORE = new VocabChecker("http://www.ivoa.net/rdf/datalink/core", new String[]{"auxiliary", "bias", "calibration", "coderived", "counterpart", "cutout", "dark", "derivation", "detached-header", "documentation", "error", "flat", "noise", "package", "preview", "preview-image", "preview-plot", "proc", "progenitor", "this", "thumbnail", "weight"});
    public static final VocabChecker PRODUCT_TYPE = new VocabChecker("http://www.ivoa.net/rdf/product-type", new String[]{"cube", "dynamic-spectrum", "event-list", "image", "light-curve", "measurements", "polarization-cube", "polarization-resolved-dataset", "polarized-spectrum", "sed", "slit-spectrum", "spatially-resolved-dataset", "spatial-profile", "spectral-cube", "spectrally-resolved-dataset", "spectrum", "temporally-resolved-dataset", "time-cube", "timeseries", "velocity-curve", "visibility"});
    public static final VocabChecker EXAMPLES = new VocabChecker("http://www.ivoa.net/rdf/examples", new String[]{"capability", "continuation", "generic-parameter", "key", "name", "query", "table", "value"});
    public static final VocabChecker MESSENGER = new VocabChecker("http://www.ivoa.net/rdf/messenger", new String[]{"EUV", "Gamma-ray", "Infrared", "Millimeter", "Neutrino", "Optical", "Photon", "Radio", "UV", "X-ray"});
    private static final VocabChecker[] INSTANCES = new VocabChecker[]{TIMESCALE, REFPOSITION, REFFRAME, DATALINK_CORE, PRODUCT_TYPE, EXAMPLES, MESSENGER};

    public VocabChecker(String vocabUrl, String[] fixedTerms) {
        try {
            this.vocabUrl_ = URLUtils.newURL((String)vocabUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Not a URL: " + vocabUrl);
        }
        this.vocabUri_ = vocabUrl;
        this.fixedTerms_ = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(fixedTerms)));
    }

    public void checkTerm(String value, TermReporter termReporter) {
        if (this.fixedTerms_.contains(value)) {
            termReporter.termFound();
        } else {
            VocabTerm term = this.getRetrievedTerms().get(value);
            if (term == null) {
                StringBuffer sbuf = new StringBuffer().append("\"").append(value).append("\"").append(" not known in vocabulary ").append(this.vocabUrl_).append(" (known:");
                TreeSet<String> terms = new TreeSet<String>();
                terms.addAll(this.fixedTerms_);
                terms.addAll(this.getRetrievedTerms().keySet());
                Iterator it = terms.iterator();
                while (it.hasNext()) {
                    sbuf.append(" ").append((String)it.next());
                    if (!it.hasNext()) continue;
                    sbuf.append(",");
                }
                sbuf.append(")");
                termReporter.termUnknown(sbuf.toString());
            } else if (term.isDeprecated()) {
                StringBuffer sbuf = new StringBuffer().append("\"").append(value).append("\"").append(" is marked *deprecated* in vocabulary ").append(this.vocabUrl_);
                String useInstead = term.getUseInstead();
                if (useInstead != null && useInstead.trim().length() > 0) {
                    sbuf.append("; use instead \"").append(useInstead).append("\"");
                }
                termReporter.termDeprecated(sbuf.toString());
            } else if (term.isPreliminary()) {
                String msg = new StringBuffer().append("\"").append(value).append("\"").append(" is marked *preliminary* in vocabulary ").append(this.vocabUrl_).toString();
                termReporter.termPreliminary(msg);
            } else {
                termReporter.termFound();
            }
        }
    }

    public URL getVocabularyUrl() {
        return this.vocabUrl_;
    }

    public String getVocabularyUri() {
        return this.vocabUri_;
    }

    public Collection<String> getFixedTerms() {
        return this.fixedTerms_;
    }

    public Map<String, VocabTerm> getRetrievedTerms() {
        if (this.retrievedTerms_ == null) {
            LinkedHashMap terms;
            try {
                terms = Vocabulary.readVocabulary((URL)this.vocabUrl_).getTerms();
                int nRead = terms.size();
                if (nRead > 0) {
                    terms = new LinkedHashMap(terms);
                    terms.keySet().removeAll(this.fixedTerms_);
                    int nNew = terms.size();
                    String msg = new StringBuffer().append("Read vocabulary from ").append(this.vocabUrl_).append(": ").append(nRead).append(" terms, ").append(nNew).append(" unknown").toString();
                    logger_.info(msg);
                } else {
                    logger_.warning("No terms read from vocabulary at " + this.vocabUrl_);
                }
            }
            catch (IOException e) {
                terms = Collections.emptyMap();
                logger_.log(Level.WARNING, "Unable to read vocabulary from " + this.vocabUrl_, e);
            }
            this.retrievedTerms_ = Collections.unmodifiableMap(terms);
        }
        return this.retrievedTerms_;
    }

    public String toString() {
        return this.getVocabularyUri();
    }

    public static void main(String[] args) throws IOException {
        for (VocabChecker checker : INSTANCES) {
            System.out.println(VocabChecker.checkFixedTerms(checker));
            System.out.println();
        }
    }

    private static String checkFixedTerms(VocabChecker checker) throws IOException {
        TreeSet<String> fixed = new TreeSet<String>(checker.getFixedTerms());
        TreeSet retrieved = new TreeSet(Vocabulary.readVocabulary((URL)checker.getVocabularyUrl()).getTerms().keySet());
        StringBuffer sbuf = new StringBuffer().append(checker).append(":").append("\n            fixed: ").append(fixed).append("\n        retrieved: ").append(retrieved);
        if (retrieved.equals(fixed)) {
            sbuf.append("\n    Up to date.");
        } else {
            TreeSet<String> fixedOnly = new TreeSet<String>((Collection<String>)fixed);
            TreeSet retrievedOnly = new TreeSet(retrieved);
            fixedOnly.removeAll(retrieved);
            retrievedOnly.removeAll(fixed);
            sbuf.append("\n       fixed only: ").append(fixedOnly).append("\n   retrieved only: ").append(retrievedOnly);
        }
        return sbuf.toString();
    }

    public static interface TermReporter {
        public void termFound();

        public void termUnknown(String var1);

        public void termDeprecated(String var1);

        public void termPreliminary(String var1);
    }
}

