/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import uk.ac.starlink.ttools.taplint.AdhocCode;
import uk.ac.starlink.ttools.votlint.AttributeChecker;
import uk.ac.starlink.ttools.votlint.ElementHandler;
import uk.ac.starlink.ttools.votlint.HandlerStack;
import uk.ac.starlink.ttools.votlint.VersionDetail;
import uk.ac.starlink.ttools.votlint.VotLintCode;
import uk.ac.starlink.ttools.votlint.VotLintContext;
import uk.ac.starlink.votable.VOTableVersion;

public class VotLintContentHandler
implements ContentHandler,
ErrorHandler {
    private final VotLintContext context_;
    private final VersionDetail versionDetail_;
    private final HandlerStack stack_;
    private final Set<String> namespaceSet_;
    private static final Pattern NS_PAT = VotLintContentHandler.getNamespaceNamePattern();
    private static final Set<String> VOTABLE_ELEMENTNAMES = VotLintContentHandler.createVOTableElementNames();
    private static final Map<String, String> EMPTY_MAP = Collections.unmodifiableMap(new HashMap());

    public VotLintContentHandler(VotLintContext context) {
        this.context_ = context;
        this.versionDetail_ = VersionDetail.getInstance(context);
        assert (this.versionDetail_ != null);
        this.stack_ = new HandlerStack();
        this.namespaceSet_ = new HashSet<String>();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.context_.setLocator(locator);
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
        this.context_.reportUncheckedRefs();
        this.context_.reportUnusedIds();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.context_.getNamespaceMap().put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) {
        this.context_.getNamespaceMap().remove(prefix);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        String declaredNamespace;
        int i;
        ElementHandler handler = this.versionDetail_.createElementHandler(localName, this.context_);
        this.stack_.push(handler);
        handler.setAncestry(this.stack_.getAncestry());
        int natt = atts.getLength();
        if (natt > 0) {
            HashMap<String, String> attMap = new HashMap<String, String>();
            for (i = 0; i < natt; ++i) {
                attMap.put(atts.getQName(i), atts.getValue(i));
            }
            handler.setAttributes(attMap);
        } else {
            handler.setAttributes(EMPTY_MAP);
        }
        Map<String, AttributeChecker> attCheckers = this.versionDetail_.getAttributeCheckers(localName);
        for (i = 0; i < natt; ++i) {
            AttributeChecker checker = attCheckers.get(atts.getQName(i));
            if (checker == null) continue;
            checker.check(atts.getValue(i), handler);
        }
        String string = declaredNamespace = namespaceURI.trim().length() == 0 ? null : namespaceURI;
        if (!this.namespaceSet_.contains(declaredNamespace)) {
            this.namespaceSet_.add(declaredNamespace);
            VOTableVersion contextVersion = this.context_.getVersion();
            String versionNamespace = contextVersion.getXmlNamespace();
            if (declaredNamespace == null) {
                if (versionNamespace != null) {
                    this.context_.warning(new VotLintCode("NS0"), "Element not namespaced, should be in " + versionNamespace);
                }
            } else if (!declaredNamespace.equals(versionNamespace)) {
                if (VotLintContentHandler.isVOTableElementName(localName)) {
                    this.context_.warning(new VotLintCode("NSX"), "VOTable Element " + localName + " in wrong namespace (" + declaredNamespace + " not " + versionNamespace + ")");
                } else {
                    this.context_.warning(new VotLintCode("NSF"), "Element " + localName + " in foreign namespace (" + declaredNamespace + ")");
                }
            }
        }
        handler.startElement();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        ElementHandler handler = this.stack_.top();
        handler.endElement();
        handler.setAncestry(null);
        this.stack_.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.stack_.top().characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
        this.context_.info(new VotLintCode("PIY"), "Ignoring processing instruction <?" + target + " " + data + "?>");
    }

    @Override
    public void skippedEntity(String name) {
        this.context_.info(new VotLintCode("ENY"), "Skipping entity " + name);
    }

    @Override
    public void warning(SAXParseException e) {
        String msg = e.getMessage();
        if (msg == null) {
            msg = e.toString();
        }
        this.context_.warning(this.createSaxCode(msg), msg);
    }

    @Override
    public void error(SAXParseException e) {
        if (!this.isNamespaceError(e)) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            this.context_.error(this.createSaxCode(msg), msg);
        }
    }

    @Override
    public void fatalError(SAXParseException e) {
        String msg = e.getMessage();
        if (msg == null) {
            msg = e.toString();
        }
        this.context_.error(this.createSaxCode(msg), msg);
    }

    private boolean isNamespaceError(SAXParseException e) {
        String msg = e.getMessage();
        if (msg != null) {
            if (msg.indexOf("xmlns") >= 0) {
                return true;
            }
            Matcher matcher = NS_PAT.matcher(msg);
            if (matcher.lookingAt()) {
                String prefix = matcher.group(1);
                String localName = matcher.group(2);
                if (prefix.toLowerCase().startsWith("xml")) {
                    return true;
                }
                if (this.context_.getNamespaceMap().containsKey(prefix)) {
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    private VotLintCode createSaxCode(String msg) {
        return new VotLintCode("J" + AdhocCode.createLabelChars(msg, 2));
    }

    private static Pattern getNamespaceNamePattern() {
        String charPat = "\\p{Lu}\\p{Ll}_";
        String startCharPat = charPat + "0-9\\-\\.";
        String pats = ".*?([" + startCharPat + "][" + charPat + "]*):([" + charPat + "]+)";
        return Pattern.compile(pats);
    }

    private static boolean isVOTableElementName(String localName) {
        return VOTABLE_ELEMENTNAMES.contains(localName);
    }

    private static Set<String> createVOTableElementNames() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("BINARY", "BINARY2", "COOSYS", "DATA", "DEFINITIONS", "DESCRIPTION", "FIELD", "FIELDref", "FITS", "GROUP", "GROUP", "INFO", "LINK", "MAX", "MIN", "OPTION", "PARAM", "PARAM", "PARAMref", "RESOURCE", "STREAM", "TABLE", "TABLEDATA", "TD", "TIMESYS", "TR", "VALUES", "VOTABLE")));
    }
}

