/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.ValidatorHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import uk.ac.starlink.ttools.votlint.FudgeNamespaceContentHandler;
import uk.ac.starlink.ttools.votlint.VotLintCode;
import uk.ac.starlink.ttools.votlint.VotLintContentHandler;
import uk.ac.starlink.ttools.votlint.VotLintContext;
import uk.ac.starlink.ttools.votlint.VotLintEntityResolver;
import uk.ac.starlink.util.MultiplexInvocationHandler;
import uk.ac.starlink.util.StarEntityResolver;
import uk.ac.starlink.votable.VOTableVersion;

public class VotLinter {
    private final VotLintContext context_;

    public VotLinter(VotLintContext context) {
        this.context_ = context;
    }

    public XMLReader createParser(ContentHandler userHandler) throws SAXException {
        XMLReader parser;
        boolean validate = this.context_.isValidating();
        VOTableVersion version = this.context_.getVersion();
        boolean hasDTD = version.getDoctypeDeclaration() != null;
        Schema schema = version.getSchema();
        assert (hasDTD ^ schema != null);
        try {
            SAXParserFactory spfact = SAXParserFactory.newInstance();
            spfact.setValidating(validate && hasDTD);
            spfact.setNamespaceAware(true);
            parser = spfact.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw (SAXException)new SAXException(e.getMessage()).initCause(e);
        }
        if (hasDTD) {
            VotLintEntityResolver entityResolver = new VotLintEntityResolver(this.context_);
            try {
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", entityResolver);
                parser.setEntityResolver(entityResolver);
            }
            catch (SAXException e) {
                parser.setEntityResolver((EntityResolver)StarEntityResolver.getInstance());
                this.context_.warning(new VotLintCode("DTE"), "Entity trouble - DTD validation may not be done properly (" + e + ")");
            }
        }
        ArrayList<ContentHandler> contentHandlers = new ArrayList<ContentHandler>();
        VotLintContentHandler lintHandler = new VotLintContentHandler(this.context_);
        contentHandlers.add(lintHandler);
        if (validate && schema != null) {
            ValidatorHandler validHandler = schema.newValidatorHandler();
            validHandler.setErrorHandler(lintHandler);
            FudgeNamespaceContentHandler fixValidHandler = new FudgeNamespaceContentHandler(validHandler, "VOTABLE", version.getXmlNamespace());
            contentHandlers.add(fixValidHandler);
        }
        if (userHandler != null) {
            contentHandlers.add(userHandler);
        }
        Object[] cHandlers = contentHandlers.toArray(new ContentHandler[0]);
        ContentHandler contentHandler = (ContentHandler)new MultiplexInvocationHandler(cHandlers).createMultiplexer(ContentHandler.class);
        parser.setContentHandler(contentHandler);
        parser.setErrorHandler(lintHandler);
        return parser;
    }
}

