/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RandomStarTable;

public class ConstantStarTable
extends RandomStarTable {
    private final ColumnInfo[] infos_;
    private final Object[] row_;
    private final long nrow_;

    public ConstantStarTable(ColumnInfo[] infos, Object[] cells, long nrow) {
        if (infos.length != cells.length) {
            throw new IllegalArgumentException("Multiplicity of cells and infos do not match");
        }
        this.infos_ = infos;
        this.row_ = cells;
        this.nrow_ = nrow;
    }

    @Override
    public int getColumnCount() {
        return this.infos_.length;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.infos_[icol];
    }

    @Override
    public long getRowCount() {
        return this.nrow_;
    }

    @Override
    public boolean isRandom() {
        return this.nrow_ >= 0L;
    }

    @Override
    public Object getCell(long lrow, int icol) {
        return this.row_[icol];
    }
}

