/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.util.function.DoubleFunction;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;

public class LoopStarTable
extends ColumnStarTable {
    private final long nrow_;

    public LoopStarTable(String colName, final double start, double end, final double step, Boolean isInteger) {
        DoubleFunction<Object> typedValue;
        Class clazz;
        long nrow;
        boolean isInt = isInteger == null ? start == (double)((long)start) && end == (double)((long)end) && step == (double)((long)step) : isInteger;
        String descrip = "Loop variable";
        if (isInt) {
            boolean is32bit;
            nrow = ((long)end - (long)start) / (long)step;
            boolean bl = is32bit = start == (double)((int)start) && end == (double)((int)end) && step == (double)((int)step);
            if (is32bit) {
                clazz = Integer.class;
                typedValue = dval -> (int)dval;
            } else {
                clazz = Long.class;
                typedValue = dval -> (long)dval;
            }
        } else {
            nrow = (long)Math.floor((end - start) / step);
            clazz = Double.class;
            typedValue = dval -> dval;
        }
        this.nrow_ = Math.max(0L, nrow);
        this.addColumn(new ColumnData(new ColumnInfo(colName, clazz, descrip)){

            @Override
            public Object readValue(long irow) {
                return typedValue.apply(start + (double)irow * step);
            }
        });
    }

    @Override
    public long getRowCount() {
        return this.nrow_;
    }
}

