/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.util.BitSet;
import uk.ac.starlink.table.ArrayColumn;
import uk.ac.starlink.table.ColumnInfo;

public abstract class PrimitiveArrayColumn
extends ArrayColumn {
    private final Object data;
    private boolean trueMeansNull = true;
    private final BitSet flags = new BitSet();

    private PrimitiveArrayColumn(ColumnInfo base, Object data) {
        super(base, data);
        this.data = data;
    }

    @Override
    protected void storeValue(int irow, Object val) {
        if (val == null) {
            this.flags.set(irow, this.trueMeansNull);
        } else {
            this.flags.set(irow, !this.trueMeansNull);
            this.storeElement(irow, val);
        }
    }

    @Override
    protected Object readValue(int irow) {
        return this.flags.get(irow) == this.trueMeansNull ? null : this.readElement(irow);
    }

    public void setAllNulls() {
        this.trueMeansNull = false;
        this.flags.clear();
    }

    public void setNoNulls() {
        this.trueMeansNull = true;
        this.flags.clear();
    }

    abstract void storeElement(int var1, Object var2);

    abstract Object readElement(int var1);

    public static PrimitiveArrayColumn makePrimitiveColumn(ColumnInfo base, Object data) {
        Class<?> clazz = data.getClass();
        if (clazz == boolean[].class) {
            return new BooleanArrayColumn(base, (boolean[])data);
        }
        if (clazz == char[].class) {
            return new CharacterArrayColumn(base, (char[])data);
        }
        if (clazz == byte[].class) {
            return new ByteArrayColumn(base, (byte[])data);
        }
        if (clazz == short[].class) {
            return new ShortArrayColumn(base, (short[])data);
        }
        if (clazz == int[].class) {
            return new IntegerArrayColumn(base, (int[])data);
        }
        if (clazz == long[].class) {
            return new LongArrayColumn(base, (long[])data);
        }
        if (clazz == float[].class) {
            return new FloatArrayColumn(base, (float[])data);
        }
        if (clazz == double[].class) {
            return new DoubleArrayColumn(base, (double[])data);
        }
        throw new IllegalArgumentException("Data object is not an array of primitives  (it's a " + clazz.getName() + ")");
    }

    public static PrimitiveArrayColumn makePrimitiveColumn(ColumnInfo base, long rowCount) {
        if (rowCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many rows requested: " + rowCount + " > Integer.MAX_VALUE");
        }
        int nrow = (int)rowCount;
        assert ((long)nrow == rowCount);
        Class<?> clazz = base.getContentClass();
        if (clazz == null) {
            throw new IllegalArgumentException("No class defined");
        }
        if (clazz == Boolean.class) {
            return new BooleanArrayColumn(base, new boolean[nrow]);
        }
        if (clazz == Character.class) {
            return new CharacterArrayColumn(base, new char[nrow]);
        }
        if (clazz == Byte.class) {
            return new ByteArrayColumn(base, new byte[nrow]);
        }
        if (clazz == Short.class) {
            return new ShortArrayColumn(base, new short[nrow]);
        }
        if (clazz == Integer.class) {
            return new IntegerArrayColumn(base, new int[nrow]);
        }
        if (clazz == Long.class) {
            return new LongArrayColumn(base, new long[nrow]);
        }
        if (clazz == Float.class) {
            return new FloatArrayColumn(base, new float[nrow]);
        }
        if (clazz == Double.class) {
            return new DoubleArrayColumn(base, new double[nrow]);
        }
        throw new IllegalArgumentException("Supplied columninfo content class is not a primitive wrapper type (it's a " + clazz.getName() + ")");
    }

    private static class DoubleArrayColumn
    extends PrimitiveArrayColumn {
        double[] data;

        DoubleArrayColumn(ColumnInfo base, double[] data) {
            super(base, data);
            this.checkContentClass(Double.class);
            this.data = data;
        }

        @Override
        void storeElement(int irow, Object val) {
            this.data[irow] = (Double)val;
        }

        @Override
        Object readElement(int irow) {
            return this.data[irow];
        }
    }

    private static class FloatArrayColumn
    extends PrimitiveArrayColumn {
        float[] data;

        FloatArrayColumn(ColumnInfo base, float[] data) {
            super(base, data);
            this.checkContentClass(Float.class);
            this.data = data;
        }

        @Override
        void storeElement(int irow, Object val) {
            this.data[irow] = ((Float)val).floatValue();
        }

        @Override
        Object readElement(int irow) {
            return Float.valueOf(this.data[irow]);
        }
    }

    private static class LongArrayColumn
    extends PrimitiveArrayColumn {
        long[] data;

        LongArrayColumn(ColumnInfo base, long[] data) {
            super(base, data);
            this.checkContentClass(Long.class);
            this.data = data;
        }

        @Override
        void storeElement(int irow, Object val) {
            this.data[irow] = (Long)val;
        }

        @Override
        Object readElement(int irow) {
            return this.data[irow];
        }
    }

    private static class IntegerArrayColumn
    extends PrimitiveArrayColumn {
        int[] data;

        IntegerArrayColumn(ColumnInfo base, int[] data) {
            super(base, data);
            this.checkContentClass(Integer.class);
            this.data = data;
        }

        @Override
        void storeElement(int irow, Object val) {
            this.data[irow] = (Integer)val;
        }

        @Override
        Object readElement(int irow) {
            return this.data[irow];
        }
    }

    private static class ShortArrayColumn
    extends PrimitiveArrayColumn {
        short[] data;

        ShortArrayColumn(ColumnInfo base, short[] data) {
            super(base, data);
            this.checkContentClass(Short.class);
            this.data = data;
        }

        @Override
        void storeElement(int irow, Object val) {
            this.data[irow] = (Short)val;
        }

        @Override
        Object readElement(int irow) {
            return this.data[irow];
        }
    }

    private static class ByteArrayColumn
    extends PrimitiveArrayColumn {
        byte[] data;

        ByteArrayColumn(ColumnInfo base, byte[] data) {
            super(base, data);
            this.checkContentClass(Byte.class);
            this.data = data;
        }

        @Override
        void storeElement(int irow, Object val) {
            this.data[irow] = (Byte)val;
        }

        @Override
        Object readElement(int irow) {
            return this.data[irow];
        }
    }

    private static class CharacterArrayColumn
    extends PrimitiveArrayColumn {
        char[] data;

        CharacterArrayColumn(ColumnInfo base, char[] data) {
            super(base, data);
            this.checkContentClass(Character.class);
            this.data = data;
        }

        @Override
        void storeElement(int irow, Object val) {
            this.data[irow] = ((Character)val).charValue();
        }

        @Override
        Object readElement(int irow) {
            return Character.valueOf(this.data[irow]);
        }
    }

    private static class BooleanArrayColumn
    extends PrimitiveArrayColumn {
        boolean[] data;

        BooleanArrayColumn(ColumnInfo base, boolean[] data) {
            super(base, data);
            this.checkContentClass(Boolean.class);
            this.data = data;
        }

        @Override
        void storeElement(int irow, Object val) {
            this.data[irow] = (Boolean)val;
        }

        @Override
        Object readElement(int irow) {
            return this.data[irow] ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

