/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.util.ArrayList;
import java.util.List;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RandomStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;

public class RowListStarTable
extends RandomStarTable {
    private final List<Object[]> rows_ = new ArrayList<Object[]>();
    private final ColumnInfo[] colInfos_;

    public RowListStarTable(ColumnInfo[] colInfos) {
        this.colInfos_ = (ColumnInfo[])colInfos.clone();
    }

    public RowListStarTable(StarTable template) {
        this(Tables.getColumnInfos(template));
        this.setName(template.getName());
        this.setParameters(new ArrayList<DescribedValue>(template.getParameters()));
    }

    @Override
    public long getRowCount() {
        return this.rows_.size();
    }

    @Override
    public int getColumnCount() {
        return this.colInfos_.length;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    @Override
    public Object getCell(long lrow, int icol) {
        return this.getRow(lrow)[icol];
    }

    @Override
    public Object[] getRow(long lrow) {
        int irow = RowListStarTable.checkedLongToInt(lrow);
        return this.rows_.get(irow);
    }

    public void setCell(long lrow, int icol, Object value) {
        this.validateCell(icol, value);
        this.getRow((long)lrow)[icol] = value;
    }

    public void setRow(long lrow, Object[] values) {
        this.validateRow(values);
        int irow = RowListStarTable.checkedLongToInt(lrow);
        this.rows_.set(irow, values);
    }

    public void addRow(Object[] values) {
        this.validateRow(values);
        this.rows_.add(values);
    }

    public void insertRow(long lrow, Object[] values) {
        this.validateRow(values);
        int irow = RowListStarTable.checkedLongToInt(lrow);
        this.rows_.add(irow, values);
    }

    public void removeRow(long lrow) {
        int irow = RowListStarTable.checkedLongToInt(lrow);
        this.rows_.remove(irow);
    }

    public void clearRows() {
        this.rows_.clear();
    }

    void validateRow(Object[] values) {
        int ncol = this.getColumnCount();
        if (values.length != ncol) {
            throw new IllegalArgumentException("Row has wrong number of columns (" + values.length + " not " + ncol + ")");
        }
        for (int icol = 0; icol < ncol; ++icol) {
            this.validateCell(icol, values[icol]);
        }
    }

    void validateCell(int icol, Object value) {
        if (value != null) {
            Class<?> valClazz = value.getClass();
            Class<?> colClazz = this.colInfos_[icol].getContentClass();
            if (!colClazz.isAssignableFrom(valClazz)) {
                throw new IllegalArgumentException("Value class incompatible with column: " + value + " is " + valClazz + " not " + colClazz);
            }
        }
    }
}

