/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import uk.ac.starlink.table.ProgressLineStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.util.Loader;
import uk.ac.starlink.util.LogUtils;

public class TableCopy {
    public static void main(String[] args) throws IOException {
        String cmdname;
        Loader.loadProperties();
        StarTableFactory treader = new StarTableFactory(false);
        StarTableOutput twriter = new StarTableOutput();
        try {
            cmdname = System.getProperty("uk.ac.starlink.table.cmdname");
        }
        catch (SecurityException e) {
            cmdname = null;
        }
        if (cmdname == null) {
            cmdname = "TableCopy";
        }
        String usage = new StringBuffer().append("\nUsage: ").append(cmdname).append(" [-disk]").append(" [-debug]").append(" [-h[elp]]").append(" [-v[erbose]]").append("\n                ").append(" [-ifmt <in-format>]").append(" [-ofmt <out-format>]").append("\n                ").append(" <in-table> <out-table>\n").toString();
        StringBuffer help = new StringBuffer(usage);
        help.append("\n   Auto-detected in-formats:\n");
        for (TableBuilder builder : treader.getDefaultBuilders()) {
            help.append("      ").append(builder.getFormatName().toLowerCase()).append('\n');
        }
        help.append("\n   Known in-formats:\n");
        for (String fmt : treader.getKnownFormats()) {
            help.append("      ").append(fmt.toLowerCase()).append('\n');
        }
        help.append("\n   Known out-formats:\n");
        for (String fmt : twriter.getKnownFormats()) {
            help.append("      ").append(fmt.toLowerCase()).append('\n');
        }
        String ifmt = null;
        String ofmt = null;
        String iloc = null;
        String oloc = null;
        boolean debug = false;
        boolean verbose = false;
        Iterator<String> it = Arrays.asList(args).iterator();
        while (it.hasNext()) {
            String arg = it.next();
            if (arg.startsWith("-") && arg.length() > 1) {
                if (arg.equals("-ifmt")) {
                    if (it.hasNext()) {
                        ifmt = it.next();
                        continue;
                    }
                    System.err.println(usage);
                    System.exit(1);
                    continue;
                }
                if (arg.equals("-ofmt")) {
                    if (it.hasNext()) {
                        ofmt = it.next();
                        continue;
                    }
                    System.err.println(usage);
                    System.exit(1);
                    continue;
                }
                if (arg.equals("-disk")) {
                    treader.setStoragePolicy(StoragePolicy.PREFER_DISK);
                    continue;
                }
                if (arg.equals("-debug")) {
                    debug = true;
                    continue;
                }
                if (arg.equals("-v") || arg.equals("-verbose")) {
                    verbose = true;
                    continue;
                }
                if (arg.equals("-h") || arg.equals("-help")) {
                    System.out.println(help);
                    return;
                }
                System.err.println(usage);
                System.exit(1);
                continue;
            }
            if (iloc == null) {
                iloc = arg;
                continue;
            }
            if (oloc == null) {
                oloc = arg;
                continue;
            }
            System.err.println(usage);
            System.exit(1);
        }
        if (verbose) {
            LogUtils.getLogger("uk.ac.starlink").setLevel(Level.INFO);
        }
        if (iloc == null || oloc == null) {
            System.err.println(usage);
            System.exit(1);
        }
        try {
            StarTable startab = treader.makeStarTable(iloc, ifmt);
            if (verbose) {
                startab = new ProgressLineStarTable(startab, System.err);
            }
            twriter.writeStarTable(startab, oloc, ofmt);
        }
        catch (IOException e) {
            if (debug) {
                e.printStackTrace(System.err);
            } else {
                System.err.println();
                String msg = e.getMessage();
                System.err.println(msg != null && msg.trim().length() > 0 ? msg : e.toString());
                System.err.println(usage);
            }
            System.exit(1);
        }
    }
}

