/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.util.regex.Pattern;
import uk.ac.starlink.table.Domain;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.TimeMapper;
import uk.ac.starlink.table.ValueInfo;

public class TimeDomain
implements Domain<TimeMapper> {
    private static final Pattern ISO8601_UNIT_PATTERN = Pattern.compile("iso.?8601", 2);
    private static final Pattern ISO8601_UCD_PATTERN = Pattern.compile("time(\\.(epoch|start|end))?(;.*)?|TIME_DATE(_.*)?", 2);
    private static final Pattern OBSCORE_T_UTYPE_PATTERN = Pattern.compile(".*Char\\.TimeAxis\\.Coverage\\.Bounds\\.Limits.*", 2);
    public static TimeDomain INSTANCE = new TimeDomain();

    private TimeDomain() {
    }

    @Override
    public String getDomainName() {
        return "Time";
    }

    public TimeMapper[] getMappers() {
        return TimeMapper.getTimeMappers();
    }

    @Override
    public TimeMapper getProbableMapper(ValueInfo info) {
        if (info == null) {
            return null;
        }
        for (DomainMapper mapper : info.getDomainMappers()) {
            if (!(mapper instanceof TimeMapper)) continue;
            return (TimeMapper)mapper;
        }
        Class<?> clazz = info.getContentClass();
        String unit = info.getUnitString();
        String ucd = info.getUCD();
        String utype = info.getUtype();
        String xtype = info.getXtype();
        if (xtype == null) {
            xtype = "";
        }
        if (unit == null) {
            unit = "";
        }
        if (ucd == null) {
            ucd = "";
        }
        if (utype == null) {
            utype = "";
        }
        unit = TimeDomain.unquote(unit.trim()).trim();
        unit = TimeDomain.unquote(unit.trim()).trim();
        if (String.class.isAssignableFrom(clazz) && ("iso8601".equals(xtype) || ISO8601_UNIT_PATTERN.matcher(xtype).matches() || "adql:TIMESTAMP".equalsIgnoreCase(xtype) || "timestamp".equalsIgnoreCase(xtype) || ISO8601_UNIT_PATTERN.matcher(unit).matches() || ISO8601_UCD_PATTERN.matcher(ucd).matches())) {
            return TimeMapper.ISO_8601;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            if ("mjd".equalsIgnoreCase(xtype) || OBSCORE_T_UTYPE_PATTERN.matcher(utype).matches() && "d".equals(unit)) {
                return TimeMapper.MJD;
            }
            if ("jd".equalsIgnoreCase(xtype)) {
                return TimeMapper.JD;
            }
            if ("yr".equals(unit) || "a".equals(unit) || "year".equals(unit)) {
                return TimeMapper.DECIMAL_YEAR;
            }
        }
        return null;
    }

    @Override
    public TimeMapper getPossibleMapper(ValueInfo info) {
        if (info == null) {
            return null;
        }
        for (DomainMapper mapper : info.getDomainMappers()) {
            if (!(mapper instanceof TimeMapper)) continue;
            return (TimeMapper)mapper;
        }
        Class<?> clazz = info.getContentClass();
        String unit = info.getUnitString();
        if (String.class.equals(clazz)) {
            return TimeMapper.ISO_8601;
        }
        if (Float.class.equals(clazz) || Double.class.equals(clazz) || Integer.class.equals(clazz) || Long.class.equals(clazz)) {
            if ("a".equals(unit) || "yr".equals(unit) || "year".equals(unit)) {
                return TimeMapper.DECIMAL_YEAR;
            }
            if ("d".equals(unit) || "day".equals(unit)) {
                return TimeMapper.MJD;
            }
            if ("s".equals(unit) || "sec".equals(unit) || "second".equals(unit)) {
                return TimeMapper.UNIX_SECONDS;
            }
            return TimeMapper.MJD;
        }
        return null;
    }

    public String toString() {
        return this.getDomainName();
    }

    private static String unquote(String str) {
        int leng = str.length();
        if (leng > 1 && (str.charAt(0) == '\'' && str.charAt(leng - 1) == '\'' || str.charAt(0) == '\"' && str.charAt(leng - 1) == '\"')) {
            return str.substring(1, leng - 1);
        }
        return str;
    }
}

