/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.formats.DocumentedStreamStarTableWriter;
import uk.ac.starlink.util.ConfigMethod;

public abstract class AbstractTextTableWriter
extends DocumentedStreamStarTableWriter {
    private boolean writeParams_;
    private int maxWidth_;
    private int maxParamLength_;
    private int sampledRows_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.formats");

    protected AbstractTextTableWriter(String[] extensions, boolean writeParams) {
        super(extensions);
        this.setWriteParameters(writeParams);
        this.setMaxWidth(160);
        this.setMaximumParameterLength(160);
    }

    @Override
    public String getFormatName() {
        return "text";
    }

    @Override
    public String getMimeType() {
        return "text/plain";
    }

    @Override
    public void writeStarTable(StarTable startab, OutputStream strm) throws IOException {
        boolean allRowsSampled;
        int ncol = startab.getColumnCount();
        ColumnInfo[] cinfos = new ColumnInfo[ncol];
        int[] cwidths = new int[ncol];
        int[] maxDataWidths = new int[ncol];
        for (int i = 0; i < ncol; ++i) {
            cinfos[i] = startab.getColumnInfo(i);
            cwidths[i] = this.getMinNameWidth(cinfos[i]);
            maxDataWidths[i] = this.getMaxDataWidth(cinfos[i].getContentClass());
        }
        int maxSamples = this.getSampledRows();
        long irow = 0L;
        logger_.config("Reading" + (maxSamples <= 0 ? " all" : "") + " rows to determine formatted column widths");
        try (RowSequence rseq = startab.getRowSequence();){
            while (rseq.next() && (maxSamples <= 0 || irow++ < (long)maxSamples)) {
                Object[] row = rseq.getRow();
                for (int ic = 0; ic < ncol; ++ic) {
                    String formatted = cinfos[ic].formatValue(row[ic], maxDataWidths[ic]);
                    if (formatted.length() <= cwidths[ic]) continue;
                    cwidths[ic] = formatted.length();
                }
            }
            allRowsSampled = !rseq.next();
        }
        if (maxSamples > 0) {
            if (allRowsSampled) {
                logger_.config("All rows sampled to determine column widths");
            } else {
                StringBuffer sbuf = new StringBuffer().append("Subset of rows (").append(irow);
                long nt = startab.getRowCount();
                if (nt >= 0L) {
                    sbuf.append("/").append(nt);
                }
                sbuf.append(") sampled to determine column widths");
                logger_.info(sbuf.toString());
            }
        }
        if (!allRowsSampled) {
            for (int icol = 0; icol < ncol; ++icol) {
                int nchar;
                int n = icol;
                cwidths[n] = cwidths[n] + 2;
                ColumnInfo cinfo = cinfos[icol];
                if (!cinfo.getContentClass().equals(String.class) || (nchar = cinfo.getElementSize()) <= 0) continue;
                cwidths[icol] = Math.max(cwidths[icol], nchar);
            }
        }
        for (int i = 0; i < ncol; ++i) {
            cwidths[i] = Math.min(this.getMaxWidth(), cwidths[i]);
        }
        if (this.writeParams_) {
            int maxleng = this.getMaximumParameterLength();
            String name = startab.getName();
            if (name != null && name.trim().length() > 0) {
                this.printParam(strm, "Table name", name, String.class);
            }
            for (DescribedValue param : startab.getParameters()) {
                ValueInfo info = param.getInfo();
                this.printParam(strm, info.getName(), param.getValueAsString(maxleng), info.getContentClass());
            }
        }
        this.printColumnHeads(strm, cwidths, cinfos);
        rseq = startab.getRowSequence();
        Throwable throwable = null;
        try {
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                String[] frow = new String[ncol];
                for (int icol = 0; icol < ncol; ++icol) {
                    frow[icol] = this.formatValue(row[icol], cinfos[icol], cwidths[icol]);
                }
                this.printLine(strm, cwidths, frow);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (rseq != null) {
                if (throwable != null) {
                    try {
                        rseq.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    rseq.close();
                }
            }
        }
        this.printSeparator(strm, cwidths);
    }

    @ConfigMethod(property="maxParam", doc="<p>Maximum width in characters of an output table parameter. Parameters with values longer than this will be truncated.</p>")
    public void setMaximumParameterLength(int maxParamLength) {
        this.maxParamLength_ = maxParamLength;
    }

    public int getMaximumParameterLength() {
        return this.maxParamLength_;
    }

    @ConfigMethod(property="params", doc="<p>Whether to output table parameters as well as row data.</p>")
    public void setWriteParameters(boolean writeParams) {
        this.writeParams_ = writeParams;
    }

    public boolean getWriteParameters() {
        return this.writeParams_;
    }

    @ConfigMethod(property="maxCell", doc="<p>Maximum width in characters of an output table cell. Cells longer than this will be truncated.</p>")
    public void setMaxWidth(int maxWidth) {
        this.maxWidth_ = maxWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth_;
    }

    public int getMinNameWidth(ColumnInfo info) {
        return info.getName().length();
    }

    @ConfigMethod(property="sampledRows", doc="<p>The number of rows examined on a first pass of the table to determine the width of each column. Only a representative number of rows needs to be examined, but if a formatted cell value after this limit is wider than the cells up to it, then such later wide cells may get truncated. If the value is &lt;=0, all rows are examined in the first pass; this is the default, but it can be configured to some other value if that takes too long.</p>")
    public void setSampledRows(int sampledRows) {
        this.sampledRows_ = sampledRows;
    }

    public int getSampledRows() {
        return this.sampledRows_;
    }

    protected abstract String formatValue(Object var1, ValueInfo var2, int var3);

    protected abstract void printSeparator(OutputStream var1, int[] var2) throws IOException;

    protected abstract void printColumnHeads(OutputStream var1, int[] var2, ColumnInfo[] var3) throws IOException;

    protected abstract void printLine(OutputStream var1, int[] var2, String[] var3) throws IOException;

    protected abstract void printParam(OutputStream var1, String var2, String var3, Class<?> var4) throws IOException;

    protected byte[] getBytes(String str) {
        int leng = str.length();
        byte[] buf = new byte[leng];
        for (int i = 0; i < leng; ++i) {
            buf[i] = (byte)str.charAt(i);
        }
        return buf;
    }

    int getMaxDataWidth(Class<?> clazz) {
        if (clazz == Double.class) {
            return 24;
        }
        if (clazz == Float.class) {
            return 16;
        }
        if (clazz == Long.class) {
            return Math.max(Long.toString(Long.MIN_VALUE).length(), Long.toString(Long.MAX_VALUE).length());
        }
        if (clazz == Integer.class) {
            return Math.max(Integer.toString(Integer.MIN_VALUE).length(), Integer.toString(Integer.MAX_VALUE).length());
        }
        if (clazz == Short.class || clazz == Byte.class || clazz == Character.class) {
            return Math.max(Short.toString((short)Short.MIN_VALUE).length(), Short.toString((short)Short.MAX_VALUE).length());
        }
        return this.getMaxWidth();
    }
}

